/*
 * Decompiled with CFR 0.152.
 */
package sun.swing;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.Serializable;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.border.BevelBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.filechooser.FileSystemView;
import sun.awt.shell.ShellFolder;

public class WindowsPlacesBar
extends JToolBar
implements ActionListener,
PropertyChangeListener {
    JFileChooser fc;
    JToggleButton[] buttons;
    ButtonGroup buttonGroup;
    File[] files;
    final Dimension buttonSize;

    public WindowsPlacesBar(JFileChooser jFileChooser, boolean bl2) {
        super(1);
        boolean bl3;
        this.fc = jFileChooser;
        this.setFloatable(false);
        this.putClientProperty("JToolBar.isRollover", Boolean.TRUE);
        boolean bl4 = bl3 = System.getProperty("os.name").startsWith("Windows") && System.getProperty("os.version").compareTo("5.1") >= 0;
        if (bl2) {
            this.buttonSize = new Dimension(83, 69);
            this.putClientProperty("XPStyle.subClass", "placesbar");
            this.setBorder(new EmptyBorder(1, 1, 1, 1));
        } else {
            this.buttonSize = new Dimension(83, bl3 ? 65 : 54);
            this.setBorder(new BevelBorder(1, UIManager.getColor("ToolBar.highlight"), UIManager.getColor("ToolBar.background"), UIManager.getColor("ToolBar.darkShadow"), UIManager.getColor("ToolBar.shadow")));
        }
        Color color = new Color(UIManager.getColor("ToolBar.shadow").getRGB());
        this.setBackground(color);
        FileSystemView fileSystemView = jFileChooser.getFileSystemView();
        this.files = (File[])ShellFolder.get("fileChooserShortcutPanelFolders");
        this.buttons = new JToggleButton[this.files.length];
        this.buttonGroup = new ButtonGroup();
        for (int i2 = 0; i2 < this.files.length; ++i2) {
            Serializable serializable;
            String string;
            int n2;
            if (fileSystemView.isFileSystemRoot(this.files[i2])) {
                this.files[i2] = fileSystemView.createFileObject(this.files[i2].getAbsolutePath());
            }
            if ((n2 = (string = fileSystemView.getSystemDisplayName(this.files[i2])).lastIndexOf(File.separatorChar)) >= 0 && n2 < string.length() - 1) {
                string = string.substring(n2 + 1);
            }
            Icon icon = null;
            if (this.files[i2] instanceof ShellFolder) {
                serializable = (ShellFolder)this.files[i2];
                icon = new ImageIcon(serializable.getIcon(true), serializable.getFolderType());
            } else {
                icon = fileSystemView.getSystemIcon(this.files[i2]);
            }
            this.buttons[i2] = new JToggleButton(string, icon);
            if (bl3) {
                this.buttons[i2].setIconTextGap(2);
                this.buttons[i2].setMargin(new Insets(2, 2, 2, 2));
                this.buttons[i2].setText("<html><center>" + string + "</center></html>");
            }
            if (!bl2) {
                serializable = new Color(UIManager.getColor("List.selectionForeground").getRGB());
                this.buttons[i2].setBackground(color);
                this.buttons[i2].setForeground((Color)serializable);
            }
            this.buttons[i2].setHorizontalTextPosition(0);
            this.buttons[i2].setVerticalTextPosition(3);
            this.buttons[i2].setAlignmentX(0.5f);
            this.buttons[i2].setPreferredSize(this.buttonSize);
            this.buttons[i2].setMaximumSize(this.buttonSize);
            this.buttons[i2].addActionListener(this);
            this.add(this.buttons[i2]);
            if (i2 < this.files.length - 1 && bl2) {
                this.add(Box.createRigidArea(new Dimension(1, 1)));
            }
            this.buttonGroup.add(this.buttons[i2]);
        }
        this.doDirectoryChanged(jFileChooser.getCurrentDirectory());
    }

    protected void doDirectoryChanged(File file) {
        for (int i2 = 0; i2 < this.buttons.length; ++i2) {
            JToggleButton jToggleButton = this.buttons[i2];
            if (this.files[i2].equals(file)) {
                jToggleButton.setSelected(true);
                break;
            }
            if (!jToggleButton.isSelected()) continue;
            this.buttonGroup.remove(jToggleButton);
            jToggleButton.setSelected(false);
            this.buttonGroup.add(jToggleButton);
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string == "directoryChanged") {
            this.doDirectoryChanged(this.fc.getCurrentDirectory());
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        JToggleButton jToggleButton = (JToggleButton)actionEvent.getSource();
        for (int i2 = 0; i2 < this.buttons.length; ++i2) {
            if (jToggleButton != this.buttons[i2]) continue;
            this.fc.setCurrentDirectory(this.files[i2]);
            break;
        }
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getMinimumSize();
        Dimension dimension2 = super.getPreferredSize();
        if (dimension.height > dimension2.height) {
            dimension2 = new Dimension(dimension2.width, dimension.height);
        }
        return dimension2;
    }
}

