/*
 * Decompiled with CFR 0.152.
 */
package java.rmi.activation;

import java.rmi.MarshalledObject;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.activation.ActivationDesc;
import java.rmi.activation.ActivationException;
import java.rmi.activation.ActivationGroup;
import java.rmi.activation.ActivationID;
import java.rmi.activation.UnknownGroupException;
import java.rmi.activation.UnknownObjectException;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.RemoteServer;
import sun.rmi.server.ActivatableRef;
import sun.rmi.server.ActivatableServerRef;
import sun.rmi.transport.ObjectTable;

public abstract class Activatable
extends RemoteServer {
    private ActivationID id;
    private static final long serialVersionUID = -3120617863591563455L;

    protected Activatable(String string, MarshalledObject marshalledObject, boolean bl2, int n2) throws ActivationException, RemoteException {
        this.id = Activatable.exportObject((Remote)this, string, marshalledObject, bl2, n2);
    }

    protected Activatable(String string, MarshalledObject marshalledObject, boolean bl2, int n2, RMIClientSocketFactory rMIClientSocketFactory, RMIServerSocketFactory rMIServerSocketFactory) throws ActivationException, RemoteException {
        this.id = Activatable.exportObject(this, string, marshalledObject, bl2, n2, rMIClientSocketFactory, rMIServerSocketFactory);
    }

    protected Activatable(ActivationID activationID, int n2) throws RemoteException {
        this.id = activationID;
        Activatable.exportObject(this, activationID, n2);
    }

    protected Activatable(ActivationID activationID, int n2, RMIClientSocketFactory rMIClientSocketFactory, RMIServerSocketFactory rMIServerSocketFactory) throws RemoteException {
        this.id = activationID;
        Activatable.exportObject((Remote)this, activationID, n2, rMIClientSocketFactory, rMIServerSocketFactory);
    }

    protected ActivationID getID() {
        return this.id;
    }

    public static Remote register(ActivationDesc activationDesc) throws UnknownGroupException, ActivationException, RemoteException {
        ActivationID activationID = ActivationGroup.getSystem().registerObject(activationDesc);
        return ActivatableRef.getStub(activationDesc, activationID);
    }

    public static boolean inactive(ActivationID activationID) throws UnknownObjectException, ActivationException, RemoteException {
        return ActivationGroup.currentGroup().inactiveObject(activationID);
    }

    public static void unregister(ActivationID activationID) throws UnknownObjectException, ActivationException, RemoteException {
        ActivationGroup.getSystem().unregisterObject(activationID);
    }

    public static ActivationID exportObject(Remote remote, String string, MarshalledObject marshalledObject, boolean bl2, int n2) throws ActivationException, RemoteException {
        ActivationDesc activationDesc = new ActivationDesc(remote.getClass().getName(), string, marshalledObject, bl2);
        ActivationID activationID = ActivationGroup.getSystem().registerObject(activationDesc);
        Remote remote2 = Activatable.exportObject(remote, activationID, n2);
        ActivationGroup.currentGroup().activeObject(activationID, remote);
        return activationID;
    }

    public static ActivationID exportObject(Remote remote, String string, MarshalledObject marshalledObject, boolean bl2, int n2, RMIClientSocketFactory rMIClientSocketFactory, RMIServerSocketFactory rMIServerSocketFactory) throws ActivationException, RemoteException {
        ActivationDesc activationDesc = new ActivationDesc(remote.getClass().getName(), string, marshalledObject, bl2);
        ActivationID activationID = ActivationGroup.getSystem().registerObject(activationDesc);
        Remote remote2 = Activatable.exportObject(remote, activationID, n2, rMIClientSocketFactory, rMIServerSocketFactory);
        ActivationGroup.currentGroup().activeObject(activationID, remote);
        return activationID;
    }

    public static Remote exportObject(Remote remote, ActivationID activationID, int n2) throws RemoteException {
        return Activatable.exportObject(remote, new ActivatableServerRef(activationID, n2));
    }

    public static Remote exportObject(Remote remote, ActivationID activationID, int n2, RMIClientSocketFactory rMIClientSocketFactory, RMIServerSocketFactory rMIServerSocketFactory) throws RemoteException {
        return Activatable.exportObject(remote, new ActivatableServerRef(activationID, n2, rMIClientSocketFactory, rMIServerSocketFactory));
    }

    public static boolean unexportObject(Remote remote, boolean bl2) throws NoSuchObjectException {
        return ObjectTable.unexportObject(remote, bl2);
    }

    private static Remote exportObject(Remote remote, ActivatableServerRef activatableServerRef) throws RemoteException {
        if (remote instanceof Activatable) {
            ((Activatable)remote).ref = activatableServerRef;
        }
        return activatableServerRef.exportObject(remote, null, false);
    }
}

