/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import sun.nio.cs.HistoricallyNamedCharset;
import sun.nio.cs.StandardCharsets;
import sun.nio.cs.Surrogate;
import sun.nio.cs.US_ASCII;

class ISO_8859_1
extends Charset
implements HistoricallyNamedCharset {
    public ISO_8859_1() {
        super("ISO-8859-1", StandardCharsets.aliases_ISO_8859_1);
    }

    public String historicalName() {
        return "ISO8859_1";
    }

    public boolean contains(Charset charset) {
        return charset instanceof US_ASCII || charset instanceof ISO_8859_1;
    }

    public CharsetDecoder newDecoder() {
        return new Decoder(this);
    }

    public CharsetEncoder newEncoder() {
        return new Encoder(this);
    }

    private static class Decoder
    extends CharsetDecoder {
        private Decoder(Charset charset) {
            super(charset, 1.0f, 1.0f);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private CoderResult decodeArrayLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
            byte[] byArray = byteBuffer.array();
            int n2 = byteBuffer.arrayOffset() + byteBuffer.position();
            int n3 = byteBuffer.arrayOffset() + byteBuffer.limit();
            assert (n2 <= n3);
            char[] cArray = charBuffer.array();
            int n4 = charBuffer.arrayOffset() + charBuffer.position();
            int n5 = charBuffer.arrayOffset() + charBuffer.limit();
            assert (n4 <= n5);
            n4 = n4 <= n5 ? n4 : n5;
            try {
                for (n2 = n2 <= n3 ? n2 : n3; n2 < n3; ++n2) {
                    byte by = byArray[n2];
                    if (n4 >= n5) {
                        CoderResult coderResult = CoderResult.OVERFLOW;
                        return coderResult;
                    }
                    cArray[n4++] = (char)(by & 0xFF);
                }
                CoderResult coderResult = CoderResult.UNDERFLOW;
                return coderResult;
            }
            finally {
                byteBuffer.position(n2 - byteBuffer.arrayOffset());
                charBuffer.position(n4 - charBuffer.arrayOffset());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private CoderResult decodeBufferLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
            int n2 = byteBuffer.position();
            try {
                while (byteBuffer.hasRemaining()) {
                    byte by = byteBuffer.get();
                    if (!charBuffer.hasRemaining()) {
                        CoderResult coderResult = CoderResult.OVERFLOW;
                        return coderResult;
                    }
                    charBuffer.put((char)(by & 0xFF));
                    ++n2;
                }
                CoderResult coderResult = CoderResult.UNDERFLOW;
                return coderResult;
            }
            finally {
                byteBuffer.position(n2);
            }
        }

        protected CoderResult decodeLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
            if (byteBuffer.hasArray() && charBuffer.hasArray()) {
                return this.decodeArrayLoop(byteBuffer, charBuffer);
            }
            return this.decodeBufferLoop(byteBuffer, charBuffer);
        }
    }

    private static class Encoder
    extends CharsetEncoder {
        private final Surrogate.Parser sgp = new Surrogate.Parser();

        private Encoder(Charset charset) {
            super(charset, 1.0f, 1.0f);
        }

        public boolean canEncode(char c2) {
            return c2 <= '\u00ff';
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private CoderResult encodeArrayLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
            char[] cArray = charBuffer.array();
            int n2 = charBuffer.arrayOffset() + charBuffer.position();
            int n3 = charBuffer.arrayOffset() + charBuffer.limit();
            assert (n2 <= n3);
            byte[] byArray = byteBuffer.array();
            int n4 = byteBuffer.arrayOffset() + byteBuffer.position();
            int n5 = byteBuffer.arrayOffset() + byteBuffer.limit();
            assert (n4 <= n5);
            n4 = n4 <= n5 ? n4 : n5;
            try {
                for (n2 = n2 <= n3 ? n2 : n3; n2 < n3; ++n2) {
                    char c2 = cArray[n2];
                    if (c2 <= '\u00ff') {
                        if (n4 >= n5) {
                            CoderResult coderResult = CoderResult.OVERFLOW;
                            return coderResult;
                        }
                        byArray[n4++] = (byte)c2;
                        continue;
                    }
                    if (this.sgp.parse(c2, cArray, n2, n3) < 0) {
                        CoderResult coderResult = this.sgp.error();
                        return coderResult;
                    }
                    CoderResult coderResult = this.sgp.unmappableResult();
                    return coderResult;
                }
                CoderResult coderResult = CoderResult.UNDERFLOW;
                return coderResult;
            }
            finally {
                charBuffer.position(n2 - charBuffer.arrayOffset());
                byteBuffer.position(n4 - byteBuffer.arrayOffset());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private CoderResult encodeBufferLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
            int n2 = charBuffer.position();
            try {
                while (charBuffer.hasRemaining()) {
                    char c2 = charBuffer.get();
                    if (c2 <= '\u00ff') {
                        if (!byteBuffer.hasRemaining()) {
                            CoderResult coderResult = CoderResult.OVERFLOW;
                            return coderResult;
                        }
                        byteBuffer.put((byte)c2);
                        ++n2;
                        continue;
                    }
                    if (this.sgp.parse(c2, charBuffer) < 0) {
                        CoderResult coderResult = this.sgp.error();
                        return coderResult;
                    }
                    CoderResult coderResult = this.sgp.unmappableResult();
                    return coderResult;
                }
                CoderResult coderResult = CoderResult.UNDERFLOW;
                return coderResult;
            }
            finally {
                charBuffer.position(n2);
            }
        }

        protected CoderResult encodeLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
            if (charBuffer.hasArray() && byteBuffer.hasArray()) {
                return this.encodeArrayLoop(charBuffer, byteBuffer);
            }
            return this.encodeBufferLoop(charBuffer, byteBuffer);
        }
    }
}

