/*
 * Decompiled with CFR 0.152.
 */
package sun.font;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GraphicsEnvironment;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import sun.font.Font2D;
import sun.font.FontManager;
import sun.font.FontStrike;
import sun.font.StrikeMetrics;

public final class FontDesignMetrics
extends FontMetrics {
    static final long serialVersionUID = 4480069578560887773L;
    private static final float UNKNOWN_WIDTH = -1.0f;
    private static final int CURRENT_VERSION = 1;
    private static float roundingUpValue = 0.95f;
    private Font font;
    private float ascent;
    private float descent;
    private float leading;
    private float maxAdvance;
    private double[] matrix;
    private int[] cache;
    private int serVersion = 0;
    private boolean isAntiAliased;
    private boolean usesFractionalMetrics;
    private AffineTransform frcTx;
    private transient float[] advCache;
    private transient int height = -1;
    private transient FontRenderContext frc;
    private transient double[] devmatrix = null;
    private transient FontStrike fontStrike;
    private static FontRenderContext DEFAULT_FRC = null;

    private static FontRenderContext createDefaultFrc() {
        if (DEFAULT_FRC == null) {
            AffineTransform affineTransform = GraphicsEnvironment.isHeadless() ? new AffineTransform() : GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().getDefaultTransform();
            DEFAULT_FRC = new FontRenderContext(affineTransform, false, false);
        }
        return DEFAULT_FRC;
    }

    public FontDesignMetrics(Font font) {
        this(font, FontDesignMetrics.createDefaultFrc());
    }

    public FontDesignMetrics(Font font, FontRenderContext fontRenderContext) {
        super(font);
        this.font = font;
        this.frc = fontRenderContext;
        this.isAntiAliased = fontRenderContext.isAntiAliased();
        this.usesFractionalMetrics = fontRenderContext.usesFractionalMetrics();
        this.frcTx = fontRenderContext.getTransform();
        this.matrix = new double[4];
        this.initMatrixAndMetrics();
        this.initAdvCache();
    }

    private void initMatrixAndMetrics() {
        Font2D font2D = FontManager.getFont2D(this.font);
        this.fontStrike = font2D.getStrike(this.font, this.frc);
        StrikeMetrics strikeMetrics = this.fontStrike.getFontMetrics();
        this.ascent = strikeMetrics.getAscent();
        this.descent = strikeMetrics.getDescent();
        this.leading = strikeMetrics.getLeading();
        this.maxAdvance = strikeMetrics.getMaxAdvance();
        this.devmatrix = new double[4];
        this.frcTx.getMatrix(this.devmatrix);
    }

    private void initAdvCache() {
        this.advCache = new float[256];
        for (int i2 = 0; i2 < 256; ++i2) {
            this.advCache[i2] = -1.0f;
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.serVersion != 1) {
            this.frc = FontDesignMetrics.createDefaultFrc();
            this.isAntiAliased = this.frc.isAntiAliased();
            this.usesFractionalMetrics = this.frc.usesFractionalMetrics();
            this.frcTx = this.frc.getTransform();
        } else {
            this.frc = new FontRenderContext(this.frcTx, this.isAntiAliased, this.usesFractionalMetrics);
        }
        this.height = -1;
        this.cache = null;
        this.initMatrixAndMetrics();
        this.initAdvCache();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        this.cache = new int[256];
        for (int i2 = 0; i2 < 256; ++i2) {
            this.cache[i2] = -1;
        }
        this.serVersion = 1;
        objectOutputStream.defaultWriteObject();
        this.cache = null;
    }

    private float handleCharWidth(int n2) {
        return this.fontStrike.getCodePointAdvance(n2);
    }

    private float getLatinCharWidth(char c2) {
        float f2 = this.advCache[c2];
        if (f2 == -1.0f) {
            this.advCache[c2] = f2 = this.handleCharWidth(c2);
        }
        return f2;
    }

    public FontRenderContext getFRC() {
        return this.frc;
    }

    public int charWidth(char c2) {
        float f2 = c2 < '\u0100' ? this.getLatinCharWidth(c2) : this.handleCharWidth(c2);
        return (int)(0.5 + (double)f2);
    }

    public int charWidth(int n2) {
        if (!Character.isValidCodePoint(n2)) {
            n2 = 65535;
        }
        float f2 = this.handleCharWidth(n2);
        return (int)(0.5 + (double)f2);
    }

    private boolean requiresLayout(char c2) {
        return c2 >= '\u0590' && c2 < '\u0e80' || c2 >= '\u202a' && c2 < '\u202f' || c2 >= '\ud800' && c2 < '\ue000';
    }

    public int stringWidth(String string) {
        int n2 = string.length();
        float f2 = 0.0f;
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            if (c2 < '\u0100') {
                f2 += this.getLatinCharWidth(c2);
                continue;
            }
            if (this.requiresLayout(c2)) {
                f2 = new TextLayout(string, this.font, this.frc).getAdvance();
                break;
            }
            f2 += this.handleCharWidth(c2);
        }
        return (int)(0.5 + (double)f2);
    }

    public int charsWidth(char[] cArray, int n2, int n3) {
        float f2 = 0.0f;
        int n4 = n2 + n3;
        for (int i2 = n2; i2 < n4; ++i2) {
            char c2 = cArray[i2];
            if (c2 < '\u0100') {
                f2 += this.getLatinCharWidth(c2);
                continue;
            }
            if (this.requiresLayout(c2)) {
                String string = new String(cArray, n2, n3);
                f2 = new TextLayout(string, this.font, this.frc).getAdvance();
                break;
            }
            f2 += this.handleCharWidth(c2);
        }
        return (int)(0.5 + (double)f2);
    }

    public int[] getWidths() {
        int[] nArray = new int[256];
        for (int n2 = 0; n2 < 256; n2 = (int)((char)(n2 + 1))) {
            float f2 = this.advCache[n2];
            if (f2 == -1.0f) {
                f2 = this.advCache[n2] = this.handleCharWidth(n2);
            }
            nArray[n2] = (int)(0.5 + (double)f2);
        }
        return nArray;
    }

    public int getMaxAdvance() {
        return (int)(0.99f + this.maxAdvance);
    }

    public int getAscent() {
        return (int)(roundingUpValue + this.ascent);
    }

    public int getDescent() {
        return (int)(roundingUpValue + this.descent);
    }

    public int getLeading() {
        return (int)(roundingUpValue + this.descent + this.leading) - (int)(roundingUpValue + this.descent);
    }

    public int getHeight() {
        if (this.height < 0) {
            this.height = this.getAscent() + (int)(roundingUpValue + this.descent + this.leading);
        }
        return this.height;
    }
}

