/*
 * Decompiled with CFR 0.152.
 */
package com.sun.security.auth.module;

import com.sun.security.auth.SolarisNumericGroupPrincipal;
import com.sun.security.auth.SolarisNumericUserPrincipal;
import com.sun.security.auth.SolarisPrincipal;
import com.sun.security.auth.module.SolarisSystem;
import java.util.LinkedList;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class SolarisLoginModule
implements LoginModule {
    private Subject subject;
    private CallbackHandler callbackHandler;
    private Map sharedState;
    private Map options;
    private boolean debug = true;
    private SolarisSystem ss;
    private boolean succeeded = false;
    private boolean commitSucceeded = false;
    private SolarisPrincipal userPrincipal;
    private SolarisNumericUserPrincipal UIDPrincipal;
    private SolarisNumericGroupPrincipal GIDPrincipal;
    private LinkedList supplementaryGroups = new LinkedList();

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> map, Map<String, ?> map2) {
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.sharedState = map;
        this.options = map2;
        this.debug = "true".equalsIgnoreCase((String)map2.get("debug"));
    }

    @Override
    public boolean login() throws LoginException {
        int n2;
        long[] lArray = null;
        this.ss = new SolarisSystem();
        if (this.ss == null) {
            this.succeeded = false;
            throw new FailedLoginException("Failed in attempt to import the underlying system identity information");
        }
        this.userPrincipal = new SolarisPrincipal(this.ss.getUsername());
        this.UIDPrincipal = new SolarisNumericUserPrincipal(this.ss.getUid());
        this.GIDPrincipal = new SolarisNumericGroupPrincipal(this.ss.getGid(), true);
        if (this.ss.getGroups() != null && this.ss.getGroups().length > 0) {
            lArray = this.ss.getGroups();
        }
        for (n2 = 0; n2 < lArray.length; ++n2) {
            SolarisNumericGroupPrincipal solarisNumericGroupPrincipal = new SolarisNumericGroupPrincipal(lArray[n2], false);
            if (solarisNumericGroupPrincipal.getName().equals(this.GIDPrincipal.getName())) continue;
            this.supplementaryGroups.add(solarisNumericGroupPrincipal);
        }
        if (this.debug) {
            System.out.println("\t\t[SolarisLoginModule]: succeeded importing info: ");
            System.out.println("\t\t\tuid = " + this.ss.getUid());
            System.out.println("\t\t\tgid = " + this.ss.getGid());
            lArray = this.ss.getGroups();
            for (n2 = 0; n2 < lArray.length; ++n2) {
                System.out.println("\t\t\tsupp gid = " + lArray[n2]);
            }
        }
        this.succeeded = true;
        return true;
    }

    @Override
    public boolean commit() throws LoginException {
        if (!this.succeeded) {
            if (this.debug) {
                System.out.println("\t\t[SolarisLoginModule]: did not add any Principals to Subject because own authentication failed.");
            }
            return false;
        }
        if (this.subject.isReadOnly()) {
            throw new LoginException("Subject is Readonly");
        }
        if (!this.subject.getPrincipals().contains(this.userPrincipal)) {
            this.subject.getPrincipals().add(this.userPrincipal);
        }
        if (!this.subject.getPrincipals().contains(this.UIDPrincipal)) {
            this.subject.getPrincipals().add(this.UIDPrincipal);
        }
        if (!this.subject.getPrincipals().contains(this.GIDPrincipal)) {
            this.subject.getPrincipals().add(this.GIDPrincipal);
        }
        for (int i2 = 0; i2 < this.supplementaryGroups.size(); ++i2) {
            if (this.subject.getPrincipals().contains((SolarisNumericGroupPrincipal)this.supplementaryGroups.get(i2))) continue;
            this.subject.getPrincipals().add((SolarisNumericGroupPrincipal)this.supplementaryGroups.get(i2));
        }
        if (this.debug) {
            System.out.println("\t\t[SolarisLoginModule]: added SolarisPrincipal,");
            System.out.println("\t\t\t\tSolarisNumericUserPrincipal,");
            System.out.println("\t\t\t\tSolarisNumericGroupPrincipal(s),");
            System.out.println("\t\t\t to Subject");
        }
        this.commitSucceeded = true;
        return true;
    }

    @Override
    public boolean abort() throws LoginException {
        if (this.debug) {
            System.out.println("\t\t[SolarisLoginModule]: aborted authentication attempt");
        }
        if (!this.succeeded) {
            return false;
        }
        if (this.succeeded && !this.commitSucceeded) {
            this.succeeded = false;
            this.ss = null;
            this.userPrincipal = null;
            this.UIDPrincipal = null;
            this.GIDPrincipal = null;
            this.supplementaryGroups = new LinkedList();
        } else {
            this.logout();
        }
        return true;
    }

    @Override
    public boolean logout() throws LoginException {
        if (this.debug) {
            System.out.println("\t\t[SolarisLoginModule]: Entering logout");
        }
        if (this.subject.isReadOnly()) {
            throw new LoginException("Subject is Readonly");
        }
        this.subject.getPrincipals().remove(this.userPrincipal);
        this.subject.getPrincipals().remove(this.UIDPrincipal);
        this.subject.getPrincipals().remove(this.GIDPrincipal);
        for (int i2 = 0; i2 < this.supplementaryGroups.size(); ++i2) {
            this.subject.getPrincipals().remove((SolarisNumericGroupPrincipal)this.supplementaryGroups.get(i2));
        }
        this.ss = null;
        this.succeeded = false;
        this.commitSucceeded = false;
        this.userPrincipal = null;
        this.UIDPrincipal = null;
        this.GIDPrincipal = null;
        this.supplementaryGroups = new LinkedList();
        if (this.debug) {
            System.out.println("\t\t[SolarisLoginModule]: logged out Subject");
        }
        return true;
    }
}

