/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.FastShortMessage;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.SysexMessage;
import javax.sound.midi.Track;

class SMFParser {
    private static final int MTrk_MAGIC = 1297379947;
    private static final boolean STRICT_PARSER = false;
    private static final boolean DEBUG = false;
    int tracks;
    DataInputStream stream;
    private int trackLength = 0;
    private byte[] trackData = null;
    private int pos = 0;

    private int readUnsigned() throws IOException {
        return this.trackData[this.pos++] & 0xFF;
    }

    private void read(byte[] byArray) throws IOException {
        System.arraycopy(this.trackData, this.pos, byArray, 0, byArray.length);
        this.pos += byArray.length;
    }

    private long readVarInt() throws IOException {
        long l2 = 0L;
        int n2 = 0;
        do {
            n2 = this.trackData[this.pos++] & 0xFF;
            l2 = (l2 << 7) + (long)(n2 & 0x7F);
        } while ((n2 & 0x80) != 0);
        return l2;
    }

    private int readIntFromStream() throws IOException {
        try {
            return this.stream.readInt();
        }
        catch (EOFException eOFException) {
            throw new EOFException("invalid MIDI file");
        }
    }

    boolean nextTrack() throws IOException, InvalidMidiDataException {
        int n2;
        this.trackLength = 0;
        do {
            if (this.stream.skipBytes(this.trackLength) != this.trackLength) {
                return false;
            }
            n2 = this.readIntFromStream();
            this.trackLength = this.readIntFromStream();
        } while (n2 != 1297379947);
        if (this.trackLength < 0) {
            return false;
        }
        this.trackData = new byte[this.trackLength];
        try {
            this.stream.readFully(this.trackData);
        }
        catch (EOFException eOFException) {
            return false;
        }
        this.pos = 0;
        return true;
    }

    private boolean trackFinished() {
        return this.pos >= this.trackLength;
    }

    void readTrack(Track track) throws IOException, InvalidMidiDataException {
        try {
            long l2 = 0L;
            int n2 = 0;
            boolean bl2 = false;
            while (!this.trackFinished() && !bl2) {
                MidiMessage midiMessage;
                int n3 = -1;
                int n4 = 0;
                l2 += this.readVarInt();
                int n5 = this.readUnsigned();
                if (n5 >= 128) {
                    n2 = n5;
                } else {
                    n3 = n5;
                }
                block1 : switch (n2 & 0xF0) {
                    case 128: 
                    case 144: 
                    case 160: 
                    case 176: 
                    case 224: {
                        if (n3 == -1) {
                            n3 = this.readUnsigned();
                        }
                        n4 = this.readUnsigned();
                        midiMessage = new FastShortMessage(n2 | n3 << 8 | n4 << 16);
                        break;
                    }
                    case 192: 
                    case 208: {
                        if (n3 == -1) {
                            n3 = this.readUnsigned();
                        }
                        midiMessage = new FastShortMessage(n2 | n3 << 8);
                        break;
                    }
                    case 240: {
                        switch (n2) {
                            case 240: 
                            case 247: {
                                int n6 = (int)this.readVarInt();
                                byte[] byArray = new byte[n6];
                                this.read(byArray);
                                SysexMessage sysexMessage = new SysexMessage();
                                sysexMessage.setMessage(n2, byArray, n6);
                                midiMessage = sysexMessage;
                                break block1;
                            }
                            case 255: {
                                int n7 = this.readUnsigned();
                                int n8 = (int)this.readVarInt();
                                byte[] byArray = new byte[n8];
                                this.read(byArray);
                                MetaMessage metaMessage = new MetaMessage();
                                metaMessage.setMessage(n7, byArray, n8);
                                midiMessage = metaMessage;
                                if (n7 != 47) break block1;
                                bl2 = true;
                                break block1;
                            }
                            default: {
                                throw new InvalidMidiDataException("Invalid status byte: " + n2);
                            }
                        }
                    }
                    default: {
                        throw new InvalidMidiDataException("Invalid status byte: " + n2);
                    }
                }
                track.add(new MidiEvent(midiMessage, l2));
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new EOFException("invalid MIDI file");
        }
    }
}

