/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import java.util.ArrayList;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.Sequence;
import javax.sound.midi.Track;

public class MidiUtils {
    public static final int DEFAULT_TEMPO_MPQ = 500000;
    public static final int META_END_OF_TRACK_TYPE = 47;
    public static final int META_TEMPO_TYPE = 81;

    public static boolean isMetaEndOfTrack(MidiMessage midiMessage) {
        if (midiMessage.getLength() != 3 || midiMessage.getStatus() != 255) {
            return false;
        }
        byte[] byArray = midiMessage.getMessage();
        return (byArray[1] & 0xFF) == 47 && byArray[2] == 0;
    }

    public static boolean isMetaTempo(MidiMessage midiMessage) {
        if (midiMessage.getLength() != 6 || midiMessage.getStatus() != 255) {
            return false;
        }
        byte[] byArray = midiMessage.getMessage();
        return (byArray[1] & 0xFF) == 81 && byArray[2] == 3;
    }

    public static int getTempoMPQ(MidiMessage midiMessage) {
        if (midiMessage.getLength() != 6 || midiMessage.getStatus() != 255) {
            return -1;
        }
        byte[] byArray = midiMessage.getMessage();
        if ((byArray[1] & 0xFF) != 81 || byArray[2] != 3) {
            return -1;
        }
        int n2 = byArray[5] & 0xFF | (byArray[4] & 0xFF) << 8 | (byArray[3] & 0xFF) << 16;
        return n2;
    }

    public static double convertTempo(double d2) {
        if (d2 <= 0.0) {
            d2 = 1.0;
        }
        return 6.0E7 / d2;
    }

    public static long ticks2microsec(long l2, double d2, int n2) {
        return (long)((double)l2 * d2 / (double)n2);
    }

    public static long microsec2ticks(long l2, double d2, int n2) {
        return (long)((double)l2 * (double)n2 / d2);
    }

    public static long tick2microsecond(Sequence sequence, long l2, TempoCache tempoCache) {
        if (sequence.getDivisionType() != 0.0f) {
            double d2 = (double)l2 / (double)(sequence.getDivisionType() * (float)sequence.getResolution());
            return (long)(1000000.0 * d2);
        }
        if (tempoCache == null) {
            tempoCache = new TempoCache(sequence);
        }
        int n2 = sequence.getResolution();
        long[] lArray = tempoCache.ticks;
        int[] nArray = tempoCache.tempos;
        int n3 = nArray.length;
        int n4 = tempoCache.snapshotIndex;
        int n5 = tempoCache.snapshotMicro;
        long l3 = 0L;
        if (n4 <= 0 || n4 >= n3 || lArray[n4] > l2) {
            n5 = 0;
            n4 = 0;
        }
        if (n3 > 0) {
            int n6 = n4 + 1;
            while (n6 < n3 && lArray[n6] <= l2) {
                n5 = (int)((long)n5 + MidiUtils.ticks2microsec(lArray[n6] - lArray[n6 - 1], nArray[n6 - 1], n2));
                n4 = n6++;
            }
            l3 = (long)n5 + MidiUtils.ticks2microsec(l2 - lArray[n4], nArray[n4], n2);
        }
        tempoCache.snapshotIndex = n4;
        tempoCache.snapshotMicro = n5;
        return l3;
    }

    public static long microsecond2tick(Sequence sequence, long l2, TempoCache tempoCache) {
        int n2;
        if (sequence.getDivisionType() != 0.0f) {
            double d2 = (double)l2 * (double)sequence.getDivisionType() * (double)sequence.getResolution() / 1000000.0;
            long l3 = (long)d2;
            if (tempoCache != null) {
                tempoCache.currTempo = (int)tempoCache.getTempoMPQAt(l3);
            }
            return l3;
        }
        if (tempoCache == null) {
            tempoCache = new TempoCache(sequence);
        }
        long[] lArray = tempoCache.ticks;
        int[] nArray = tempoCache.tempos;
        int n3 = nArray.length;
        int n4 = sequence.getResolution();
        long l4 = 0L;
        long l5 = 0L;
        boolean bl2 = false;
        if (l2 > 0L && n3 > 0) {
            long l6;
            for (n2 = 1; n2 < n3 && (l6 = l4 + MidiUtils.ticks2microsec(lArray[n2] - lArray[n2 - 1], nArray[n2 - 1], n4)) <= l2; ++n2) {
                l4 = l6;
            }
            l5 = lArray[n2 - 1] + MidiUtils.microsec2ticks(l2 - l4, nArray[n2 - 1], n4);
        }
        tempoCache.currTempo = nArray[n2 - 1];
        return l5;
    }

    public static int tick2index(Track track, long l2) {
        int n2 = 0;
        if (l2 > 0L) {
            long l3;
            int n3 = 0;
            int n4 = track.size() - 1;
            while (n3 < n4 && (l3 = track.get(n2 = n3 + n4 >> 1).getTick()) != l2) {
                if (l3 < l2) {
                    if (n3 == n4 - 1) {
                        ++n2;
                        break;
                    }
                    n3 = n2;
                    continue;
                }
                n4 = n2;
            }
        }
        return n2;
    }

    public static class TempoCache {
        long[] ticks = new long[1];
        int[] tempos = new int[1];
        int snapshotIndex = 0;
        int snapshotMicro = 0;
        int currTempo;
        private boolean firstTempoIsFake = false;

        public TempoCache() {
            this.tempos[0] = 500000;
            this.snapshotIndex = 0;
            this.snapshotMicro = 0;
        }

        public TempoCache(Sequence sequence) {
            this();
            this.refresh(sequence);
        }

        public synchronized void refresh(Sequence sequence) {
            MidiEvent midiEvent;
            int n2;
            int n3;
            ArrayList<MidiEvent> arrayList = new ArrayList<MidiEvent>();
            Track[] trackArray = sequence.getTracks();
            if (trackArray.length > 0) {
                Track track = trackArray[0];
                n3 = track.size();
                for (n2 = 0; n2 < n3; ++n2) {
                    midiEvent = track.get(n2);
                    MidiMessage midiMessage = midiEvent.getMessage();
                    if (!MidiUtils.isMetaTempo(midiMessage)) continue;
                    arrayList.add(midiEvent);
                }
            }
            int n4 = arrayList.size() + 1;
            this.firstTempoIsFake = true;
            if (n4 > 1 && ((MidiEvent)arrayList.get(0)).getTick() == 0L) {
                --n4;
                this.firstTempoIsFake = false;
            }
            this.ticks = new long[n4];
            this.tempos = new int[n4];
            n3 = 0;
            if (this.firstTempoIsFake) {
                this.ticks[0] = 0L;
                this.tempos[0] = 500000;
                ++n3;
            }
            n2 = 0;
            while (n2 < arrayList.size()) {
                midiEvent = (MidiEvent)arrayList.get(n2);
                this.ticks[n3] = midiEvent.getTick();
                this.tempos[n3] = MidiUtils.getTempoMPQ(midiEvent.getMessage());
                ++n2;
                ++n3;
            }
            this.snapshotIndex = 0;
            this.snapshotMicro = 0;
        }

        public int getCurrTempoMPQ() {
            return this.currTempo;
        }

        float getTempoMPQAt(long l2) {
            return this.getTempoMPQAt(l2, -1.0f);
        }

        synchronized float getTempoMPQAt(long l2, float f2) {
            for (int i2 = 0; i2 < this.ticks.length; ++i2) {
                if (this.ticks[i2] <= l2) continue;
                if (i2 > 0) {
                    --i2;
                }
                if (f2 > 0.0f && i2 == 0 && this.firstTempoIsFake) {
                    return f2;
                }
                return this.tempos[i2];
            }
            return this.tempos[this.tempos.length - 1];
        }
    }
}

