/*
Copyright (c) 2021. The YARA Authors. All Rights Reserved.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright notice, this
list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright notice,
this list of conditions and the following disclaimer in the documentation and/or
other materials provided with the distribution.

3. Neither the name of the copyright holder nor the names of its contributors
may be used to endorse or promote products derived from this software without
specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

#ifndef YR_UNICODE_H
#define YR_UNICODE_H

#ifdef _MSC_VER
#include <tchar.h>
#define char_t TCHAR
#define PF_S   "hs"
#define PF_C   "hc"

#else
#define char_t char
#define _T(x)  x
#define PF_S   "s"
#define PF_C   "c"

#ifdef __CYGWIN__
#define _tcstok_s strtok_r
#else
#define _tcstok_s strtok_s
#endif

#define _tcscmp    strcmp
#define _tcsdup    strdup
#define _tcschr    strchr
#define _tcslen    strlen
#define _tcsstr    strstr
#define _tcstol    strtol
#define _tcstoll   strtoll
#define _tstoi     atoi
#define _tstof     atof
#define _tisdigit  isdigit
#define _tfopen    fopen
#define _ftprintf  fprintf
#define _stprintf  sprintf
#define _tprintf   printf
#define _tmain     main
#define _sntprintf snprintf
#endif

#endif
