/*
 * ===========================
 * VDK Visual Development Kit
 * Version 0.4
 * October 1998
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */


#ifndef SLIDER_H
#define SLIDER_H
#include <vdk/vdkobj.h>
#include <vdk/vdkprops.h>
/*!
  \class VDKSlider
  \brief Provides a slider or "scale" widget
*/
class VDKSlider: public VDKObject
{
  GtkObject* adj; 
  static void ValueChanged(GtkWidget *wid, gpointer gp);
 public:
  //properties
  /*!
    Sets/gets slider value (defaults to value passed into constructor)
   */
  VDKReadWriteValueProp<VDKSlider,float> Value;
  /*!
    Sets/gets slider precision (defaults to 1)
   */
  VDKReadWriteValueProp<VDKSlider, int> Digits;
  /*!
    Sets/gets updating policy (defaults to update_discontinuos)
    Can be:
    \arg update_continuos
    \arg update_discontinuos
    \arg update_delayed
   */
  VDKReadWriteValueProp<VDKSlider, VDKUpdateType> UpdatePolicy;
  /*!
    Sets/gets slider lower bound
   */
  VDKReadWriteValueProp<VDKSlider, float> LowerBound;
  /*!
    Sets/gets slider upper bound
   */
  VDKReadWriteValueProp<VDKSlider, float> UpperBound;
  /*!
    Sets/gets slider step increment (using arrow keys)
   */
  VDKReadWriteValueProp<VDKSlider, float> Step;
  /*!
    Constructor
    \param owner
    \param defValue default value on start up
    \param lower lower bound
    \param upper upper bound
    \param step_increment increment
    \param mode either v_box or h_box
    \param w width
    \param h height
  */
  VDKSlider(VDKForm* owner,
	    float defValue,
	    float lower,
	    float upper,
	    float step_increment,
	    int mode = h_box,
	    int w = 100,
	    int h = 30);
  /*!
    Destructor
  */
  virtual ~VDKSlider();

  float GetValue() { return Value; }

  VDKUpdateType  GetUpdatePolicy() { return UpdatePolicy; }

  void SetDigits(int digits) 
    { 
      gtk_scale_set_digits(GTK_SCALE(widget), digits); 
      Digits(digits);
    }

  void SetUpdatePolicy(VDKUpdateType policy)
    { gtk_range_set_update_policy(GTK_RANGE(widget), (GtkUpdateType) policy); }

  void SetValue(float f);

  float GetStep(void);
  void SetStep(float f);

  

  float GetLowerBound(void);
  void SetLowerBound(float f);

  float GetUpperBound(void);
  void SetUpperBound(float f);

#ifdef USE_SIGCPLUSPLUS
  /*!
    Extended LS signal system:
    Received when an slider value changes
    \param float slider value
  */
     VDKSignal1<void, float> OnSliderValueChanged;
#endif
};
#endif
