/*
 * Copyright (C) 2023, KylinSoft Co., Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
**/
#ifndef POPMENU_H
#define POPMENU_H
#include <QMenu>

class PopMenu : public QMenu
{
    Q_OBJECT
public:
    PopMenu();

    void setStringList(QStringList strings);
    void showPopLists(QPoint pos);

protected:
    // esc按键
    void keyPressEvent(QKeyEvent* event) ;
    void hideEvent(QHideEvent* event);

Q_SIGNALS:
    //隐藏信号
    void listHide();

    // 列表项点击
    void listAactive(int index);
};

#endif // POPMENU_H
