/*
 * Copyright (C) 2023, KylinSoft Co., Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
**/
#include "deleteuserexists.h"

#include <QVBoxLayout>
#include <QHBoxLayout>
#include <QRadioButton>
#include <QLabel>
#include <QPushButton>
#include <QFrame>
#include <QButtonGroup>

#include <QDBusInterface>

#include <QPainter>
#include <QPainterPath>

#include <QMouseEvent>

#include <QDebug>

DeleteUserExists::DeleteUserExists(QString name, QString nick, QWidget *parent) :
    QDialog(parent),
    _name(name),
    _nick(nick)
{
    setFixedSize(QSize(520, 256));
    setWindowTitle(tr("Delete User"));

    initUI();
    setConnect();
}

DeleteUserExists::~DeleteUserExists()
{
}

void DeleteUserExists::initUI()
{
    //提示信息
    QString note1 = tr("Delete user '");
    QString note2 = tr("'? And:");
    noteLabel = new QLabel;
    noteLabel->setFixedHeight(27);
    if (!_nick.isEmpty()){
        noteLabel->setText(note1 + _nick + note2);
    } else {
        noteLabel->setText(note1 + _name + note2);
    }

    noteHorLayout = new QHBoxLayout;
    noteHorLayout->setSpacing(0);
    noteHorLayout->setMargin(10);
    noteHorLayout->addWidget(noteLabel);

    removeBtnGroup = new QButtonGroup(this);

    removeButKeepFilesRadioBtn = new QRadioButton;
    removeButKeepFilesRadioBtn->setFixedSize(QSize(16, 16));
    removeWholeRadioBtn = new QRadioButton;
    removeWholeRadioBtn->setFixedSize(QSize(16, 16));

    removeBtnGroup->addButton(removeButKeepFilesRadioBtn, 0);
    removeBtnGroup->addButton(removeWholeRadioBtn, 1);
    removeWholeRadioBtn->setChecked(true);

    removeButKeepFilesLabel = new FixLabel(tr("Keep desktop, files, favorites, music of the user"));
    removeWholeLabel = new FixLabel(tr("Delete whole data belong user"));

    removeButKeepFilesHorLayout = new QHBoxLayout;
    removeButKeepFilesHorLayout->setSpacing(9);
    removeButKeepFilesHorLayout->setContentsMargins(10, 0, 0, 0);
    removeButKeepFilesHorLayout->addWidget(removeButKeepFilesRadioBtn);
    removeButKeepFilesHorLayout->addWidget(removeButKeepFilesLabel);

    removeWholeHorLayout = new QHBoxLayout;
    removeWholeHorLayout->setSpacing(9);
    removeWholeHorLayout->setContentsMargins(10, 0, 0, 0);
    removeWholeHorLayout->addWidget(removeWholeRadioBtn);
    removeWholeHorLayout->addWidget(removeWholeLabel);

    removeButKeepFilesFrame = new QFrame;
    removeButKeepFilesFrame->setMinimumSize(QSize(472, 60));
    removeButKeepFilesFrame->setMaximumSize(QSize(16777215, 60));
    removeButKeepFilesFrame->setFrameShape(QFrame::Box);
    removeButKeepFilesFrame->setFrameStyle(QFrame::Plain);
    removeButKeepFilesFrame->setLayout(removeButKeepFilesHorLayout);
    removeButKeepFilesFrame->installEventFilter(this);

    removeWholeFrame = new QFrame;
    removeWholeFrame->setMinimumSize(QSize(472, 60));
    removeWholeFrame->setMaximumSize(QSize(16777215, 60));
    removeWholeFrame->setFrameShape(QFrame::Box);
    removeWholeFrame->setFrameStyle(QFrame::Plain);
    removeWholeFrame->setLayout(removeWholeHorLayout);
    removeWholeFrame->installEventFilter(this);

    //底部按钮
    cancelBtn = new QPushButton;
    cancelBtn->setText(tr("Cancel"));
    confirmBtn = new QPushButton;
    confirmBtn->setText(tr("Confirm"));

    bottomBtnsHorLayout = new QHBoxLayout;
    bottomBtnsHorLayout->setContentsMargins(0, 0, 0, 0);
    bottomBtnsHorLayout->addStretch();
    bottomBtnsHorLayout->addWidget(cancelBtn);
    bottomBtnsHorLayout->addSpacing(16);
    bottomBtnsHorLayout->addWidget(confirmBtn);

    mainVerLayout = new QVBoxLayout;
    mainVerLayout->setSpacing(0);
    mainVerLayout->setContentsMargins(24, 14, 24, 24);
    mainVerLayout->addLayout(noteHorLayout);
    mainVerLayout->addSpacing(8);
    mainVerLayout->addWidget(removeButKeepFilesFrame);
    mainVerLayout->addWidget(removeWholeFrame);
    mainVerLayout->addSpacing(33);
    mainVerLayout->addLayout(bottomBtnsHorLayout);

    setLayout(mainVerLayout);
}

void DeleteUserExists::setConnect()
{
    connect(cancelBtn, &QPushButton::clicked, this, [=]{
        close();
    });

    connect(confirmBtn, &QPushButton::clicked, this, [=]{
        emit confirmChanged(removeBtnGroup->checkedId() == 1 ? true : false);

        close();
    });
}

bool DeleteUserExists::eventFilter(QObject *watched, QEvent *event)
{
    if (event->type() == QEvent::MouseButtonPress){
        QMouseEvent * mouseEvent = static_cast<QMouseEvent *>(event);
        if (mouseEvent->button() == Qt::LeftButton ){
            if (watched == removeButKeepFilesFrame){
                removeButKeepFilesRadioBtn->setChecked(true);
            } else if (watched == removeWholeFrame){
                removeWholeRadioBtn->setChecked(true);
            }
        }
    }

    return QObject::eventFilter(watched, event);
}
