/*
 * Decompiled with CFR 0.152.
 */
package adql.translator;

import adql.db.DBColumn;
import adql.db.DBIdentifier;
import adql.db.DBType;
import adql.db.region.Region;
import adql.parser.feature.FeatureSet;
import adql.parser.grammar.ParseException;
import adql.query.ADQLList;
import adql.query.ADQLObject;
import adql.query.IdentifierField;
import adql.query.SetOperation;
import adql.query.SetOperationType;
import adql.query.constraint.Comparison;
import adql.query.constraint.ComparisonOperator;
import adql.query.operand.ADQLOperand;
import adql.query.operand.Concatenation;
import adql.query.operand.function.InUnitFunction;
import adql.query.operand.function.MathFunction;
import adql.query.operand.function.cast.CastFunction;
import adql.query.operand.function.geometry.AreaFunction;
import adql.query.operand.function.geometry.BoxFunction;
import adql.query.operand.function.geometry.CentroidFunction;
import adql.query.operand.function.geometry.CircleFunction;
import adql.query.operand.function.geometry.ContainsFunction;
import adql.query.operand.function.geometry.DistanceFunction;
import adql.query.operand.function.geometry.ExtractCoord;
import adql.query.operand.function.geometry.ExtractCoordSys;
import adql.query.operand.function.geometry.IntersectsFunction;
import adql.query.operand.function.geometry.PointFunction;
import adql.query.operand.function.geometry.PolygonFunction;
import adql.translator.JDBCTranslator;
import adql.translator.TranslationException;

public class MySQLTranslator
extends JDBCTranslator {
    public static int DEFAULT_VARIABLE_LENGTH = 200;
    protected byte caseSensitivity = 0;
    protected final FeatureSet supportedFeatures = new FeatureSet();

    public MySQLTranslator() {
        this.caseSensitivity = (byte)15;
        this.initSupportedFeatures();
    }

    public MySQLTranslator(boolean allCaseSensitive) {
        this.caseSensitivity = (byte)(allCaseSensitive ? 15 : 0);
        this.initSupportedFeatures();
    }

    public MySQLTranslator(boolean catalog, boolean schema, boolean table, boolean column) {
        this.caseSensitivity = IdentifierField.CATALOG.setCaseSensitive(this.caseSensitivity, catalog);
        this.caseSensitivity = IdentifierField.SCHEMA.setCaseSensitive(this.caseSensitivity, schema);
        this.caseSensitivity = IdentifierField.TABLE.setCaseSensitive(this.caseSensitivity, table);
        this.caseSensitivity = IdentifierField.COLUMN.setCaseSensitive(this.caseSensitivity, column);
        this.initSupportedFeatures();
    }

    protected void initSupportedFeatures() {
        this.supportedFeatures.supportAll();
        this.supportedFeatures.unsupportAll("ivo://ivoa.net/std/TAPRegExt#features-adqlgeo");
        this.supportedFeatures.unsupport(ComparisonOperator.ILIKE.getFeatureDescription());
        this.supportedFeatures.unsupport(InUnitFunction.FEATURE);
    }

    @Override
    public final FeatureSet getSupportedFeatures() {
        return this.supportedFeatures;
    }

    @Override
    public boolean isCaseSensitive(IdentifierField field) {
        return field != null && field.isCaseSensitive(this.caseSensitivity);
    }

    @Override
    public StringBuffer appendIdentifier(StringBuffer str, String id, boolean caseSensitive) {
        if (caseSensitive && !DBIdentifier.isDelimited(id)) {
            return str.append('`').append(id).append('`');
        }
        return str.append(id);
    }

    @Override
    public String translate(SetOperation set) throws TranslationException {
        StringBuffer sql = new StringBuffer();
        String tPrefix = "t" + System.currentTimeMillis() + "_";
        int tCnt = 1;
        switch (set.getOperation()) {
            case UNION: {
                boolean extendedSetExp;
                if (!set.getWith().isEmpty()) {
                    sql.append(this.translate(set.getWith())).append('\n');
                }
                boolean bl = extendedSetExp = set.getLeftSet() instanceof SetOperation || !set.getLeftSet().getOrderBy().isEmpty() || set.getLeftSet().getLimit() > 0 || set.getLeftSet().getOffset() != null;
                if (extendedSetExp) {
                    sql.append('(');
                }
                sql.append(this.translate(set.getLeftSet()));
                if (extendedSetExp) {
                    sql.append(')');
                }
                sql.append('\n');
                sql.append((Object)set.getOperation());
                if (set.isWithDuplicates()) {
                    sql.append(" ALL");
                }
                sql.append('\n');
                boolean bl2 = extendedSetExp = set.getRightSet() instanceof SetOperation || !set.getRightSet().getOrderBy().isEmpty() || set.getRightSet().getLimit() > 0 || set.getRightSet().getOffset() != null;
                if (extendedSetExp) {
                    sql.append('(');
                }
                sql.append(this.translate(set.getRightSet()));
                if (extendedSetExp) {
                    sql.append(')');
                }
                if (!set.getOrderBy().isEmpty()) {
                    sql.append('\n').append(this.translate((ADQLList<? extends ADQLObject>)set.getOrderBy()));
                }
                if (set.getOffset() == null) break;
                sql.append("\nOFFSET ").append(set.getOffset().getValue());
                break;
            }
            case INTERSECT: 
            case EXCEPT: {
                int i;
                String t1 = tPrefix + tCnt++;
                String t2 = tPrefix + tCnt++;
                if (!set.getWith().isEmpty()) {
                    sql.append(this.translate(set.getWith())).append('\n');
                }
                sql.append("SELECT " + (set.isWithDuplicates() ? "" : "DISTINCT "));
                this.appendIdentifier(sql, t1, IdentifierField.TABLE);
                sql.append(".*\nFROM");
                sql.append(" (\n").append(this.translate(set.getLeftSet()));
                sql.append(") AS ");
                this.appendIdentifier(sql, t1, IdentifierField.TABLE);
                if (set.getOperation() == SetOperationType.INTERSECT) {
                    sql.append("\nINNER JOIN");
                } else {
                    sql.append("\nLEFT JOIN");
                }
                sql.append(" (\n").append(this.translate(set.getRightSet()));
                sql.append(") AS ");
                this.appendIdentifier(sql, t2, IdentifierField.TABLE);
                sql.append("\nON ");
                DBColumn[] leftCols = set.getLeftSet().getResultingColumns();
                DBColumn[] rightCols = set.getRightSet().getResultingColumns();
                for (i = 0; i < leftCols.length; ++i) {
                    if (i > 0) {
                        sql.append(" AND ");
                    }
                    this.appendIdentifier(sql, t1, IdentifierField.TABLE);
                    sql.append('.');
                    this.appendIdentifier(sql, leftCols[i].getADQLName(), IdentifierField.COLUMN);
                    sql.append('=');
                    this.appendIdentifier(sql, t2, IdentifierField.TABLE);
                    sql.append('.');
                    this.appendIdentifier(sql, rightCols[i].getADQLName(), IdentifierField.COLUMN);
                }
                if (set.getOperation() == SetOperationType.EXCEPT) {
                    sql.append("\nWHERE ");
                    for (i = 0; i < rightCols.length; ++i) {
                        if (i > 0) {
                            sql.append(" AND ");
                        }
                        this.appendIdentifier(sql, t2, IdentifierField.TABLE);
                        sql.append('.');
                        this.appendIdentifier(sql, rightCols[i].getADQLName(), IdentifierField.COLUMN);
                        sql.append(" IS NULL");
                    }
                }
                if (!set.getOrderBy().isEmpty()) {
                    sql.append('\n').append(this.translate((ADQLList<? extends ADQLObject>)set.getOrderBy()));
                }
                if (set.getOffset() == null) break;
                sql.append("\nOFFSET ").append(set.getOffset().getValue());
                break;
            }
            default: {
                throw new TranslationException("Unsupported SET operation: " + (Object)((Object)set.getOperation()) + "!");
            }
        }
        return sql.toString();
    }

    @Override
    public String translate(MathFunction fct) throws TranslationException {
        switch (fct.getType()) {
            case TRUNCATE: {
                if (fct.getNbParameters() >= 2) {
                    return "truncate(" + this.translate(fct.getParameter(0)) + ", " + this.translate(fct.getParameter(1)) + ")";
                }
                return "truncate(" + this.translate(fct.getParameter(0)) + ", 0)";
            }
        }
        return this.getDefaultADQLFunction(fct);
    }

    @Override
    public String translate(Comparison comp) throws TranslationException {
        switch (comp.getOperator()) {
            case ILIKE: 
            case NOTILIKE: {
                throw new TranslationException("Translation of ILIKE impossible! This is not supported natively in MySQL.");
            }
        }
        return this.translate(comp.getLeftOperand()) + " " + comp.getOperator().toADQL() + " " + this.translate(comp.getRightOperand());
    }

    @Override
    public String translate(Concatenation concat) throws TranslationException {
        StringBuilder translated = new StringBuilder();
        for (ADQLOperand op : concat) {
            if (translated.length() == 0) {
                translated.append("CONCAT(");
            } else {
                translated.append(", ");
            }
            translated.append(this.translate(op));
        }
        translated.append(")");
        return translated.toString();
    }

    @Override
    public String translate(InUnitFunction fct) throws TranslationException {
        return this.getDefaultADQLFunction(fct);
    }

    @Override
    public String translate(CastFunction fct) throws TranslationException {
        if (fct.getFunctionTranslator() != null) {
            return fct.getFunctionTranslator().translate(fct, this);
        }
        StringBuilder sql = new StringBuilder(fct.getName());
        sql.append('(');
        sql.append(fct.getValue() == null ? "NULL" : this.translate(fct.getValue()));
        sql.append(" AS ");
        if (fct.getTargetType().getReturnType() != null) {
            DBType returnType = fct.getTargetType().getReturnType();
            switch (returnType.type) {
                case SMALLINT: 
                case INTEGER: 
                case BIGINT: {
                    sql.append("SIGNED INTEGER");
                    break;
                }
                case CHAR: 
                case VARCHAR: {
                    sql.append("CHAR").append(returnType.length > 0 ? "(" + returnType.length + ")" : "");
                    break;
                }
                case TIMESTAMP: {
                    sql.append("DATETIME");
                    break;
                }
                default: {
                    sql.append(this.convertTypeToDB(fct.getTargetType().getReturnType()));
                    break;
                }
            }
        } else {
            sql.append(fct.getTargetType().toADQL());
        }
        sql.append(')');
        return sql.toString();
    }

    @Override
    public DBType convertTypeFromDB(int dbmsType, String rawDbmsTypeName, String dbmsTypeName, String[] params) {
        if (dbmsTypeName == null || dbmsTypeName.trim().length() == 0) {
            return null;
        }
        dbmsTypeName = dbmsTypeName.toLowerCase();
        int lengthParam = -1;
        if (params != null && params.length > 0) {
            try {
                lengthParam = Integer.parseInt(params[0]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (dbmsTypeName.equals("smallint") || dbmsTypeName.equals("tinyint") || dbmsTypeName.equals("bool") || dbmsTypeName.equals("boolean")) {
            return new DBType(DBType.DBDatatype.SMALLINT);
        }
        if (dbmsTypeName.equals("integer") || dbmsTypeName.equals("int") || dbmsTypeName.equals("mediumint")) {
            return new DBType(DBType.DBDatatype.INTEGER);
        }
        if (dbmsTypeName.equals("bigint")) {
            return new DBType(DBType.DBDatatype.BIGINT);
        }
        if (dbmsTypeName.equals("float") || dbmsTypeName.equals("real")) {
            return new DBType(DBType.DBDatatype.REAL);
        }
        if (dbmsTypeName.equals("double") || dbmsTypeName.equals("double precision") || dbmsTypeName.equals("dec") || dbmsTypeName.equals("decimal") || dbmsTypeName.equals("numeric") || dbmsTypeName.equals("fixed")) {
            return new DBType(DBType.DBDatatype.DOUBLE);
        }
        if (dbmsTypeName.equals("bit") || dbmsTypeName.equals("binary") || dbmsTypeName.equals("char byte")) {
            return new DBType(DBType.DBDatatype.BINARY, lengthParam);
        }
        if (dbmsTypeName.equals("varbinary")) {
            return new DBType(DBType.DBDatatype.VARBINARY, lengthParam);
        }
        if (dbmsTypeName.equals("char") || dbmsTypeName.equals("character") || dbmsTypeName.equals("nchar") || dbmsTypeName.equals("national char")) {
            return new DBType(DBType.DBDatatype.CHAR, lengthParam);
        }
        if (dbmsTypeName.equals("varchar") || dbmsTypeName.equals("character varying") || dbmsTypeName.equals("nvarchar") || dbmsTypeName.equals("national varchar")) {
            return new DBType(DBType.DBDatatype.VARCHAR, lengthParam);
        }
        if (dbmsTypeName.equals("blob") || dbmsTypeName.equals("tinyblob") || dbmsTypeName.equals("mediumblob") || dbmsTypeName.equals("longblob")) {
            return new DBType(DBType.DBDatatype.BLOB);
        }
        if (dbmsTypeName.equals("text") || dbmsTypeName.equals("tinytext") || dbmsTypeName.equals("mediumtext") || dbmsTypeName.equals("longtext")) {
            return new DBType(DBType.DBDatatype.CLOB);
        }
        if (dbmsTypeName.equals("timestamp") || dbmsTypeName.equals("date") || dbmsTypeName.equals("datetime") || dbmsTypeName.equals("time") || dbmsTypeName.equals("year")) {
            return new DBType(DBType.DBDatatype.TIMESTAMP);
        }
        return null;
    }

    @Override
    public String convertTypeToDB(DBType type) {
        if (type == null) {
            return "VARCHAR(" + DEFAULT_VARIABLE_LENGTH + ")";
        }
        switch (type.type) {
            case SMALLINT: 
            case INTEGER: 
            case BIGINT: 
            case TIMESTAMP: 
            case REAL: {
                return type.type.toString();
            }
            case DOUBLE: {
                return "DOUBLE PRECISION";
            }
            case CHAR: 
            case VARCHAR: 
            case BINARY: 
            case VARBINARY: {
                return type.type.toString() + "(" + (type.length > 0 ? type.length : DEFAULT_VARIABLE_LENGTH) + ")";
            }
            case BLOB: {
                return "BLOB";
            }
            case CLOB: {
                return "TEXT";
            }
        }
        return "VARCHAR(" + DEFAULT_VARIABLE_LENGTH + ")";
    }

    @Override
    public Region translateGeometryFromDB(Object jdbcColValue) throws ParseException {
        throw new ParseException("Unsupported geometrical value! The value \"" + jdbcColValue + "\" can not be parsed as a region.");
    }

    @Override
    public Object translateGeometryToDB(Region region) throws ParseException {
        throw new ParseException("Geometries can not be uploaded in the database in this implementation!");
    }

    @Override
    public String translate(ExtractCoord extractCoord) throws TranslationException {
        return this.getDefaultADQLFunction(extractCoord);
    }

    @Override
    public String translate(ExtractCoordSys extractCoordSys) throws TranslationException {
        return this.getDefaultADQLFunction(extractCoordSys);
    }

    @Override
    public String translate(AreaFunction areaFunction) throws TranslationException {
        return this.getDefaultADQLFunction(areaFunction);
    }

    @Override
    public String translate(CentroidFunction centroidFunction) throws TranslationException {
        return this.getDefaultADQLFunction(centroidFunction);
    }

    @Override
    public String translate(DistanceFunction fct) throws TranslationException {
        return this.getDefaultADQLFunction(fct);
    }

    @Override
    public String translate(ContainsFunction fct) throws TranslationException {
        return this.getDefaultADQLFunction(fct);
    }

    @Override
    public String translate(IntersectsFunction fct) throws TranslationException {
        return this.getDefaultADQLFunction(fct);
    }

    @Override
    public String translate(BoxFunction box) throws TranslationException {
        return this.getDefaultADQLFunction(box);
    }

    @Override
    public String translate(CircleFunction circle) throws TranslationException {
        return this.getDefaultADQLFunction(circle);
    }

    @Override
    public String translate(PointFunction point) throws TranslationException {
        return this.getDefaultADQLFunction(point);
    }

    @Override
    public String translate(PolygonFunction polygon) throws TranslationException {
        return this.getDefaultADQLFunction(polygon);
    }
}

