/* Copyright (C) 1993,1994 by the author(s).
 
 This software is published in the hope that it will be useful, but
 WITHOUT ANY WARRANTY for any part of this software to work correctly
 or as described in the manuals. See the ShapeTools Public License
 for details.

 Permission is granted to use, copy, modify, or distribute any part of
 this software but only under the conditions described in the ShapeTools 
 Public License. A copy of this license is supposed to have been given
 to you along with ShapeTools in a file named LICENSE. Among other
 things, this copyright notice and the Public License must be
 preserved on all copies.
 */
/*
 * AtFS -- Attribute Filesystem
 *
 * afstates.c - operations on version states
 *
 * Author: Andreas Lampen (Andreas.Lampen@cs.tu-berlin.de)
 *
 * $Header: afstates.c[7.0] Fri Jun 25 14:32:15 1993 andy@cs.tu-berlin.de frozen $
 */

#include "atfs.h"

/*====================================================================
 *    af_sstate -- set version state
 *====================================================================*/

EXPORT int af_sstate (key, state)
     Af_key 	*key;
     int        state;
{
  if (afAccessAso (key, AF_ATTRS))
    FAIL ("sstate", "", AF_EINVKEY, ERROR);
  if (VATTR(key).af_state == AF_DERIVED)
    FAIL ("sstate", "", AF_EDERIVED, ERROR);

  if (af_checkperm (key, AF_OWNER | AF_AUTHOR | AF_LOCKHOLDER) == ERROR)
    return (ERROR);

  if ((state < AF_SAVED) || (state > AF_FROZEN))
    FAIL ("sstate", "", AF_ESTATE, ERROR);

  VATTR(key).af_state = state;

  /* save changes */
  if (afUpdateAso (key, AF_CHANGE) == ERROR)
    return (ERROR);
  return (AF_OK);
} /* af_sstate */
