// Scilab ( http://www.scilab.org/ ) - This file is part of Scilab
// Copyright (C) INRIA
//
// Copyright (C) 2012 - 2016 - Scilab Enterprises
//
// This file is hereby licensed under the terms of the GNU GPL v2.0,
// pursuant to article 5.3.4 of the CeCILL v.2.1.
// This file was originally licensed under the terms of the CeCILL v2.1,
// and continues to be available under such terms.
// For more information, see the COPYING file which you should have received
// along with this program.
//
function [txtdo]=lmitool(PROBNAME,XNAME,DNAME)
    [LHS,RHS]=argn(0);
    txtdo=[]

    if or(RHS == [0 2]) then
        error(msprintf(_("%s: Wrong number of input arguments: %d or %d expected.\n"),"lmitool",1,3))
    end

    if RHS == 1 then
        messagebox([gettext("Welcome to LMITOOL");"      ";"   ";
        gettext("LMITOOL is a Scilab package for LMI optimization");
        "            ";
        "           ";
        gettext("It can solve the following problem");
        "                 ";
        gettext("   minimize  f(X1,...,XM)  ");
        gettext("subject to the LME constraints: ");
        gettext("   Gi(X1,...,XM)=0,  i=1,2,...,p,");
        gettext("and the LMI constraints:  ");
        gettext("   Hj(X1,...,XM)>=0,  j=1,2,...,q.");
        "              ";
        gettext("where");
        gettext("X1,...,XM are unknown real matrices, referred to as the unknown matrices,");
        gettext("f is the objective function, a linear scalar function of the entries of the X''s,");
        gettext("Gi''s are affine matrix functions of the entries of the X''s,");
        gettext("Hj''s are affine symmetric matrix functions of the entries of the X''s.");
        "            ";
        gettext("These functions are parameterized by the entries of known data matrices D1,...,DN.");
        "        ";
        gettext("For a detailed description and examples consult: ");
        gettext("          ''LMITOOL: a Package for LMI Optimization in Scilab, User''s Guide'' ");
        "          ";
        gettext("LMITOOL uses Semidefinite Programming package SP developed by L. Vandenberghe and S. Boyd.")],"modal","scilab");

        tt=read(PROBNAME,-1,1,"(a)");
        tt=stripblanks(tt);
        mat=str2vec(tt);
        [q1,p1]=find(mat'=="[");
        [q2,p2]=find(mat'=="]");
        XNAME1=mat(p1(1),q1(1)+1:q2(1)-1);
        XNAME1=strcat(XNAME1);
        [q1,p1]=find(mat'=="(");
        [q2,p2]=find(mat'==")");
        DNAME1=mat(p1(1),q1(1)+1:q2(1)-1);
        DNAME1=strcat(DNAME1);
        [q2,p2]=find(mat'=="=");
        PROBNAME1=mat(p2(1),q2(1)+1:q1(1)-1);
        PROBNAME1=strcat(PROBNAME1);

        labels=[gettext("LMI problem name: ");gettext("Names of unknown matrices: "); ...
        gettext("Names of data matrices: ")];
        [ok,PROBNAME,XNAME,DNAME]=getvalue([gettext("Problem definition");
        gettext("LMITOOL will generate a skeleton of the functions needed");
        gettext(" (see User''s Guide for details). For that, you need to specify:");
        gettext("1- Name of your problem which will be given to the solver function,");
        gettext("2- Names of unknown matrices or list of unknown matrices,");
        gettext("3- Names of data matrices or list of data matrices.")], labels', ...
        list("str",1,"str",1,"str",1), ...
        [PROBNAME1, XNAME1, DNAME1]);
        if ok==%f then
            txtdo=gettext("Try again");
            return;
        end
    end

    PROBNAME=stripblanks(PROBNAME);
    XNAME=stripblanks(XNAME);
    DNAME=stripblanks(DNAME);

    pathname=pwd();

    fname = pathname+filesep()+PROBNAME+".sci";

    txt0="function ["+XNAME+"]="+PROBNAME+"("+DNAME+")"
    txt0=[txt0;"/"+"/ Generated by lmitool on ";"  "];

    txt0=[txt0;
    "  Mbound = 1e3;";
    "  abstol = 1e-10;";
    "  nu = 10;";
    "  maxiters = 100;";
    "  reltol = 1e-10;";
    "  options=[Mbound,abstol,nu,maxiters,reltol];"
    "   "]

    nv=length(XNAME);
    index_commas=[];
    for k=1:nv
        if part(XNAME,k)=="," then index_commas=[index_commas,k],end
    end
    vnum = length(index_commas)+1;
    index_commas = [0 index_commas length(XNAME)+1];

    txt1=[];txt2=[];
    for i = 1:vnum,
        vname = part(XNAME,index_commas(i)+1:index_commas(i+1)-1);
        if RHS<>1 then
            txt1 = [txt1;
            vname+"_init=..."]
        end
        txt2=[txt2,vname+"_init"];
    end

    txts1=["function [LME,LMI,OBJ]="+PROBNAME+"_eval(XLIST)";
    "["+XNAME+"]=XLIST(:)"]
    if RHS ~= 1 then
        txts2=["LME=...";"LMI=...";"OBJ=..."]
    else
        [p,q]=size(mat);
        ind=[]
        for i=1:p
            if mat(i,2:7)==["/","/","/","/","/","/"]  then
                ind=[ind i];
            end
        end
        if size(ind,"*")<>4 then
            error(gettext("File not generated by lmitool or badly modified."));
        end
        txt1=[];
        for i=ind(1)+1:ind(2)-1
            txt1=[txt1;strcat(mat(i,:))];
        end
        txts2=[];
        for i=ind(4)+1:p
            txts2=[txts2;strcat(mat(i,:))];
        end
    end

    sep11="///////////DEFINE INITIAL GUESS AND PRELIMINARY CALCULATIONS BELOW"
    sep12="/////////// "
    sep13="/////////////////DEFINE LME, LMI and OBJ BELOW"
    sep2="/////////////////EVALUATION FUNCTION////////////////////////////"

    txt2=[
    "XLIST0=list("+strcat(txt2,",")+")";
    "XLIST=lmisolver(XLIST0,"+PROBNAME+"_eval,options)";
    "["+XNAME+"]=XLIST(:)"];

    txt4=[txt0;sep11;txt1;sep12;" ";txt2;" ";" ";" ";...
    sep2;" ";txts1;" ";sep13;txts2];

    if RHS==0|RHS==1 then
        [txt4]=x_dialog([gettext("Function definitions: ");
        gettext("Here is a skeleton of the functions you should edit.");
        gettext("You can edit in this window or click on ''ok''.");
        gettext("Save and edit the skeleton later through your favorite editor.")],[txt4]);
    end
    if txt4==[] then txtdo="Try again";return;end
    txt=[txt4];
    n=1;
    if RHS<>3 then

        fname=x_dialog([gettext("Name of the file where to save the solver function");
        gettext("and the evaluation function");
        gettext("(Will overwrite if a file with the same name already exists).")],[fname+"                "])
        fname=stripblanks(fname);
    else
        messagebox(gettext("functions saved in ")+fname',"modal","info");
    end
    if fname<>[] then
        deletefile(fname)
        mputl(txt,fname)
    else
        return
    end

    // Tell the user what to do:
    if RHS==0|RHS==1 then
        txtdo = ["    To solve your problem, you need to ";
        "1- load your functions using the command:";
        "   exec(''"+fname'+"'')";
        "2- Define "+DNAME+" and call function "+PROBNAME+" as follows:";
        "  "+"["+XNAME+"]="+PROBNAME+"("+DNAME+")";
        "           Good luck! ";
        "To check the result, use [LME,LMI,OBJ]="+PROBNAME+"_eval(list("+XNAME+"))"]

        messagebox(txtdo,"modal","info");return
    end
    if RHS==3 then
        txtdo = [gettext("    To solve your problem, you need to ");
        gettext("1- edit file ")+fname
        gettext("2- load (and compile) your functions:");
        "   exec(''"+fname'+"'')";
        gettext("3- Define ")+DNAME+gettext(" and call ")+PROBNAME+gettext(" function:");
        "  "+"["+XNAME+"]="+PROBNAME+"("+DNAME+")";
        gettext("To check the result, use [LME,LMI,OBJ]=")+PROBNAME+"_eval(list("+XNAME+"))"]
    end

endfunction
function [vec]=str2vec(str)
    w=length(str);
    [p,q]=size(w);ma=max(w);
    vec=[];
    for i=1:ma
        vec=[vec part(str,i)]
    end
endfunction
