/* The following code was generated by JFlex 1.6.1 */

//CHECKSTYLE:OFF

package org.scilab.modules.scinotes;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import org.scilab.modules.commons.ScilabCommonsUtils;

@javax.annotation.Generated("JFlex")
@SuppressWarnings("fallthrough")


/**
 * This class is a scanner generated by 
 * <a href="http://www.jflex.de/">JFlex</a> 1.6.1
 * from the specification file <tt>modules/scinotes/src/java/jflex/scilab.jflex</tt>
 */
public final class ScilabLexer extends ScilabLexerConstants {

  /** This character denotes the end of file */
  public static final int YYEOF = -1;

  /** initial size of the lookahead buffer */
  private static final int ZZ_BUFFERSIZE = 16384;

  /** lexical states */
  public static final int YYINITIAL = 0;
  public static final int QSTRING = 2;
  public static final int COMMENT = 4;
  public static final int BLOCKCOMMENT = 6;
  public static final int FIELD = 8;
  public static final int COMMANDS = 10;
  public static final int COMMANDSWHITE = 12;
  public static final int BREAKSTRING = 14;

  /**
   * ZZ_LEXSTATE[l] is the state in the DFA for the lexical state l
   * ZZ_LEXSTATE[l+1] is the state in the DFA for the lexical state l
   *                  at the beginning of a line
   * l is of the form l = 2*k, k a non negative integer
   */
  private static final int ZZ_LEXSTATE[] = { 
     0,  0,  1,  1,  2,  2,  3,  3,  4,  4,  5,  5,  6,  6,  7, 7
  };

  /** 
   * Translates characters to character classes
   */
  private static final String ZZ_CMAP_PACKED = 
    "\11\0\1\111\1\1\1\124\1\121\1\114\22\0\1\72\1\117\1\10"+
    "\1\115\1\112\1\11\1\51\1\7\1\3\1\4\1\6\1\43\1\120"+
    "\1\44\1\40\1\5\12\116\1\113\1\125\1\47\1\45\1\50\1\115"+
    "\1\53\1\101\1\102\1\26\1\36\1\34\1\15\1\104\1\31\1\27"+
    "\1\105\1\110\1\76\1\33\1\73\1\32\1\35\1\123\1\37\1\25"+
    "\1\13\1\77\1\106\1\30\1\123\1\100\1\74\1\2\1\41\1\4"+
    "\1\42\1\122\1\0\1\24\1\65\1\55\1\57\1\16\1\14\1\103"+
    "\1\60\1\20\1\107\1\66\1\63\1\70\1\21\1\56\1\17\1\67"+
    "\1\61\1\23\1\12\1\54\1\75\1\62\1\71\1\64\1\22\1\2"+
    "\1\52\1\4\1\46\6\0\1\124\u1fa2\0\1\124\1\124\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\udfe6\0";

  /** 
   * Translates characters to character classes
   */
  private static final char [] ZZ_CMAP = zzUnpackCMap(ZZ_CMAP_PACKED);

  /** 
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\1\0\1\1\4\0\1\1\1\0\1\2\1\3\1\4"+
    "\2\5\1\6\1\7\14\10\1\11\7\5\7\10\1\12"+
    "\1\13\2\14\1\15\1\2\1\1\1\16\1\17\1\1"+
    "\1\20\1\21\12\22\1\23\6\22\1\24\2\22\1\25"+
    "\1\26\1\27\1\25\1\30\1\31\1\32\2\1\1\12"+
    "\1\13\2\16\1\33\1\34\1\5\1\35\1\0\2\36"+
    "\1\10\1\36\12\10\1\37\5\10\2\5\1\14\1\15"+
    "\1\0\2\5\3\10\1\40\3\10\1\0\1\35\2\0"+
    "\1\35\1\15\1\0\1\41\33\0\1\42\1\43\2\0"+
    "\1\1\1\44\3\0\6\10\1\45\6\10\1\36\1\10"+
    "\1\15\2\35\10\10\2\15\1\0\1\41\31\0\1\42"+
    "\1\0\3\10\1\46\1\47\13\10\1\41\13\0\1\50"+
    "\15\0\1\42\11\10\26\0\1\10\1\46\3\10\26\0"+
    "\2\10\26\0\1\51\16\0\1\52\1\0\1\53\271\0";

  private static int [] zzUnpackAction() {
    int [] result = new int[555];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /** 
   * Translates a state to a row index in the transition table
   */
  private static final int [] ZZ_ROWMAP = zzUnpackRowMap();

  private static final String ZZ_ROWMAP_PACKED_0 =
    "\0\0\0\126\0\254\0\u0102\0\u0158\0\u01ae\0\u0204\0\u025a"+
    "\0\u02b0\0\u02b0\0\u02b0\0\u0306\0\u035c\0\u03b2\0\u03b2\0\u0408"+
    "\0\u045e\0\u04b4\0\u050a\0\u0560\0\u05b6\0\u060c\0\u0662\0\u06b8"+
    "\0\u070e\0\u0764\0\u07ba\0\u0810\0\u0866\0\u08bc\0\u0912\0\u0968"+
    "\0\u09be\0\u0a14\0\u0a6a\0\u0ac0\0\u0b16\0\u0b6c\0\u0bc2\0\u0c18"+
    "\0\u0c6e\0\u0cc4\0\u0d1a\0\u0d70\0\u0560\0\u0866\0\u0dc6\0\u0866"+
    "\0\u0e1c\0\u02b0\0\u0e72\0\u0ec8\0\u02b0\0\u02b0\0\u02b0\0\u0f1e"+
    "\0\u0f74\0\u0fca\0\u1020\0\u1076\0\u10cc\0\u1122\0\u1178\0\u11ce"+
    "\0\u02b0\0\u1224\0\u127a\0\u12d0\0\u1326\0\u137c\0\u13d2\0\u02b0"+
    "\0\u1428\0\u147e\0\u02b0\0\u02b0\0\u14d4\0\u14d4\0\u02b0\0\u152a"+
    "\0\u152a\0\u1580\0\u15d6\0\u02b0\0\u02b0\0\u162c\0\u1682\0\u02b0"+
    "\0\u16d8\0\u02b0\0\u02b0\0\u172e\0\u0560\0\u1784\0\u17da\0\u1830"+
    "\0\u1886\0\u18dc\0\u1932\0\u1988\0\u19de\0\u1a34\0\u1a8a\0\u1ae0"+
    "\0\u1b36\0\u1b8c\0\u0560\0\u1be2\0\u1c38\0\u1c8e\0\u1ce4\0\u1d3a"+
    "\0\u1d90\0\u1de6\0\u1e3c\0\u1e92\0\u1ee8\0\u1f3e\0\u1f94\0\u1fea"+
    "\0\u2040\0\u2096\0\u0560\0\u20ec\0\u2142\0\u2198\0\u21ee\0\u2244"+
    "\0\u0866\0\u0d70\0\u229a\0\u22f0\0\u0e72\0\u2346\0\u239c\0\u23f2"+
    "\0\u2448\0\u249e\0\u24f4\0\u254a\0\u25a0\0\u25f6\0\u264c\0\u26a2"+
    "\0\u26f8\0\u274e\0\u27a4\0\u27fa\0\u2850\0\u1178\0\u28a6\0\u28fc"+
    "\0\u2952\0\u29a8\0\u29fe\0\u2a54\0\u2aaa\0\u2b00\0\u2b56\0\u1428"+
    "\0\u2bac\0\u02b0\0\u02b0\0\u147e\0\u152a\0\u2c02\0\u1682\0\u2c58"+
    "\0\u2cae\0\u2d04\0\u2d5a\0\u2db0\0\u2e06\0\u2e5c\0\u2eb2\0\u2f08"+
    "\0\u2f5e\0\u2fb4\0\u300a\0\u3060\0\u30b6\0\u310c\0\u3162\0\u31b8"+
    "\0\u320e\0\u3264\0\u1f3e\0\u1f94\0\u32ba\0\u3310\0\u3366\0\u33bc"+
    "\0\u3412\0\u3468\0\u34be\0\u3514\0\u356a\0\u35c0\0\u3616\0\u366c"+
    "\0\u36c2\0\u3718\0\u376e\0\u37c4\0\u381a\0\u3870\0\u38c6\0\u391c"+
    "\0\u3972\0\u39c8\0\u3a1e\0\u3a74\0\u3aca\0\u3b20\0\u3b76\0\u3bcc"+
    "\0\u3c22\0\u3c78\0\u3cce\0\u3d24\0\u3d7a\0\u3dd0\0\u3e26\0\u3e7c"+
    "\0\u3ed2\0\u1428\0\u3f28\0\u3f7e\0\u3fd4\0\u402a\0\u4080\0\u0560"+
    "\0\u40d6\0\u412c\0\u4182\0\u41d8\0\u422e\0\u4284\0\u42da\0\u4330"+
    "\0\u4386\0\u43dc\0\u4432\0\u02b0\0\u4488\0\u44de\0\u4534\0\u458a"+
    "\0\u45e0\0\u4636\0\u468c\0\u46e2\0\u4738\0\u478e\0\u47e4\0\u02b0"+
    "\0\u483a\0\u4890\0\u48e6\0\u493c\0\u4992\0\u49e8\0\u4a3e\0\u4a94"+
    "\0\u4aea\0\u4b40\0\u4b96\0\u4bec\0\u4c42\0\u2c58\0\u4c98\0\u4cee"+
    "\0\u4d44\0\u4d9a\0\u4df0\0\u4e46\0\u4e9c\0\u4ef2\0\u4f48\0\u4f9e"+
    "\0\u4ff4\0\u504a\0\u50a0\0\u50f6\0\u514c\0\u51a2\0\u51f8\0\u524e"+
    "\0\u52a4\0\u52fa\0\u5350\0\u53a6\0\u53fc\0\u5452\0\u54a8\0\u54fe"+
    "\0\u5554\0\u55aa\0\u5600\0\u5656\0\u56ac\0\u5702\0\u0560\0\u5758"+
    "\0\u57ae\0\u5804\0\u585a\0\u58b0\0\u5906\0\u595c\0\u59b2\0\u5a08"+
    "\0\u5a5e\0\u5ab4\0\u5b0a\0\u5b60\0\u5bb6\0\u5c0c\0\u5c62\0\u5cb8"+
    "\0\u5d0e\0\u5d64\0\u5dba\0\u5e10\0\u5e66\0\u5ebc\0\u5f12\0\u5f68"+
    "\0\u5fbe\0\u6014\0\u606a\0\u60c0\0\u6116\0\u616c\0\u61c2\0\u6218"+
    "\0\u626e\0\u62c4\0\u631a\0\u6370\0\u63c6\0\u641c\0\u6472\0\u64c8"+
    "\0\u651e\0\u6574\0\u65ca\0\u6620\0\u6676\0\u66cc\0\u6722\0\u6778"+
    "\0\u0560\0\u67ce\0\u6824\0\u687a\0\u68d0\0\u6926\0\u697c\0\u69d2"+
    "\0\u6a28\0\u6a7e\0\u6ad4\0\u6b2a\0\u6b80\0\u6bd6\0\u6c2c\0\u02b0"+
    "\0\u6c82\0\u641c\0\u6cd8\0\u6d2e\0\u6d84\0\u6dda\0\u6e30\0\u6e86"+
    "\0\u6edc\0\u6f32\0\u6f88\0\u6fde\0\u7034\0\u708a\0\u70e0\0\u7136"+
    "\0\u718c\0\u71e2\0\u7238\0\u728e\0\u72e4\0\u733a\0\u7390\0\u73e6"+
    "\0\u743c\0\u7492\0\u74e8\0\u753e\0\u7594\0\u75ea\0\u7640\0\u7696"+
    "\0\u76ec\0\u7742\0\u7798\0\u77ee\0\u7844\0\u789a\0\u78f0\0\u7946"+
    "\0\u799c\0\u79f2\0\u7a48\0\u7a9e\0\u7af4\0\u7b4a\0\u7ba0\0\u7bf6"+
    "\0\u7c4c\0\u7ca2\0\u7cf8\0\u7d4e\0\u7da4\0\u7dfa\0\u7e50\0\u7ea6"+
    "\0\u7efc\0\u7f52\0\u7fa8\0\u7ffe\0\u8054\0\u80aa\0\u8100\0\u8156"+
    "\0\u81ac\0\u8202\0\u8258\0\u82ae\0\u8304\0\u835a\0\u83b0\0\u8406"+
    "\0\u845c\0\u84b2\0\u8508\0\u855e\0\u85b4\0\u860a\0\u8660\0\u86b6"+
    "\0\u870c\0\u8762\0\u87b8\0\u880e\0\u8864\0\u88ba\0\u8910\0\u8966"+
    "\0\u89bc\0\u8a12\0\u8a68\0\u8abe\0\u8b14\0\u8b6a\0\u8bc0\0\u8c16"+
    "\0\u8c6c\0\u8cc2\0\u8d18\0\u8d6e\0\u8dc4\0\u8e1a\0\u8e70\0\u8ec6"+
    "\0\u8f1c\0\u8f72\0\u8fc8\0\u901e\0\u9074\0\u90ca\0\u9120\0\u9176"+
    "\0\u91cc\0\u9222\0\u9278\0\u92ce\0\u9324\0\u937a\0\u93d0\0\u9426"+
    "\0\u947c\0\u94d2\0\u9528\0\u957e\0\u95d4\0\u962a\0\u9680\0\u96d6"+
    "\0\u972c\0\u9782\0\u97d8\0\u982e\0\u9884\0\u98da\0\u9930\0\u9986"+
    "\0\u99dc\0\u9a32\0\u9a88\0\u9ade\0\u9b34\0\u9b8a\0\u9be0\0\u9c36"+
    "\0\u9c8c\0\u9ce2\0\u9d38\0\u9d8e\0\u9de4\0\u9e3a\0\u9e90\0\u9ee6"+
    "\0\u9f3c\0\u9f92\0\u9fe8\0\ua03e\0\ua094\0\ua0ea\0\ua140\0\ua196"+
    "\0\ua1ec\0\ua242\0\ua298\0\ua2ee\0\ua344\0\ua39a\0\ua3f0\0\ua446"+
    "\0\ua49c\0\ua4f2\0\ua548\0\ua59e\0\ua5f4\0\ua64a\0\ua6a0\0\ua6f6"+
    "\0\ua74c\0\ua7a2\0\ua7f8\0\ua84e\0\ua8a4\0\ua8fa\0\ua950\0\ua9a6"+
    "\0\ua9fc\0\uaa52\0\uaaa8";

  private static int [] zzUnpackRowMap() {
    int [] result = new int[555];
    int offset = 0;
    offset = zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackRowMap(String packed, int offset, int [] result) {
    int i = 0;  /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int high = packed.charAt(i++) << 16;
      result[j++] = high | packed.charAt(i++);
    }
    return j;
  }

  /** 
   * The transition table of the DFA
   */
  private static final int [] ZZ_TRANS = zzUnpackTrans();

  private static final String ZZ_TRANS_PACKED_0 =
    "\2\11\2\12\1\13\1\14\1\15\1\16\1\17\1\20"+
    "\1\21\1\22\1\23\1\24\1\25\1\26\1\27\2\24"+
    "\1\30\1\31\1\32\2\24\1\33\7\24\1\34\2\35"+
    "\1\36\1\37\2\40\1\41\1\40\1\42\1\43\1\40"+
    "\1\24\1\44\1\45\1\46\1\24\1\47\1\50\2\24"+
    "\1\51\1\24\1\52\2\24\1\53\16\24\1\54\1\55"+
    "\1\56\1\0\1\24\1\57\1\24\1\60\1\0\2\24"+
    "\1\0\1\11\1\61\1\62\5\61\2\63\27\61\1\64"+
    "\31\61\1\65\16\61\1\66\2\61\1\0\11\61\25\67"+
    "\1\70\1\71\1\72\3\67\1\73\1\74\1\75\1\76"+
    "\10\67\1\77\10\67\1\100\11\67\1\101\1\67\1\102"+
    "\3\67\1\103\1\104\1\105\2\67\1\106\1\107\2\67"+
    "\1\110\1\111\1\67\1\0\4\67\1\0\2\67\1\0"+
    "\7\67\1\112\16\67\1\70\1\71\1\72\3\67\1\73"+
    "\1\74\1\75\1\76\10\67\1\77\10\67\1\100\11\67"+
    "\1\101\1\67\1\102\3\67\1\103\1\104\1\105\2\67"+
    "\1\106\1\107\2\67\1\110\1\111\1\67\1\0\4\67"+
    "\1\0\2\67\1\0\1\67\1\113\1\114\7\113\27\115"+
    "\14\113\16\115\1\113\16\115\1\113\1\116\1\113\1\0"+
    "\1\115\1\113\1\115\1\113\1\0\2\115\1\0\2\113"+
    "\1\114\1\113\1\117\66\113\1\120\16\113\1\121\2\113"+
    "\1\0\4\113\1\0\2\113\1\0\1\113\5\122\1\123"+
    "\64\122\1\124\16\122\1\125\6\122\1\113\4\122\1\113"+
    "\5\62\1\126\32\62\1\127\31\62\1\124\16\62\1\125"+
    "\2\62\1\0\4\62\1\0\2\62\1\0\1\62\133\0"+
    "\1\130\1\131\31\0\1\132\4\0\1\133\66\0\1\132"+
    "\36\0\1\133\172\0\1\134\25\0\4\135\1\136\1\137"+
    "\1\140\1\141\2\135\14\24\14\0\16\24\1\0\16\24"+
    "\1\0\1\24\2\0\3\24\2\0\2\24\14\0\26\24"+
    "\14\0\4\24\1\142\1\143\10\24\1\0\16\24\1\0"+
    "\1\24\2\0\3\24\2\0\2\24\14\0\21\24\1\144"+
    "\4\24\14\0\16\24\1\0\16\24\1\0\1\24\2\0"+
    "\3\24\2\0\2\24\14\0\26\24\14\0\1\145\1\24"+
    "\1\146\13\24\1\0\16\24\1\0\1\24\2\0\3\24"+
    "\2\0\2\24\14\0\26\24\14\0\16\24\1\0\16\24"+
    "\1\0\1\24\2\0\3\24\2\0\2\24\14\0\7\24"+
    "\1\147\16\24\14\0\7\24\1\150\5\24\1\151\1\0"+
    "\16\24\1\0\1\24\2\0\3\24\2\0\2\24\14\0"+
    "\12\24\1\152\13\24\14\0\16\24\1\0\16\24\1\0"+
    "\1\24\2\0\3\24\2\0\2\24\14\0\2\24\1\153"+
    "\23\24\14\0\16\24\1\0\16\24\1\0\1\24\2\0"+
    "\3\24\2\0\2\24\14\0\4\24\1\154\21\24\14\0"+
    "\6\24\1\155\7\24\1\0\16\24\1\0\1\24\2\0"+
    "\3\24\2\0\2\24\14\0\26\24\14\0\11\24\1\156"+
    "\4\24\1\0\16\24\1\0\1\24\2\0\3\24\2\0"+
    "\2\24\14\0\14\24\1\157\11\24\14\0\16\24\1\0"+
    "\16\24\1\0\1\24\2\0\3\24\2\0\2\24\14\0"+
    "\13\24\1\160\12\24\14\0\16\24\1\0\16\24\1\0"+
    "\1\24\2\0\3\24\2\0\2\24\7\0\1\161\1\162"+
    "\1\132\30\0\1\163\1\161\1\132\2\0\1\133\50\0"+
    "\1\164\54\0\1\133\65\0\2\133\31\0\1\165\2\133"+
    "\2\0\1\133\65\0\2\133\31\0\1\165\2\133\2\0"+
    "\1\133\2\0\1\133\122\0\1\132\125\0\1\132\2\0"+
    "\1\132\126\0\1\166\126\0\1\167\65\0\12\24\1\170"+
    "\13\24\14\0\2\24\1\171\13\24\1\0\16\24\1\0"+
    "\1\24\2\0\3\24\2\0\2\24\14\0\1\172\25\24"+
    "\14\0\16\24\1\0\16\24\1\0\1\24\2\0\3\24"+
    "\2\0\2\24\14\0\26\24\14\0\2\24\1\173\13\24"+
    "\1\0\16\24\1\0\1\24\2\0\3\24\2\0\2\24"+
    "\14\0\4\24\1\174\21\24\14\0\16\24\1\0\16\24"+
    "\1\0\1\24\2\0\3\24\2\0\2\24\14\0\26\24"+
    "\14\0\4\24\1\175\11\24\1\0\16\24\1\0\1\24"+
    "\2\0\3\24\2\0\2\24\14\0\26\24\14\0\5\24"+
    "\1\176\10\24\1\0\16\24\1\0\1\24\2\0\3\24"+
    "\2\0\2\24\14\0\26\24\14\0\1\151\15\24\1\0"+
    "\16\24\1\0\1\24\2\0\3\24\2\0\2\24\74\0"+
    "\1\177\16\0\1\200\5\0\1\201\100\0\1\200\16\0"+
    "\1\202\26\0\4\203\1\204\15\203\1\204\1\203\1\204"+
    "\1\203\1\164\13\0\3\203\1\204\12\203\1\0\16\203"+
    "\1\0\1\203\2\0\1\203\1\57\1\203\2\0\2\203"+
    "\2\0\1\61\1\0\5\61\2\205\27\61\1\0\31\61"+
    "\1\0\16\61\1\0\2\61\1\0\11\61\7\0\2\61"+
    "\155\0\1\206\103\0\1\207\1\0\1\210\43\0\1\211"+
    "\57\0\1\212\5\0\1\213\36\0\1\214\63\0\1\215"+
    "\51\0\1\216\52\0\1\217\3\0\1\220\174\0\1\221"+
    "\52\0\1\222\125\0\1\223\6\0\1\224\110\0\27\225"+
    "\3\0\1\225\7\0\16\225\1\226\16\225\1\226\4\0"+
    "\1\225\3\0\2\225\14\0\1\227\173\0\1\230\71\0"+
    "\1\231\122\0\1\232\41\0\1\233\60\0\1\234\42\0"+
    "\1\235\62\0\1\236\127\0\1\237\105\0\41\240\1\241"+
    "\50\240\1\242\13\240\5\0\1\243\1\244\131\0\26\115"+
    "\14\0\16\115\1\0\16\115\1\0\1\115\2\0\3\115"+
    "\2\0\2\115\5\0\1\117\66\0\1\245\16\0\1\245"+
    "\14\0\5\122\1\0\64\122\1\0\16\122\1\0\6\122"+
    "\1\0\4\122\1\0\5\246\1\130\64\246\1\0\33\246"+
    "\5\0\1\130\160\0\1\247\73\0\1\131\117\0\7\134"+
    "\2\250\30\134\1\251\50\134\1\252\13\134\12\0\5\24"+
    "\1\253\20\24\14\0\16\24\1\0\16\24\1\0\1\24"+
    "\2\0\3\24\2\0\2\24\14\0\6\24\1\135\17\24"+
    "\14\0\16\24\1\0\16\24\1\0\1\24\2\0\3\24"+
    "\2\0\2\24\14\0\7\24\1\254\16\24\14\0\16\24"+
    "\1\0\16\24\1\0\1\24\2\0\3\24\2\0\2\24"+
    "\14\0\12\24\1\255\13\24\14\0\16\24\1\0\16\24"+
    "\1\0\1\24\2\0\3\24\2\0\2\24\14\0\4\24"+
    "\1\256\21\24\14\0\16\24\1\0\16\24\1\0\1\24"+
    "\2\0\3\24\2\0\2\24\14\0\26\24\14\0\10\24"+
    "\1\153\5\24\1\0\16\24\1\0\1\24\2\0\3\24"+
    "\2\0\2\24\14\0\23\24\1\257\2\24\14\0\16\24"+
    "\1\0\16\24\1\0\1\24\2\0\3\24\2\0\2\24"+
    "\14\0\7\24\1\260\16\24\14\0\16\24\1\0\16\24"+
    "\1\0\1\24\2\0\3\24\2\0\2\24\14\0\26\24"+
    "\14\0\5\24\1\153\10\24\1\0\16\24\1\0\1\24"+
    "\2\0\3\24\2\0\2\24\14\0\26\24\14\0\3\24"+
    "\1\261\12\24\1\0\16\24\1\0\1\24\2\0\3\24"+
    "\2\0\2\24\14\0\11\24\1\262\14\24\14\0\16\24"+
    "\1\0\16\24\1\0\1\24\2\0\3\24\2\0\2\24"+
    "\14\0\6\24\1\263\17\24\14\0\16\24\1\0\16\24"+
    "\1\0\1\24\2\0\3\24\2\0\2\24\14\0\26\24"+
    "\14\0\1\264\15\24\1\0\16\24\1\0\1\24\2\0"+
    "\3\24\2\0\2\24\14\0\26\24\14\0\7\24\1\265"+
    "\6\24\1\0\16\24\1\0\1\24\2\0\3\24\2\0"+
    "\2\24\14\0\6\24\1\266\17\24\14\0\16\24\1\0"+
    "\16\24\1\0\1\24\2\0\3\24\2\0\2\24\14\0"+
    "\26\24\14\0\2\24\1\267\13\24\1\0\16\24\1\0"+
    "\1\24\2\0\3\24\2\0\2\24\14\0\15\24\1\270"+
    "\10\24\14\0\16\24\1\0\16\24\1\0\1\24\2\0"+
    "\3\24\2\0\2\24\14\0\14\24\1\271\11\24\14\0"+
    "\16\24\1\0\16\24\1\0\1\24\2\0\3\24\2\0"+
    "\2\24\42\0\1\132\73\0\1\132\31\0\1\132\125\0"+
    "\1\163\103\0\1\272\15\0\1\272\1\0\1\272\20\0"+
    "\1\272\36\0\1\164\14\0\2\133\32\0\4\133\132\0"+
    "\1\273\126\0\1\274\65\0\1\275\10\24\1\276\14\24"+
    "\14\0\16\24\1\0\16\24\1\0\1\24\2\0\3\24"+
    "\2\0\2\24\14\0\7\24\1\277\16\24\14\0\16\24"+
    "\1\0\16\24\1\0\1\24\2\0\3\24\2\0\2\24"+
    "\14\0\26\24\14\0\4\24\1\300\11\24\1\0\16\24"+
    "\1\0\1\24\2\0\3\24\2\0\2\24\14\0\1\301"+
    "\10\24\1\302\14\24\14\0\16\24\1\0\16\24\1\0"+
    "\1\24\2\0\3\24\2\0\2\24\14\0\6\24\1\303"+
    "\17\24\14\0\16\24\1\0\16\24\1\0\1\24\2\0"+
    "\3\24\2\0\2\24\14\0\4\24\1\304\21\24\14\0"+
    "\16\24\1\0\16\24\1\0\1\24\2\0\3\24\2\0"+
    "\2\24\74\0\1\177\16\0\1\200\106\0\1\200\16\0"+
    "\1\200\26\0\26\203\14\0\16\203\1\0\16\203\1\0"+
    "\1\203\2\0\3\203\2\0\2\203\14\0\26\203\3\0"+
    "\2\305\7\0\16\203\1\0\16\203\1\0\1\203\2\0"+
    "\1\203\1\306\1\203\2\0\2\203\7\0\1\307\32\0"+
    "\1\206\31\0\1\310\16\0\1\310\75\0\1\311\134\0"+
    "\1\312\120\0\1\313\121\0\1\314\131\0\1\315\60\0"+
    "\1\316\5\0\1\317\162\0\1\320\103\0\1\321\143\0"+
    "\1\322\71\0\1\323\141\0\1\324\106\0\1\325\212\0"+
    "\1\326\126\0\1\327\33\0\27\225\3\0\1\225\6\0"+
    "\1\330\16\225\1\0\16\225\5\0\1\225\3\0\2\225"+
    "\14\0\1\331\171\0\1\332\70\0\1\333\116\0\1\334"+
    "\176\0\1\335\123\0\1\336\120\0\1\337\132\0\1\340"+
    "\65\0\1\341\104\0\41\240\1\241\50\240\1\342\13\240"+
    "\5\246\1\0\64\246\1\0\33\246\7\0\2\134\115\0"+
    "\7\134\2\250\30\134\1\251\50\134\1\343\13\134\7\0"+
    "\2\242\127\0\11\24\1\135\14\24\14\0\16\24\1\0"+
    "\16\24\1\0\1\24\2\0\3\24\2\0\2\24\14\0"+
    "\2\24\1\135\23\24\14\0\16\24\1\0\16\24\1\0"+
    "\1\24\2\0\3\24\2\0\2\24\14\0\7\24\1\135"+
    "\16\24\14\0\16\24\1\0\16\24\1\0\1\24\2\0"+
    "\3\24\2\0\2\24\14\0\7\24\1\173\16\24\14\0"+
    "\16\24\1\0\16\24\1\0\1\24\2\0\3\24\2\0"+
    "\2\24\14\0\24\24\1\344\1\24\14\0\16\24\1\0"+
    "\16\24\1\0\1\24\2\0\3\24\2\0\2\24\14\0"+
    "\26\24\14\0\1\24\1\345\14\24\1\0\16\24\1\0"+
    "\1\24\2\0\3\24\2\0\2\24\14\0\2\24\1\346"+
    "\23\24\14\0\16\24\1\0\16\24\1\0\1\24\2\0"+
    "\3\24\2\0\2\24\14\0\4\24\1\347\21\24\14\0"+
    "\16\24\1\0\16\24\1\0\1\24\2\0\3\24\2\0"+
    "\2\24\14\0\1\350\25\24\14\0\16\24\1\0\16\24"+
    "\1\0\1\24\2\0\3\24\2\0\2\24\14\0\11\24"+
    "\1\351\14\24\14\0\16\24\1\0\16\24\1\0\1\24"+
    "\2\0\3\24\2\0\2\24\14\0\4\24\1\352\21\24"+
    "\14\0\16\24\1\0\16\24\1\0\1\24\2\0\3\24"+
    "\2\0\2\24\14\0\1\353\25\24\14\0\16\24\1\0"+
    "\16\24\1\0\1\24\2\0\3\24\2\0\2\24\14\0"+
    "\26\24\14\0\5\24\1\263\10\24\1\0\16\24\1\0"+
    "\1\24\2\0\3\24\2\0\2\24\14\0\17\24\1\354"+
    "\6\24\14\0\16\24\1\0\16\24\1\0\1\24\2\0"+
    "\3\24\2\0\2\24\14\0\15\24\1\135\10\24\14\0"+
    "\16\24\1\0\16\24\1\0\1\24\2\0\3\24\2\0"+
    "\2\24\45\0\2\305\51\0\1\305\21\0\26\24\14\0"+
    "\1\24\1\355\14\24\1\0\16\24\1\0\1\24\2\0"+
    "\3\24\2\0\2\24\14\0\4\24\1\173\21\24\14\0"+
    "\16\24\1\0\16\24\1\0\1\24\2\0\3\24\2\0"+
    "\2\24\14\0\1\356\25\24\14\0\16\24\1\0\16\24"+
    "\1\0\1\24\2\0\3\24\2\0\2\24\14\0\4\24"+
    "\1\357\21\24\14\0\16\24\1\0\16\24\1\0\1\24"+
    "\2\0\3\24\2\0\2\24\14\0\26\24\14\0\1\360"+
    "\15\24\1\0\16\24\1\0\1\24\2\0\3\24\2\0"+
    "\2\24\14\0\26\24\14\0\1\361\15\24\1\0\16\24"+
    "\1\0\1\24\2\0\3\24\2\0\2\24\14\0\26\24"+
    "\14\0\7\24\1\362\6\24\1\0\16\24\1\0\1\24"+
    "\2\0\3\24\2\0\2\24\14\0\12\24\1\363\13\24"+
    "\14\0\16\24\1\0\16\24\1\0\1\24\2\0\3\24"+
    "\2\0\2\24\120\0\1\305\21\0\26\203\14\0\16\203"+
    "\1\0\16\203\1\0\1\203\2\0\1\203\1\306\1\203"+
    "\2\0\2\203\7\0\1\364\125\0\1\307\64\0\1\310"+
    "\16\0\1\310\117\0\1\365\100\0\1\366\144\0\1\367"+
    "\111\0\1\370\64\0\1\371\175\0\1\372\111\0\1\373"+
    "\71\0\1\374\134\0\1\375\156\0\1\376\121\0\1\377"+
    "\77\0\1\u0100\160\0\1\u0101\64\0\1\u0102\134\0\1\u0103"+
    "\110\0\26\u0104\4\0\1\u0104\7\0\16\u0104\1\0\16\u0104"+
    "\5\0\1\u0104\4\0\1\u0104\21\0\1\u0105\162\0\1\u0106"+
    "\72\0\1\u0107\162\0\1\u0108\73\0\1\u0109\122\0\1\u010a"+
    "\125\0\1\u010b\162\0\1\u010c\124\0\1\u010d\50\0\7\134"+
    "\2\u010e\30\134\1\251\50\134\1\252\13\134\12\0\15\24"+
    "\1\u010f\10\24\14\0\16\24\1\0\16\24\1\0\1\24"+
    "\2\0\3\24\2\0\2\24\14\0\1\u0110\25\24\14\0"+
    "\16\24\1\0\16\24\1\0\1\24\2\0\3\24\2\0"+
    "\2\24\14\0\26\24\14\0\1\145\15\24\1\0\16\24"+
    "\1\0\1\24\2\0\3\24\2\0\2\24\14\0\6\24"+
    "\1\u0111\17\24\14\0\16\24\1\0\16\24\1\0\1\24"+
    "\2\0\3\24\2\0\2\24\14\0\4\24\1\350\21\24"+
    "\14\0\16\24\1\0\16\24\1\0\1\24\2\0\3\24"+
    "\2\0\2\24\14\0\26\24\14\0\1\24\1\u0112\14\24"+
    "\1\0\16\24\1\0\1\24\2\0\3\24\2\0\2\24"+
    "\14\0\26\24\14\0\1\24\1\u0113\14\24\1\0\16\24"+
    "\1\0\1\24\2\0\3\24\2\0\2\24\14\0\20\24"+
    "\1\u0114\5\24\14\0\16\24\1\0\16\24\1\0\1\24"+
    "\2\0\3\24\2\0\2\24\14\0\26\24\14\0\4\24"+
    "\1\173\11\24\1\0\16\24\1\0\1\24\2\0\3\24"+
    "\2\0\2\24\14\0\6\24\1\u0115\17\24\14\0\16\24"+
    "\1\0\16\24\1\0\1\24\2\0\3\24\2\0\2\24"+
    "\14\0\26\24\14\0\5\24\1\u0116\10\24\1\0\16\24"+
    "\1\0\1\24\2\0\3\24\2\0\2\24\14\0\26\24"+
    "\14\0\5\24\1\u0117\10\24\1\0\16\24\1\0\1\24"+
    "\2\0\3\24\2\0\2\24\14\0\26\24\14\0\14\24"+
    "\1\351\1\24\1\0\16\24\1\0\1\24\2\0\3\24"+
    "\2\0\2\24\14\0\4\24\1\153\21\24\14\0\16\24"+
    "\1\0\16\24\1\0\1\24\2\0\3\24\2\0\2\24"+
    "\14\0\26\24\14\0\12\24\1\350\3\24\1\0\16\24"+
    "\1\0\1\24\2\0\3\24\2\0\2\24\20\0\1\u0118"+
    "\130\0\1\u0119\122\0\1\u011a\127\0\1\u011b\176\0\1\u011c"+
    "\52\0\1\u011d\166\0\1\u011e\72\0\1\u0100\202\0\1\u0100"+
    "\50\0\1\u011f\117\0\1\u0120\170\0\1\u0121\56\0\1\u0122"+
    "\126\0\1\u0123\124\0\26\u0104\1\u0124\3\0\1\u0104\7\0"+
    "\16\u0104\1\0\16\u0104\5\0\1\u0104\4\0\1\u0104\115\0"+
    "\1\u0125\73\0\1\u0126\136\0\1\u0127\53\0\1\u0128\126\0"+
    "\1\u0129\130\0\1\u012a\157\0\1\u012b\137\0\1\u012c\53\0"+
    "\1\u012d\121\0\25\24\1\135\14\0\16\24\1\0\16\24"+
    "\1\0\1\24\2\0\3\24\2\0\2\24\14\0\6\24"+
    "\1\u012e\17\24\14\0\16\24\1\0\16\24\1\0\1\24"+
    "\2\0\3\24\2\0\2\24\14\0\2\24\1\u012f\23\24"+
    "\14\0\16\24\1\0\16\24\1\0\1\24\2\0\3\24"+
    "\2\0\2\24\14\0\1\153\25\24\14\0\16\24\1\0"+
    "\16\24\1\0\1\24\2\0\3\24\2\0\2\24\14\0"+
    "\26\24\14\0\4\24\1\153\11\24\1\0\16\24\1\0"+
    "\1\24\2\0\3\24\2\0\2\24\14\0\21\24\1\u0130"+
    "\4\24\14\0\16\24\1\0\16\24\1\0\1\24\2\0"+
    "\3\24\2\0\2\24\14\0\7\24\1\u0131\16\24\14\0"+
    "\16\24\1\0\16\24\1\0\1\24\2\0\3\24\2\0"+
    "\2\24\14\0\26\24\14\0\6\24\1\u0132\7\24\1\0"+
    "\16\24\1\0\1\24\2\0\3\24\2\0\2\24\14\0"+
    "\7\24\1\350\16\24\14\0\16\24\1\0\16\24\1\0"+
    "\1\24\2\0\3\24\2\0\2\24\74\0\1\u0133\125\0"+
    "\1\u0134\56\0\1\u0135\157\0\1\u0136\62\0\1\u0137\134\0"+
    "\1\u0138\122\0\1\u0139\125\0\1\u013a\172\0\1\u013b\60\0"+
    "\1\u013c\125\0\1\u013d\143\0\1\u013e\103\0\26\u013f\4\0"+
    "\1\u0104\7\0\16\u013f\1\0\16\u013f\5\0\1\u0104\4\0"+
    "\1\u013f\7\0\1\u0140\212\0\1\u0141\61\0\1\u0142\120\0"+
    "\1\u0143\176\0\1\u0144\114\0\1\u0145\136\0\1\u0146\51\0"+
    "\1\u0147\130\0\1\u0148\116\0\26\24\14\0\2\24\1\u0149"+
    "\13\24\1\0\16\24\1\0\1\24\2\0\3\24\2\0"+
    "\2\24\14\0\22\24\1\135\3\24\14\0\16\24\1\0"+
    "\16\24\1\0\1\24\2\0\3\24\2\0\2\24\14\0"+
    "\26\24\14\0\1\351\15\24\1\0\16\24\1\0\1\24"+
    "\2\0\3\24\2\0\2\24\14\0\6\24\1\u014a\17\24"+
    "\14\0\16\24\1\0\16\24\1\0\1\24\2\0\3\24"+
    "\2\0\2\24\27\0\1\u014b\204\0\1\u014c\33\0\1\u014d"+
    "\205\0\1\u014e\51\0\1\u014f\121\0\1\u0150\205\0\1\u0151"+
    "\116\0\1\u0152\134\0\1\u0153\125\0\1\u0154\111\0\1\u0100"+
    "\101\0\1\u0100\105\0\26\u0155\1\u0124\3\0\1\u0104\7\0"+
    "\16\u0155\1\0\16\u0155\5\0\1\u0104\4\0\1\u0155\7\0"+
    "\1\u0156\153\0\1\u0157\124\0\1\u0158\23\0\1\u0159\65\0"+
    "\1\u015a\134\0\1\u015b\1\u015c\156\0\1\u015d\153\0\1\u015e"+
    "\112\0\1\u015f\45\0\1\u0160\125\0\7\24\1\u0161\16\24"+
    "\14\0\16\24\1\0\16\24\1\0\1\24\2\0\3\24"+
    "\2\0\2\24\14\0\11\24\1\276\14\24\14\0\16\24"+
    "\1\0\16\24\1\0\1\24\2\0\3\24\2\0\2\24"+
    "\14\0\1\u0162\1\u0163\136\0\1\u0164\54\0\1\u0165\105\0"+
    "\1\u0166\102\0\1\u0167\161\0\1\u0168\125\0\1\u0169\137\0"+
    "\1\u016a\113\0\1\u016b\140\0\1\u016c\53\0\1\u016d\42\0"+
    "\1\u016e\41\0\26\u016f\1\u0124\3\0\1\u0104\3\0\1\u0170"+
    "\3\0\16\u016f\1\u0171\16\u016f\1\u0171\4\0\1\u0104\4\0"+
    "\1\u016f\2\0\1\u0172\1\0\5\u0172\2\0\61\u0172\1\0"+
    "\16\u0172\1\0\2\u0172\1\0\4\u0172\1\0\4\u0172\24\0"+
    "\1\u0173\54\0\1\u0174\122\0\1\u0175\112\0\1\u0176\134\0"+
    "\1\u0177\53\0\1\u0178\6\0\1\u0179\130\0\1\u017a\23\0"+
    "\1\u017b\141\0\1\u017c\65\0\1\u017d\23\0\1\u017e\104\0"+
    "\1\u017f\162\0\1\u0180\51\0\1\u0181\143\0\1\u0182\152\0"+
    "\1\u0183\103\0\1\u0184\104\0\1\u0185\125\0\1\u0186\15\0"+
    "\1\u0187\127\0\1\u0188\125\0\1\u0189\121\0\1\u018a\23\0"+
    "\1\u018b\151\0\1\u018c\77\0\1\u018d\22\0\1\u018e\52\0"+
    "\1\u018f\54\0\1\u0190\50\0\1\u0191\54\0\1\u0192\36\0"+
    "\26\u0193\1\u0124\3\0\1\u0104\3\0\1\u0170\3\0\16\u0193"+
    "\1\u0171\16\u0193\1\u0171\4\0\1\u0104\4\0\1\u0193\52\0"+
    "\1\u0170\21\0\1\u0171\16\0\1\u0171\73\0\1\u0194\104\0"+
    "\1\u0195\165\0\1\u0196\112\0\1\u0197\76\0\1\u0198\161\0"+
    "\1\u0199\70\0\1\u019a\131\0\1\u019b\147\0\1\u019c\75\0"+
    "\1\u019d\111\0\1\u019e\124\0\1\u019f\131\0\1\u01a0\6\0"+
    "\1\u01a1\124\0\1\u01a2\47\0\1\u01a3\45\0\1\u01a4\143\0"+
    "\1\u01a5\107\0\1\u01a6\143\0\1\u01a7\163\0\1\u01a8\116\0"+
    "\1\u01a9\140\0\1\u01aa\45\0\1\u01ab\15\0\1\u01ac\115\0"+
    "\1\u01ad\54\0\1\u01ae\57\0\1\u01af\162\0\1\u01b0\61\0"+
    "\1\u01b1\54\0\1\u01b2\107\0\1\u01b3\140\0\1\u01b4\110\0"+
    "\1\u01b5\103\0\1\u01b6\107\0\1\u01b7\177\0\1\u01b8\44\0"+
    "\26\u01b9\1\u0124\3\0\1\u0104\3\0\1\u0170\3\0\16\u01b9"+
    "\1\u0171\16\u01b9\1\u0171\4\0\1\u0104\4\0\1\u01b9\22\0"+
    "\1\u01ba\134\0\1\u01bb\132\0\1\u01bc\107\0\1\u01bd\172\0"+
    "\1\u01be\12\0\1\u01bf\105\0\1\u01c0\101\0\1\u01c1\166\0"+
    "\1\u01c2\53\0\1\u01c3\160\0\1\u01c4\22\0\1\u01c5\65\0"+
    "\1\u01c2\147\0\1\u01c3\121\0\1\u01c6\76\0\1\u01c7\131\0"+
    "\1\u01c8\23\0\1\u01c9\65\0\1\u01ca\1\0\1\u01c6\6\0"+
    "\1\u01c7\4\0\1\u01cb\152\0\1\u0100\103\0\1\u0100\111\0"+
    "\1\u01cc\127\0\1\u01cd\176\0\1\u01ce\11\0\1\u01cf\41\0"+
    "\1\u01d0\202\0\1\u01d1\45\0\1\u01d2\177\0\1\u01d3\127\0"+
    "\1\u01d4\136\0\1\u01d5\53\0\1\u01d6\107\0\1\u01d7\163\0"+
    "\1\u01d8\150\0\1\u01d9\46\0\1\u01da\134\0\1\u01db\114\0"+
    "\1\u01dc\143\0\1\u01dd\150\0\1\u013d\104\0\1\u013e\101\0"+
    "\26\u0104\1\u0124\3\0\1\u0104\3\0\1\u0170\3\0\16\u0104"+
    "\1\u0171\16\u0104\1\u0171\4\0\1\u0104\4\0\1\u0104\23\0"+
    "\1\u01de\177\0\1\u01df\45\0\1\u01cd\124\0\1\u01cc\133\0"+
    "\1\u01e0\134\0\1\u01e1\117\0\1\u0100\177\0\1\u0100\66\0"+
    "\1\u01e2\107\0\1\u01e3\212\0\1\u01e4\126\0\1\u01e5\45\0"+
    "\1\u01e6\202\0\1\u01e7\123\0\1\u01e8\102\0\1\u01e9\160\0"+
    "\1\u01ea\123\0\1\u01eb\32\0\1\u01ec\126\0\1\u01ed\130\0"+
    "\1\u01ee\15\0\1\u01ef\123\0\1\u01f0\23\0\1\u01f1\137\0"+
    "\1\u01f2\70\0\1\u01f3\112\0\1\u01f4\134\0\1\u01f5\116\0"+
    "\1\u01f6\134\0\1\u01f7\172\0\1\u0100\53\0\1\u0100\162\0"+
    "\1\u01f8\104\0\1\u01f9\113\0\1\u01fa\202\0\1\u01fb\101\0"+
    "\1\u01fc\76\0\1\u01fd\117\0\1\u01fe\134\0\1\u01ff\122\0"+
    "\1\u0200\202\0\1\u0201\37\0\1\u0100\124\0\1\u0100\167\0"+
    "\1\u0202\150\0\1\u0203\107\0\1\u01f6\103\0\1\u01f7\174\0"+
    "\1\u0204\114\0\1\u0205\46\0\1\u0206\143\0\1\u0207\107\0"+
    "\1\u0100\143\0\1\u0100\150\0\1\u0208\104\0\1\u0209\166\0"+
    "\1\u020a\102\0\1\u020b\75\0\1\u020c\202\0\1\u020d\46\0"+
    "\1\u01c3\177\0\1\u01c2\110\0\1\u0100\104\0\1\u0100\107\0"+
    "\1\u01c0\134\0\1\u01c1\153\0\1\u020e\76\0\1\u020f\157\0"+
    "\1\u0210\76\0\1\u0211\140\0\1\u0212\125\0\1\u0213\104\0"+
    "\1\u0100\127\0\1\u0100\116\0\1\u0214\143\0\1\u0215\125\0"+
    "\1\u0216\107\0\1\u0217\163\0\1\u0218\150\0\1\u0219\107\0"+
    "\1\u021a\103\0\1\u021b\121\0\1\u021c\162\0\1\u021d\116\0"+
    "\1\u021e\103\0\1\u021f\146\0\1\u0200\76\0\1\u0201\120\0"+
    "\1\u0220\202\0\1\u0221\120\0\1\u0222\125\0\1\u0223\52\0"+
    "\1\u0224\177\0\1\u0225\71\0\1\u01e2\147\0\1\u01e3\65\0"+
    "\1\u01ec\177\0\1\u01ed\106\0\1\u0100\150\0\1\u0100\127\0"+
    "\1\u01a5\50\0\1\u01a4\162\0\1\u01ec\103\0\1\u01ed\151\0"+
    "\1\u0100\140\0\1\u0100\105\0\1\u0226\101\0\1\u0227\111\0"+
    "\1\u0228\143\0\1\u0229\145\0\1\u022a\150\0\1\u022b\112\0"+
    "\1\u0100\141\0\1\u0100\45\0\1\u0218\134\0\1\u0219\76\0";

  private static int [] zzUnpackTrans() {
    int [] result = new int[43774];
    int offset = 0;
    offset = zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackTrans(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /* error codes */
  private static final int ZZ_UNKNOWN_ERROR = 0;
  private static final int ZZ_NO_MATCH = 1;
  private static final int ZZ_PUSHBACK_2BIG = 2;

  /* error messages for the codes above */
  private static final String ZZ_ERROR_MSG[] = {
    "Unknown internal scanner error",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /**
   * ZZ_ATTRIBUTE[aState] contains the attributes of state <code>aState</code>
   */
  private static final int [] ZZ_ATTRIBUTE = zzUnpackAttribute();

  private static final String ZZ_ATTRIBUTE_PACKED_0 =
    "\1\0\1\1\4\0\1\1\1\0\3\11\46\1\1\11"+
    "\2\1\3\11\11\1\1\11\6\1\1\11\2\1\2\11"+
    "\2\1\1\11\4\1\2\11\2\1\1\11\1\1\2\11"+
    "\1\0\30\1\1\0\11\1\1\0\1\1\2\0\2\1"+
    "\1\0\1\1\33\0\2\11\2\0\2\1\3\0\34\1"+
    "\1\0\1\1\31\0\1\1\1\0\20\1\1\11\13\0"+
    "\1\11\15\0\12\1\26\0\5\1\26\0\2\1\26\0"+
    "\1\1\16\0\1\11\1\0\1\1\271\0";

  private static int [] zzUnpackAttribute() {
    int [] result = new int[555];
    int offset = 0;
    offset = zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAttribute(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /** the input device */
  private java.io.Reader zzReader;

  /** the current state of the DFA */
  private int zzState;

  /** the current lexical state */
  private int zzLexicalState = YYINITIAL;

  /** this buffer contains the current text to be matched and is
      the source of the yytext() string */
  private char zzBuffer[] = new char[ZZ_BUFFERSIZE];

  /** the textposition at the last accepting state */
  private int zzMarkedPos;

  /** the current text position in the buffer */
  private int zzCurrentPos;

  /** startRead marks the beginning of the yytext() string in the buffer */
  private int zzStartRead;

  /** endRead marks the last character in the buffer, that has been read
      from input */
  private int zzEndRead;

  /** number of newlines encountered up to the start of the matched text */
  private int yyline;

  /** the number of characters up to the start of the matched text */
  private int yychar;

  /**
   * the number of characters from the last newline up to the start of the 
   * matched text
   */
  private int yycolumn;

  /** 
   * zzAtBOL == true <=> the scanner is currently at the beginning of a line
   */
  private boolean zzAtBOL = true;

  /** zzAtEOF == true <=> the scanner is at the EOF */
  private boolean zzAtEOF;

  /** denotes if the user-EOF-code has already been executed */
  private boolean zzEOFDone;
  
  /** 
   * The number of occupied positions in zzBuffer beyond zzEndRead.
   * When a lead/high surrogate has been read from the input stream
   * into the final zzBuffer position, this will have a value of 1;
   * otherwise, it will have a value of 0.
   */
  private int zzFinalHighSurrogate = 0;

  /* user code: */
    public int start;
    public int end;
    public int beginString;
    public static Set<String> commands = new HashSet<String>();
    public static Set<String> macros = new HashSet<String>();
    public static Set<String> variables = new HashSet<String>();
    public Set<String> infile;

    private ScilabDocument doc;
    private boolean transposable;
    private Element elem;
    private boolean breakstring;
    private boolean breakcomment;
    private MatchingBlockScanner matchBlock;

    static {
	// For SciNotes colors in preferences
	commands.add("cos");
	macros.add("sind");
    }

    public ScilabLexer(ScilabDocument doc) {
	this(doc, new MatchingBlockScanner(doc), true);
    }

    public ScilabLexer(ScilabDocument doc, boolean update) {
	this(doc, new MatchingBlockScanner(doc), update);
    }

    public ScilabLexer(ScilabDocument doc, MatchingBlockScanner matchBlock, boolean update) {
        this.doc = doc;
        this.elem = doc.getDefaultRootElement();
        this.infile = doc.getFunctionsInDoc();
	this.matchBlock = matchBlock;
	if (update) {
		update();
	}
    }

    public static void update() {
       if (ScilabCommonsUtils.isScilabThread()) {
           String[] vars = ScilabKeywords.GetVariablesName();
           String[] funs = ScilabKeywords.GetFunctionsName();
           String[] macs = ScilabKeywords.GetMacrosName();
           variables.clear();
           commands.clear();
           macros.clear();
           if (vars != null) {
               variables.addAll(Arrays.asList(vars));
           }
           if (funs != null) {
               commands.addAll(Arrays.asList(funs));
           }
           if (macs != null) {
               macros.addAll(Arrays.asList(macs));
           }
	}
    }

    public void setRange(int p0, int p1) {
        start = p0;
        end = p1;
        transposable = false;
        breakstring = false;
        yyreset(new ScilabDocumentReader(doc, p0, p1));
        int currentLine = elem.getElementIndex(start);
        if (currentLine != 0) {
	   ScilabDocument.ScilabLeafElement e = (ScilabDocument.ScilabLeafElement) elem.getElement(currentLine - 1);
	   if (e.isBrokenString()) {
              yybegin(QSTRING);
	   } else if (e.isBlockComment()) {
	      yybegin(BLOCKCOMMENT);
	   }
        }
    }

    public int yychar() {
        return yychar;
    }

    public int scan() throws IOException {
        int ret = yylex();
	int lastPos = start + yychar + yylength();
        if (lastPos == end - 1) {
           ((ScilabDocument.ScilabLeafElement) elem.getElement(elem.getElementIndex(start))).setBrokenString(breakstring);
           breakstring = false;
        } else if (lastPos == end) {
	   ((ScilabDocument.ScilabLeafElement) elem.getElement(elem.getElementIndex(start))).setBlockComment(yystate() == BLOCKCOMMENT);
        }
	return ret;
    }

    public boolean isLineFinishedByBlockComment(int start, int end) {
        this.start = start;
	this.end = end;
	try {		
           yyreset(new ScilabDocumentReader(doc, start, end));
	   int tok = 0;
	   while (tok != ScilabLexerConstants.EOF) {
	      tok = yylex();
	   }
        } catch (Exception e) { }
	
	return yystate() == BLOCKCOMMENT;
    }

    public int getKeyword(int pos, boolean strict) {
        // Pre condition
        if (elem == null) {
            return ScilabLexerConstants.DEFAULT;
        }

        Element line = elem.getElement(elem.getElementIndex(pos));
        int end = line.getEndOffset();
        int tok = -1;
        start = line.getStartOffset();
        int startL = start;
        int s = -1;

        try {
           yyreset(new ScilabDocumentReader(doc, start, end));
           if (!strict) {
              pos++;
           }

           while (startL < pos && (s != startL || yystate() == BREAKSTRING)) {
               s = startL;
               tok = yylex();
               startL = start + yychar + yylength();
           }

           return tok;
        } catch (IOException e) {
           return ScilabLexerConstants.DEFAULT;
        }
     }

     public static ScilabTokens getScilabTokens(String str) {
     	 ScilabDocument doc = new ScilabDocument(false);
	 try {
	     doc.insertString(0, str, null);
         } catch (BadLocationException e) { }
	 return getScilabTokens(doc);
     }

     public static ScilabTokens getScilabTokens(ScilabDocument doc) {
     	 ScilabLexer lexer = new ScilabLexer(doc);
	 lexer.yyreset(new ScilabDocumentReader(doc, 0, doc.getLength()));
	 ScilabTokens tokens = new ScilabTokens();
	 int tok = -1;
	 try {
	    while (tok != ScilabLexerConstants.EOF) {
               tok = lexer.yylex();
    	       tokens.add(tok, lexer.yychar + lexer.yylength());
	    }
	 } catch (IOException e) { }
 
	 return tokens;
     }

     public static class ScilabTokens {
        private List<Integer> tokenType = new ArrayList<Integer>();
        private List<Integer> tokenPos = new ArrayList<Integer>();

	ScilabTokens() { }

	void add(final int type, final int pos) {
	   tokenType.add(type);
	   tokenPos.add(pos);
	}

	public final List<Integer> getTokenType() {
	   return tokenType;
	}

	public final List<Integer> getTokenPos() {
	   return tokenPos;
	}
     }


  /**
   * Creates a new scanner
   *
   * @param   in  the java.io.Reader to read input from.
   */
  public ScilabLexer(java.io.Reader in) {
    this.zzReader = in;
  }


  /** 
   * Unpacks the compressed character translation table.
   *
   * @param packed   the packed character translation table
   * @return         the unpacked character translation table
   */
  private static char [] zzUnpackCMap(String packed) {
    char [] map = new char[0x110000];
    int i = 0;  /* index in packed string  */
    int j = 0;  /* index in unpacked array */
    while (i < 230) {
      int  count = packed.charAt(i++);
      char value = packed.charAt(i++);
      do map[j++] = value; while (--count > 0);
    }
    return map;
  }


  /**
   * Refills the input buffer.
   *
   * @return      <code>false</code>, iff there was new input.
   * 
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  private boolean zzRefill() throws java.io.IOException {

    /* first: make room (if you can) */
    if (zzStartRead > 0) {
      zzEndRead += zzFinalHighSurrogate;
      zzFinalHighSurrogate = 0;
      System.arraycopy(zzBuffer, zzStartRead,
                       zzBuffer, 0,
                       zzEndRead-zzStartRead);

      /* translate stored positions */
      zzEndRead-= zzStartRead;
      zzCurrentPos-= zzStartRead;
      zzMarkedPos-= zzStartRead;
      zzStartRead = 0;
    }

    /* is the buffer big enough? */
    if (zzCurrentPos >= zzBuffer.length - zzFinalHighSurrogate) {
      /* if not: blow it up */
      char newBuffer[] = new char[zzBuffer.length*2];
      System.arraycopy(zzBuffer, 0, newBuffer, 0, zzBuffer.length);
      zzBuffer = newBuffer;
      zzEndRead += zzFinalHighSurrogate;
      zzFinalHighSurrogate = 0;
    }

    /* fill the buffer with new input */
    int requested = zzBuffer.length - zzEndRead;
    int numRead = zzReader.read(zzBuffer, zzEndRead, requested);

    /* not supposed to occur according to specification of java.io.Reader */
    if (numRead == 0) {
      throw new java.io.IOException("Reader returned 0 characters. See JFlex examples for workaround.");
    }
    if (numRead > 0) {
      zzEndRead += numRead;
      /* If numRead == requested, we might have requested to few chars to
         encode a full Unicode character. We assume that a Reader would
         otherwise never return half characters. */
      if (numRead == requested) {
        if (Character.isHighSurrogate(zzBuffer[zzEndRead - 1])) {
          --zzEndRead;
          zzFinalHighSurrogate = 1;
        }
      }
      /* potentially more input available */
      return false;
    }

    /* numRead < 0 ==> end of stream */
    return true;
  }

    
  /**
   * Closes the input stream.
   */
  public final void yyclose() throws java.io.IOException {
    zzAtEOF = true;            /* indicate end of file */
    zzEndRead = zzStartRead;  /* invalidate buffer    */

    if (zzReader != null)
      zzReader.close();
  }


  /**
   * Resets the scanner to read from a new input stream.
   * Does not close the old reader.
   *
   * All internal variables are reset, the old input stream 
   * <b>cannot</b> be reused (internal buffer is discarded and lost).
   * Lexical state is set to <tt>ZZ_INITIAL</tt>.
   *
   * Internal scan buffer is resized down to its initial length, if it has grown.
   *
   * @param reader   the new input stream 
   */
  public final void yyreset(java.io.Reader reader) {
    zzReader = reader;
    zzAtBOL  = true;
    zzAtEOF  = false;
    zzEOFDone = false;
    zzEndRead = zzStartRead = 0;
    zzCurrentPos = zzMarkedPos = 0;
    zzFinalHighSurrogate = 0;
    yyline = yychar = yycolumn = 0;
    zzLexicalState = YYINITIAL;
    if (zzBuffer.length > ZZ_BUFFERSIZE)
      zzBuffer = new char[ZZ_BUFFERSIZE];
  }


  /**
   * Returns the current lexical state.
   */
  public final int yystate() {
    return zzLexicalState;
  }


  /**
   * Enters a new lexical state
   *
   * @param newState the new lexical state
   */
  public final void yybegin(int newState) {
    zzLexicalState = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   */
  public final String yytext() {
    return new String( zzBuffer, zzStartRead, zzMarkedPos-zzStartRead );
  }


  /**
   * Returns the character at position <tt>pos</tt> from the 
   * matched text. 
   * 
   * It is equivalent to yytext().charAt(pos), but faster
   *
   * @param pos the position of the character to fetch. 
   *            A value from 0 to yylength()-1.
   *
   * @return the character at position pos
   */
  public final char yycharat(int pos) {
    return zzBuffer[zzStartRead+pos];
  }


  /**
   * Returns the length of the matched text region.
   */
  public final int yylength() {
    return zzMarkedPos-zzStartRead;
  }


  /**
   * Reports an error that occured while scanning.
   *
   * In a wellformed scanner (no or only correct usage of 
   * yypushback(int) and a match-all fallback rule) this method 
   * will only be called with things that "Can't Possibly Happen".
   * If this method is called, something is seriously wrong
   * (e.g. a JFlex bug producing a faulty scanner etc.).
   *
   * Usual syntax/scanner level error handling should be done
   * in error fallback rules.
   *
   * @param   errorCode  the code of the errormessage to display
   */
  private void zzScanError(int errorCode) {
    String message;
    try {
      message = ZZ_ERROR_MSG[errorCode];
    }
    catch (ArrayIndexOutOfBoundsException e) {
      message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
    }

    throw new Error(message);
  } 


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * They will be read again by then next call of the scanning method
   *
   * @param number  the number of characters to be read again.
   *                This number must not be greater than yylength()!
   */
  public void yypushback(int number)  {
    if ( number > yylength() )
      zzScanError(ZZ_PUSHBACK_2BIG);

    zzMarkedPos -= number;
  }


  /**
   * Resumes scanning until the next regular expression is matched,
   * the end of input is encountered or an I/O-Error occurs.
   *
   * @return      the next token
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  public int yylex() throws java.io.IOException {
    int zzInput;
    int zzAction;

    // cached fields:
    int zzCurrentPosL;
    int zzMarkedPosL;
    int zzEndReadL = zzEndRead;
    char [] zzBufferL = zzBuffer;
    char [] zzCMapL = ZZ_CMAP;

    int [] zzTransL = ZZ_TRANS;
    int [] zzRowMapL = ZZ_ROWMAP;
    int [] zzAttrL = ZZ_ATTRIBUTE;

    while (true) {
      zzMarkedPosL = zzMarkedPos;

      yychar+= zzMarkedPosL-zzStartRead;

      zzAction = -1;

      zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;
  
      zzState = ZZ_LEXSTATE[zzLexicalState];

      // set up zzAction for empty match case:
      int zzAttributes = zzAttrL[zzState];
      if ( (zzAttributes & 1) == 1 ) {
        zzAction = zzState;
      }


      zzForAction: {
        while (true) {
    
          if (zzCurrentPosL < zzEndReadL) {
            zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL, zzEndReadL);
            zzCurrentPosL += Character.charCount(zzInput);
          }
          else if (zzAtEOF) {
            zzInput = YYEOF;
            break zzForAction;
          }
          else {
            // store back cached positions
            zzCurrentPos  = zzCurrentPosL;
            zzMarkedPos   = zzMarkedPosL;
            boolean eof = zzRefill();
            // get translated positions and possibly new buffer
            zzCurrentPosL  = zzCurrentPos;
            zzMarkedPosL   = zzMarkedPos;
            zzBufferL      = zzBuffer;
            zzEndReadL     = zzEndRead;
            if (eof) {
              zzInput = YYEOF;
              break zzForAction;
            }
            else {
              zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL, zzEndReadL);
              zzCurrentPosL += Character.charCount(zzInput);
            }
          }
          int zzNext = zzTransL[ zzRowMapL[zzState] + zzCMapL[zzInput] ];
          if (zzNext == -1) break zzForAction;
          zzState = zzNext;

          zzAttributes = zzAttrL[zzState];
          if ( (zzAttributes & 1) == 1 ) {
            zzAction = zzState;
            zzMarkedPosL = zzCurrentPosL;
            if ( (zzAttributes & 8) == 8 ) break zzForAction;
          }

        }
      }

      // store back cached position
      zzMarkedPos = zzMarkedPosL;

      if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
        zzAtEOF = true;
              {
                return ScilabLexerConstants.EOF;
              }
      }
      else {
        switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
          case 1: 
            { return ScilabLexerConstants.STRING;
            }
          case 44: break;
          case 2: 
            { transposable = false;
                                   return ScilabLexerConstants.DEFAULT;
            }
          case 45: break;
          case 3: 
            { transposable = false;
                                   return ScilabLexerConstants.OPENCLOSE;
            }
          case 46: break;
          case 4: 
            { transposable = true;
                                   return ScilabLexerConstants.OPENCLOSE;
            }
          case 47: break;
          case 5: 
            { transposable = false;
                                   return ScilabLexerConstants.OPERATOR;
            }
          case 48: break;
          case 6: 
            { if (transposable) {
                                       return ScilabLexerConstants.TRANSP;
                                    } else {
                                       beginString = zzStartRead;
                                       yybegin(QSTRING);
                                       return ScilabLexerConstants.STRING;
                                    }
            }
          case 49: break;
          case 7: 
            { transposable = false;
                                   beginString = zzStartRead;
                                   yybegin(QSTRING);
                                   return ScilabLexerConstants.STRING;
            }
          case 50: break;
          case 8: 
            { transposable = true;
                                   String str = yytext();
                                   if (commands.contains(str)) {
                                       yybegin(COMMANDS);
                                       return ScilabLexerConstants.COMMANDS;
                                   } else if (macros.contains(str)) {
                                       yybegin(COMMANDS);
                                       return ScilabLexerConstants.MACROS;
                                   } else if (infile.contains(str)) {
                                       yybegin(COMMANDS);
                                       return ScilabLexerConstants.MACROINFILE;
                                   } else {
                                       List<String>[] arr = doc.getInOutArgs(start + yychar);
                                       if (arr != null && (arr[0].contains(str) || arr[1].contains(str))) {
                                           return ScilabLexerConstants.INPUTOUTPUTARGS;
                                       } else if (variables.contains(str)) {
                                           return ScilabLexerConstants.VARIABLES;
                                       }
                                   }
                                   return ScilabLexerConstants.ID;
            }
          case 51: break;
          case 9: 
            { transposable = false;
                                   yybegin(FIELD);
                                   return ScilabLexerConstants.OPERATOR;
            }
          case 52: break;
          case 10: 
            { return ScilabLexerConstants.WHITE;
            }
          case 53: break;
          case 11: 
            { return ScilabLexerConstants.TAB;
            }
          case 54: break;
          case 12: 
            { transposable = false;
                                   return ScilabLexerConstants.SPECIAL;
            }
          case 55: break;
          case 13: 
            { transposable = true;
                                   return ScilabLexerConstants.NUMBER;
            }
          case 56: break;
          case 14: 
            { return ScilabLexerConstants.DEFAULT;
            }
          case 57: break;
          case 15: 
            { transposable = false;
                                   yybegin(YYINITIAL);
                                   return ScilabLexerConstants.STRING;
            }
          case 58: break;
          case 16: 
            { return ScilabLexerConstants.WHITE_STRING;
            }
          case 59: break;
          case 17: 
            { return ScilabLexerConstants.TAB_STRING;
            }
          case 60: break;
          case 18: 
            { return ScilabLexerConstants.COMMENT;
            }
          case 61: break;
          case 19: 
            { return ScilabLexerConstants.WHITE_COMMENT;
            }
          case 62: break;
          case 20: 
            { return ScilabLexerConstants.TAB_COMMENT;
            }
          case 63: break;
          case 21: 
            { yypushback(1);
                                   yybegin(YYINITIAL);
            }
          case 64: break;
          case 22: 
            { 
            }
          case 65: break;
          case 23: 
            { transposable = true;
                                   return ScilabLexerConstants.FIELD;
            }
          case 66: break;
          case 24: 
            { yypushback(yylength());
                                   yybegin(YYINITIAL);
            }
          case 67: break;
          case 25: 
            { yybegin(COMMANDSWHITE);
                                   return ScilabLexerConstants.WHITE;
            }
          case 68: break;
          case 26: 
            { yybegin(COMMANDSWHITE);
                                   return ScilabLexerConstants.TAB;
            }
          case 69: break;
          case 27: 
            { transposable = false;
                                   yypushback(2);
                                   yybegin(COMMENT);
            }
          case 70: break;
          case 28: 
            { transposable = false;
                                   yypushback(2);
                                   yybegin(BLOCKCOMMENT);
            }
          case 71: break;
          case 29: 
            { return ScilabLexerConstants.ERROR;
            }
          case 72: break;
          case 30: 
            { transposable = true;
                                   return ScilabLexerConstants.CONSTANTES;
            }
          case 73: break;
          case 31: 
            { transposable = false;
                                   return ScilabLexerConstants.OSKEYWORD;
            }
          case 74: break;
          case 32: 
            { transposable = false;
                                   return ScilabLexerConstants.SKEYWORD;
            }
          case 75: break;
          case 33: 
            { yypushback(yylength());
                                   yybegin(BREAKSTRING);
                                   transposable = false;
                                   return ScilabLexerConstants.STRING;
            }
          case 76: break;
          case 34: 
            { return ScilabLexerConstants.LATEX;
            }
          case 77: break;
          case 35: 
            { yybegin(YYINITIAL);
				   return ScilabLexerConstants.COMMENT;
            }
          case 78: break;
          case 36: 
            { breakstring = true;
                                   return ScilabLexerConstants.SPECIAL;
            }
          case 79: break;
          case 37: 
            { transposable = false;
				   if (matchBlock != null) {
				      MatchingBlockScanner.MatchingPositions pos = matchBlock.getMatchingBlock(start + yychar + yylength(), false);
				      if (pos != null) {
				         try {
				      	     String match = doc.getText(pos.secondB, pos.secondE - pos.secondB);
				      	     if (match.equals("function")) {
					        return ScilabLexerConstants.FKEYWORD;
					     }
				      	 } catch (BadLocationException e) { }
				      }
				   }
                                   return ScilabLexerConstants.OSKEYWORD;
            }
          case 80: break;
          case 38: 
            { transposable = false;
                                   return ScilabLexerConstants.ELSEIF;
            }
          case 81: break;
          case 39: 
            { transposable = false;
                                   return ScilabLexerConstants.CKEYWORD;
            }
          case 82: break;
          case 40: 
            { return ScilabLexerConstants.AUTHORS;
            }
          case 83: break;
          case 41: 
            { transposable = false;
                                   return ScilabLexerConstants.FKEYWORD;
            }
          case 84: break;
          case 42: 
            { return ScilabLexerConstants.MAIL;
            }
          case 85: break;
          case 43: 
            { return ScilabLexerConstants.URL;
            }
          case 86: break;
          default:
            zzScanError(ZZ_NO_MATCH);
        }
      }
    }
  }


}
