//
// C++ Implementation: CShaderEdit
//
// Description: 
//
//
// Author: Harald Krippel <harald@the-develop.net>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include <QtGui>

#include "CQcakeDlg.hpp"
#include "CShaderEdit.hpp"
#include "messages.hpp"
#include "main.h"

CShaderEditDlg::CShaderEditDlg(QString strTitle, QWidget * parent, Qt::WFlags f)
: CQcakeDlg(parent, f)
{
   point = NULL;
   ui.setupUi(this);
    
   connect(ui.buttonBox, SIGNAL(accepted()), this, SLOT(slotEditData()));
   connect(ui.buttonBox, SIGNAL(rejected()), this, SLOT(slotGetData()));
   connect(ui.pushButton3, SIGNAL(released()), this, SLOT(slotEditorScriptv()));
   connect(ui.pushButton4, SIGNAL(released()), this, SLOT(slotEditorScriptf()));
   connect(ui.toolButton1, SIGNAL(released()), this, SLOT(slotGetScriptv()));
   connect(ui.toolButton1, SIGNAL(released()), this, SLOT(slotGetScriptf()));

   myParent = parent;
   setWindowTitle(strTitle);
}

CShaderEditDlg::~CShaderEditDlg() {
}

void CShaderEditDlg::slotGetData()
{
    if(point != NULL){
      slotGetData(point);
    }
}

void CShaderEditDlg::slotGetData(FolderListItem *i)
{
    point=i;
	
    ui.text->setText(i->text(0));
    ui.on->setChecked(i->GetValue("on",i).toInt());

    ui.vfile->setText(i->GetValue("vfile",i));
    ui.ffile->setText(i->GetValue("ffile",i));

    qWarning( "CShaderEditDlg::slotGetData(): Geht !" );
}

void CShaderEditDlg::slotEditData()
{
    if(point != NULL)
    {
        point->setText(0,ui.text->text());
        point->SetValue("on", ui.on->isChecked() ? "1" : "0");

//  implement later
    point->SetValue("vfile",ui.vfile->text());
    point->SetValue("ffile",ui.ffile->text());

        point->updategl();
    }
    qWarning( "CShaderEditDlg::slotEditData(): Geht !" );
}

void CShaderEditDlg::slotEditorScriptv()
{
    QString   arg = g_prjpath + point->GetValue("path",point ) + "/" + point->GetValue("vfile",point) ;
    slotEditorScript(arg);
    qWarning( "CShaderEditDlg::EditorScriptv(): Geht !" );
}

void CShaderEditDlg::slotEditorScriptf()
{
    QString   arg = g_prjpath + point->GetValue("path",point ) + "/" + point->GetValue("ffile",point) ;
    slotEditorScript(arg);
    qWarning( "CShaderEditDlg::EditorScriptf(): Geht !" );
}

void CShaderEditDlg::slotEditorScript(QString arg)
{
    QProcess*  proc = new QProcess( this );
    QStringList arguments;
    arguments << arg;
    qWarning( arg.toAscii() );   // error handling

    QString program = g_editor;
    proc->start(program, arguments);
    if ( !proc->waitForStarted()) {
      QString qmsg = "CShaderEditDlg::EditorScript(): cant start editor " + program;
      qWarning(qmsg.toAscii() );   // error handling
      ErrorMsg errormsg(qmsg);
    }
    qWarning( "CShaderEditDlg::EditorScript(): Geht !" );
}

void CShaderEditDlg::slotGetScriptv()
{
    qWarning( "CShaderEditDlg::slotGetScriptv(): Geht !" );
}

void CShaderEditDlg::slotGetScriptf()
{
    qWarning( "CShaderEditDlg::slotGetScriptf(): Geht !" );
}

