!****************************************************************************************
SUBROUTINE read_grid_model1(nlon,nlat, &
                            corners_ij_lus, &
                            data_filename, w_unit, &
                            irrlonlatregvrt_lon,irrlonlatregvrt_lat,&
                            irrlonlatregvrt_clo,irrlonlatregvrt_cla,&
                            indice_mask)
  !**************************************************************************************
  !
  USE netcdf
  IMPLICIT NONE
  !
  INTEGER                  :: i,j,k,w_unit
  INTEGER                  :: il_file_id,il_grid_id,il_lon_id, &
                              il_lat_id,il_z_id,il_clo_id,il_cla_id,il_clz_id,il_indice_id, &
                              lon_dims,lat_dims,z_dims,clo_dims,cla_dims,&
                              clz_dims,imask_dims
  !
  INTEGER, DIMENSION(NF90_MAX_VAR_DIMS) :: lon_dims_ids,lat_dims_ids,z_dims_ids,clo_dims_ids,&
                                           cla_dims_ids,clz_dims_ids,imask_dims_ids,lon_dims_len,&
                                           lat_dims_len,z_dims_len,clo_dims_len,cla_dims_len,&
                                           clz_dims_len,imask_dims_len  
  !               
  !
  INTEGER, INTENT(in)     :: nlon,nlat,corners_ij_lus
  CHARACTER(len=30)        :: data_filename
  !
  !
  INTEGER,  DIMENSION(2)   :: ila_z
  INTEGER,  DIMENSION(3)   :: ila_dim
  INTEGER,  DIMENSION(3)   :: ila_corners,ila_what
  !
  DOUBLE PRECISION, DIMENSION(nlon,nlat)                :: irrlonlatregvrt_lon,irrlonlatregvrt_lat
  DOUBLE PRECISION, DIMENSION(nlon,nlat,corners_ij_lus) :: irrlonlatregvrt_clo,irrlonlatregvrt_cla
  INTEGER, DIMENSION(nlon,nlat)                         :: indice_mask
  INTEGER, DIMENSION(nlon,nlat,1)                       :: mask_lu
  !
  !
  ! Dimensions
  !
  CALL hdlerr(NF90_OPEN(data_filename, NF90_NOWRITE, il_file_id), __LINE__ )
  !
  !
  CALL hdlerr( NF90_INQ_VARID(il_file_id, 'prism_gridtype', il_grid_id), __LINE__ )
  CALL hdlerr( NF90_INQ_VARID(il_file_id, 'lon' , il_lon_id), __LINE__ )
  CALL hdlerr( NF90_INQ_VARID(il_file_id, 'lat' , il_lat_id), __LINE__ )
!  CALL hdlerr( NF90_INQ_VARID(il_file_id, 'z' , il_z_id), __LINE__ )
  CALL hdlerr( NF90_INQ_VARID(il_file_id, 'clo' , il_clo_id), __LINE__ )
  CALL hdlerr( NF90_INQ_VARID(il_file_id, 'cla' , il_cla_id), __LINE__ )
!  CALL hdlerr( NF90_INQ_VARID(il_file_id, 'clz' , il_clz_id), __LINE__ )
  CALL hdlerr( NF90_INQ_VARID(il_file_id, 'imask' , il_indice_id), __LINE__ )
  !
  !
  ila_what(:)=1
  !
  ila_dim(1)=nlon
  ila_dim(2)=nlat
  ila_dim(3)=1
  !
  ila_corners(1)=nlon
  ila_corners(2)=nlat
  ila_corners(3)=corners_ij_lus
  !
  !
  ! Data
  !
  CALL hdlerr( NF90_OPEN(data_filename, NF90_NOWRITE, il_file_id), __LINE__ )
  !
  !
  CALL hdlerr( NF90_GET_VAR (il_file_id, il_lon_id, irrlonlatregvrt_lon, &
     ila_what(1:2), ila_dim(1:2)), __LINE__ )
  !
  WRITE(w_unit,*) 'We read globalgrid_lon'
  CALL flush(w_unit)
  !
  CALL hdlerr( NF90_GET_VAR (il_file_id, il_lat_id, irrlonlatregvrt_lat, &
     ila_what(1:2), ila_dim(1:2)), __LINE__ )
  !
  WRITE(w_unit,*) 'We read globalgrid_lat'
  CALL flush(w_unit)
  !
  !
  CALL hdlerr( NF90_GET_VAR(il_file_id, il_clo_id, irrlonlatregvrt_clo, &
     ila_what, ila_corners), __LINE__ )
  !
  WRITE(w_unit,*) 'We read globalgrid_clo'
  CALL flush(w_unit)
  !
  !
  CALL hdlerr( NF90_GET_VAR (il_file_id, il_cla_id, irrlonlatregvrt_cla, &
     ila_what, ila_corners), __LINE__ )
  !
  WRITE(w_unit,*) 'We read globalgrid_cla'
  CALL flush(w_unit)
  !
  !
  CALL hdlerr( NF90_GET_VAR (il_file_id, il_indice_id, mask_lu, &
     ila_what, ila_dim), __LINE__ )
  !
  WRITE(w_unit,*) 'We read globalgrid_indice_mask'
  CALL flush(w_unit)
  !
  CALL hdlerr( NF90_CLOSE(il_file_id), __LINE__ )
  !
  indice_mask(:,:) = mask_lu(:,:,1)
  !
END SUBROUTINE read_grid_model1
