/***************************************************************************
 *   Copyright (C) 2011-2012 by Tomasz Bojczuk                             *
 *   tomaszbojczuk@gmail.com                                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 3 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *  You should have received a copy of the GNU General Public License      *
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.  *
 ***************************************************************************/


#include "rangesettings.h"
#include "tglobals.h"
#include "tlevelpreview.h"
#include <QtGui>

extern Tglobals *gl;
extern bool isNotSaved;

rangeSettings::rangeSettings(QWidget *parent) :
    QWidget(parent)
{
    QVBoxLayout *mainLay = new QVBoxLayout;
    mainLay->addStretch(1);
    mainLay->setAlignment(Qt::AlignCenter);

    QHBoxLayout *allLay = new QHBoxLayout;

    QVBoxLayout *scoreLay = new QVBoxLayout;
    scoreRang = new TscoreWidgetSimple(2, this);
    scoreRang->setFixedSize(200, 220);;
//    scoreRang->setStatusTip(tr("If selected notes are either the lowest or the highest<br>possible sounds in the current guitar tune,<br>they are automatically adjusted to another tune."));
    scoreRang->setAmbitus(Tnote(gl->loString().getChromaticNrOfNote()),
               Tnote(gl->hiString().getChromaticNrOfNote()+gl->GfretsNumber));
    scoreRang->setNote(0, Tnote(1, 0));
    scoreRang->setNote(1, Tnote(1, 1));
    QGroupBox *notesRangGr = new QGroupBox(TlevelPreview::notesRangeTxt(), this);
    scoreLay->addWidget(scoreRang);
    notesRangGr->setLayout(scoreLay);

    allLay->addWidget(notesRangGr);

    QVBoxLayout *guitLay = new QVBoxLayout;
    QGroupBox *fretGr = new QGroupBox(TlevelPreview::fretsRangeTxt(), this);
//    fretGr->setStatusTip(tr("If selected fret is the highest, it is automatically<br>changed to the highest possible fret<br>for any frets number in a guitar."));
    QHBoxLayout *fretLay = new QHBoxLayout;
    QLabel *fromLab = new QLabel(tr("from"),this);
    fromSpinB = new QSpinBox(this);
    fromSpinB->setMaximum(gl->GfretsNumber);
    QLabel *toLab = new QLabel(tr("to"),this);
    toSpinB = new QSpinBox(this);
    toSpinB->setMaximum(gl->GfretsNumber);
    toSpinB->setValue(3);
    fretLay->addWidget(fromLab);
    fretLay->addWidget(fromSpinB);
    fretLay->addStretch(1);
    fretLay->addWidget(toLab);
    fretLay->addWidget(toSpinB);
    fretGr->setLayout(fretLay);
    guitLay->addWidget(fretGr);
    guitLay->addStretch(1);

    QGroupBox *stringsGr = new QGroupBox(tr("avaiable strings:"),this);
    stringsGr->setStatusTip(tr("uncheck strings if You want to skip them<br>in an exam."));
    QGridLayout *strLay = new QGridLayout;
    for (int i=0; i<6; i++) {
        stringBut[i] = new QCheckBox(QString("%1").arg(i+1),this);
        stringBut[i]->setFont(QFont("nootka", qRound(font().pointSize()*1.5), QFont::Normal));
        stringBut[i]->setChecked(true);
        connect(stringBut[i], SIGNAL(clicked()), this, SLOT(stringSelected()));
        connect(stringBut[i], SIGNAL(clicked()), this, SLOT(whenParamsChanged()));
        if (i<3)
            strLay->addWidget(stringBut[i],1,i+1,0);
        else
            strLay->addWidget(stringBut[i],2,i-2,0);
    }
    stringsGr->setLayout(strLay);
    guitLay->addWidget(stringsGr);
    guitLay->addStretch(1);

    allLay->addLayout(guitLay);

    mainLay->addLayout(allLay);
    mainLay->addStretch(1);

    setLayout(mainLay);

    connect (scoreRang, SIGNAL(noteHasChanged(int,Tnote)), this, SLOT(whenParamsChanged()));
    connect (fromSpinB, SIGNAL(valueChanged(int)), this, SLOT(whenParamsChanged()));
    connect (toSpinB, SIGNAL(valueChanged(int)), this, SLOT(whenParamsChanged()));
}

void rangeSettings::stringSelected() {
    if ( !stringBut[0]->isChecked() && !stringBut[1]->isChecked()
        && !stringBut[2]->isChecked() && !stringBut[3]->isChecked()
        && !stringBut[4]->isChecked() && !stringBut[5]->isChecked() ) {
        stringBut[0]->setChecked(true);
    }
}

void rangeSettings::loadLevel(TexamLevel level) {
    disconnect (fromSpinB, SIGNAL(valueChanged(int)), this, SLOT(whenParamsChanged()));
    disconnect (toSpinB, SIGNAL(valueChanged(int)), this, SLOT(whenParamsChanged()));
    scoreRang->setNote(0, level.loNote);
    scoreRang->setNote(1, level.hiNote);
    fromSpinB->setValue(level.loFret);
    toSpinB->setValue(level.hiFret);
    for (int i=0; i<6; i++)
        stringBut[i]->setChecked(level.usedStrings[i]);
    stringSelected();
    connect (fromSpinB, SIGNAL(valueChanged(int)), this, SLOT(whenParamsChanged()));
    connect (toSpinB, SIGNAL(valueChanged(int)), this, SLOT(whenParamsChanged()));
}

void rangeSettings::whenParamsChanged() {
    if (!isNotSaved) {
        isNotSaved = true;
        emit rangeChanged();
    }
    if (!stringBut[0]->isChecked() || !stringBut[1]->isChecked()
        || !stringBut[2]->isChecked() || !stringBut[3]->isChecked()
        || !stringBut[4]->isChecked() || !stringBut[5]->isChecked() )
      emit allStringsChecked(false);
    else
      emit allStringsChecked(true);
        /** It has two reasons:
         1. when questions list is created there is no conditions to check
            unavailable (unchecked) strings
         2. in level validation method is hard to determine dependecy unchecked
            strings between range of frets and notes. */
}

void rangeSettings::saveLevel(TexamLevel &level) {
    if (scoreRang->getNote(0).getChromaticNrOfNote() <=
        scoreRang->getNote(0).getChromaticNrOfNote()) {
            level.loNote = scoreRang->getNote(0);
            level.hiNote = scoreRang->getNote(1);
        }
    else {
        level.loNote = scoreRang->getNote(1);
        level.hiNote = scoreRang->getNote(0);
    }
    if (fromSpinB->value() <= toSpinB->value()) {
        level.loFret = fromSpinB->value();
        level.hiFret = toSpinB->value();
    }
    else {
        level.loFret = toSpinB->value();
        level.hiFret = fromSpinB->value();
    }

    for (int i=0; i<6; i++)
        level.usedStrings[i] = stringBut[i]->isChecked();

}
