program genoverlayusa

	implicit none

	include 'netcdf.inc'

	integer			:: nsubseg

	integer			:: ncid, err, dimid_segment, nsegs, varid_segment_directory, &
				   varid_verts, naspects, dimid_verts, npoints, i, iseg, iv0, iv1, &
				   n_points_in_seg
	character*1000		:: mapfile
	real, allocatable 	:: points(:)
	integer*4, allocatable 	:: dir(:,:)

	mapfile = '/home/pierce/lib/coastlines_and_geography/OUTLUSAM.nc'

	!--------------
	! Open map file
	!--------------
	err = nf_open(mapfile,0,ncid)
	if( err /= 0 ) then
		write(0,*) 'Error opening file ', trim(mapfile)
		call exit(-1)
	endif

	!--------------
	! Get file info
	!--------------
	err = nf_inq_dimid( ncid, 'segment', dimid_segment )
	if( err /= 0 ) then
		write(0,*) 'Error trying to find dim segment in file', trim(mapfile)
		call exit(-1)
	endif

	err = nf_inq_varid( ncid, 'segment_directory', varid_segment_directory )
	if( err /= 0 ) then
		write(0,*) 'Error trying to find var segment_directory in file', trim(mapfile)
		call exit(-1)
	endif

	err = nf_inq_dimid( ncid, 'verts', dimid_verts )
	if( err /= 0 ) then
		write(0,*) 'Error trying to find dim verts in file', trim(mapfile)
		call exit(-1)
	endif

	err = nf_inq_varid( ncid, 'verts', varid_verts )
	if( err /= 0 ) then
		write(0,*) 'Error trying to find var segment_directory in file', trim(mapfile)
		call exit(-1)
	endif

	err = nf_inq_dimlen( ncid, dimid_segment, nsegs  )
	err = nf_inq_dimlen( ncid, dimid_verts,   npoints )
	write(0,*) 'nsegs=', nsegs, ' npoints=', npoints

	naspects = 6

	!----------------------
	! Get segment directory
	!----------------------
	allocate(dir(naspects,nsegs))
	err = nf_get_var_int( ncid, varid_segment_directory, dir )
	if( err /= 0 ) then
		write(0,*) 'Error trying to read varid_segment_directory'
		call exit(-1)
	endif

	!----------
	! Get points
	!----------
	allocate(points(npoints))
	err = nf_get_var_real( ncid, varid_verts, points )
	if( err /= 0 ) then
		write(0,*) 'Error trying to read varid_verts'
		call exit(-1)
	endif

	!----------------------
	! Go segment by segment
	!----------------------
	write(6,100)
100	format('NCVIEW-OVERLAY 1.0')
	do iseg=1, nsegs
		iv0 = dir(5,iseg) + 1
		n_points_in_seg = dir(6,iseg)
		call drawseg( points, iv0, n_points_in_seg )
	enddo

!-------
contains
!-------
!===============================================================================================
! The terminology here is unfortunate, but imposed by the structure of OUTLUSAM.nc
! What that file calles 'vertices' are actually points, since there are as many
! so-called vertices as there are X,Y points, rather than 1 vertice for each (x,y) pair.
! Also, a 'segment' we are called with is a sequence of vertices.  We then dray
! LINE SEGMENTS between each pair of vertices.
!
subroutine drawseg( points, idx, npts ) 

	real	:: points(:), x0, y0, x1, y1
	integer	:: idx, npts, i, nlinesegs

	!do i=1, npts, 2
	!	print *, points(idx+i), points(idx+i-1)
	!	print *, points(idx+i)-360, points(idx+i-1)
	!enddo

	nlinesegs = (npts/2) - 1
	do i=1, nlinesegs
		x0 = points(idx+(i-1)*2+1)
		y0 = points(idx+(i-1)*2)
		x1 = points(idx+(i-1)*2+3)
		y1 = points(idx+(i-1)*2+2)
		call draw_line_segment( x0, y0, x1, y1 )
	enddo

end subroutine drawseg

!===============================================================================================
subroutine draw_line_segment( x0, y0, x1, y1 ) 

	real, intent(in)	:: x0, y0, x1, y1
	real			:: last_x1, last_y1, xmid, ymid, dx, dy, f, dist, ymid_rad
	integer			:: i, nsubseg
	save last_x1, last_y1

	if( (x0 /= last_x1) .or. (y0 /= last_y1)) then
		print *, x0, y0
		print *, x0-360, y0
	endif

	ymid = 0.5*(y0+y1)
	ymid_rad = ymid/180.*3.1415926536

	dx = x1 - x0
	dy = (y1 - y0)*cos(ymid_rad)

	dist = sqrt(dx*dx + dy*dy)
	nsubseg = nint( dist / .1 )

	f = 1./real(nsubseg+1)
	dx = (x1 - x0)*f
	dy = (y1 - y0)*f
	do i=1, nsubseg
		xmid = x0 + dx*i
		ymid = y0 + dy*i
		print *, xmid, ymid
		print *, xmid-360, ymid
	enddo

	print *, x1, y1
	print *, x1-360, y1

	last_x1 = x1
	last_y1 = y1

end subroutine draw_line_segment
!===============================================================================================
end program genoverlayusa
!===============================================================================================


