/*
 * Decompiled with CFR 0.152.
 */
package com.jcoverage.reporting;

import com.jcoverage.reporting.Column;
import com.jcoverage.reporting.Line;
import com.jcoverage.reporting.LineCategory;
import com.jcoverage.reporting.Page;
import com.jcoverage.reporting.Report;
import com.jcoverage.reporting.ReportingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public abstract class AbstractPage
implements Page {
    static Logger logger = Logger.getLogger((Class)(class$com$jcoverage$reporting$AbstractPage == null ? (class$com$jcoverage$reporting$AbstractPage = AbstractPage.class$("com.jcoverage.reporting.AbstractPage")) : class$com$jcoverage$reporting$AbstractPage));
    String label;
    Report report;
    List categories = new ArrayList();
    Line masterLine;
    Map lineSetsByCategory = new HashMap();
    int state = 0;
    static /* synthetic */ Class class$com$jcoverage$reporting$AbstractPage;

    protected AbstractPage(String label) {
        this.label = label;
    }

    Set getLineSetForCategory(LineCategory category) {
        if (this.state == 1) {
            throw new IllegalStateException("Report is closed, cannot add new lines.");
        }
        if (category == null) {
            throw new IllegalArgumentException("Category cannot be null");
        }
        if (!this.categories.contains(category)) {
            throw new IllegalArgumentException("This page (type " + this.getClass().getName() + ") cannot handle category: " + category);
        }
        HashSet set = (HashSet)this.lineSetsByCategory.get(category);
        if (set == null) {
            set = new HashSet();
            this.lineSetsByCategory.put(category, set);
        }
        return set;
    }

    public Line createLine(LineCategory category) {
        Set set = this.getLineSetForCategory(category);
        Line line = this.instantiateLineForCategory(category);
        if (line != null) {
            line.setCategory(category);
            line.setOwner(this);
            line.setReport(this.report);
            set.add(line);
        }
        return line;
    }

    public void addLineReference(Line line, LineCategory category) {
        this.getLineSetForCategory(category).add(line);
    }

    public Line lookupLineByField(LineCategory category, Column column, Object value) {
        Set lines = (Set)this.lineSetsByCategory.get(category);
        if (lines == null) {
            return null;
        }
        Iterator it = lines.iterator();
        while (it.hasNext()) {
            Line line = (Line)it.next();
            Object field = line.getField(column);
            if (field == null || !field.equals(value)) continue;
            return line;
        }
        return null;
    }

    public Set getLines(LineCategory category) {
        Set result = (Set)this.lineSetsByCategory.get(category);
        return result != null ? result : Collections.EMPTY_SET;
    }

    protected Line instantiateLineForCategory(LineCategory category) {
        return null;
    }

    public LineCategory[] getCategories() {
        return this.categories.toArray(new LineCategory[this.categories.size()]);
    }

    public void addCategory(LineCategory category) {
        this.categories.add(category);
    }

    public void setMasterLine(Line masterLine) {
        this.masterLine = masterLine;
    }

    public Line getMasterLine() {
        return this.masterLine;
    }

    public void setReport(Report report) {
        this.report = report;
    }

    public void close() throws ReportingException {
        if (this.state == 0) {
            this.state = 1;
            Iterator it = this.lineSetsByCategory.values().iterator();
            while (it.hasNext()) {
                this.close((Set)it.next());
            }
            if (this.report.getCollator() != null) {
                this.report.getCollator().pageClosed(this);
            }
        } else {
            if (this.state == 1) {
                throw new IllegalStateException("Aleady closed");
            }
            throw new IllegalStateException("Page in unknown state: " + this.state);
        }
    }

    public boolean isClosed() {
        return this.state == 1;
    }

    public String getLabel() {
        return this.label;
    }

    void close(Set set) throws ReportingException {
        Iterator it = set.iterator();
        while (it.hasNext()) {
            Line line = (Line)it.next();
            if (line.isClosed()) continue;
            try {
                line.close();
            }
            catch (ReportingException ex) {
                throw new ReportingException("Failed to close line " + line, ex);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

