#include <cmath>
#include "touchpad.h"
#include "logger.h"

using namespace std;

Touchpad::Touchpad(AppletWindowParams params,
		   const string& pointer_img,
		   double ratio)
		:Applet(params), pointer(16, 24, params.disp), move_ratio(ratio), pressed_button(-1){
    pointer.Create();
    pointer.Move(0, 0);
    pointer.AddImage(0, 0, pointer_img, NULL, NULL, MyWindow::TOP_LEFT, 240, 240, 240);
    pointer.SetTransparent(true);
    pointer.Refresh();
    pointer.UnmapInput();
}
AppAction Touchpad::OnMousePress(int x, int y){
    lastx = x;
    lasty = y;
    last_px = pointer.PosX();
    last_py = pointer.PosY();
    for (int i=0; i<buttons.size(); ++i)
	if (x>=buttons[i].px && y>=buttons[i].py && x<buttons[i].px + buttons[i].w && y<buttons[i].py + buttons[i].h){
	    pressed_button = i;
	    Vibrate();
	    return "";
	}
    return "";
}

double fun(double x){
    return x*sqrt(fabs(x));
}

int cap(int x, int a, int b){
    return max(min(x,b), a);
}

AppAction Touchpad::OnMouseMove(int x, int y){
    if (pressed_button > -1)
	return "";
    pointer.Move(cap(last_px - fun(lastx - x)*move_ratio, 0, win.GetDisplay().Width()), cap(last_py - fun(lasty - y)*move_ratio, 0, win.GetDisplay().Height()));
    pointer.Refresh();
    return "";
}
AppAction Touchpad::OnMouseRelease(int x, int y){
    if (pressed_button > -1){
	int but = pressed_button;
	pressed_button = -1;
	if (y > lasty + 50){
	    Hide();
	    return "slider_show";
	} else {
	    LOG(INFO) << "keypress " << pointer.PosX() << " " << pointer.PosY() << " " << buttons[but].num_but;
	    win.UnmapInput();
	    win.GetDisplay().GenMouseClickEvent(pointer.PosX()-1, pointer.PosY()-1, buttons[but].num_but);
	    win.MapInput();
	    return "";
	}
    }
    return "";
}
void Touchpad::OnRotate(Rotation r){
    win.Clear();
    DrawButtons();
    win.Refresh();
    SetTransparent(IsTransparent());
}
void Touchpad::OnShow(){
    pointer.Move(win.GetDisplay().Width()/2, win.GetDisplay().Height()/2);
    pointer.Refresh();
}
void Touchpad::OnHide(){
    pointer.Move(0, win.GetDisplay().Height());
    pointer.Refresh();
}

void Touchpad::DrawButtons(){
    buttons.clear();
    buttons.push_back(Button(0, 0, GetCurrentWidth()/4, GetCurrentHeight()/2, 1, "L"));
    buttons.push_back(Button(0, GetCurrentHeight()/2, GetCurrentWidth()/4, GetCurrentHeight()/2, 3, "R"));
    buttons.push_back(Button(GetCurrentWidth()/16*13, 0, GetCurrentWidth()/8, GetCurrentHeight()/3, 4, "key_up.png"));
    buttons.push_back(Button(GetCurrentWidth()/16*13, GetCurrentHeight()/3*2, GetCurrentWidth()/8, GetCurrentHeight()/3, 5, "key_down.png"));
    buttons.push_back(Button(GetCurrentWidth()/4*3, GetCurrentHeight()/3, GetCurrentWidth()/8, GetCurrentHeight()/3, 6, "key_left.png"));
    buttons.push_back(Button(GetCurrentWidth()/8*7, GetCurrentHeight()/3, GetCurrentWidth()/8, GetCurrentHeight()/3, 7, "key_right.png"));

    win.SetFontSize(60);
    for (int i=0; i<buttons.size(); ++i){
	string look = buttons[i].look;
	if (look.size() > 4 && look.substr(look.size()-4) == ".png")
	    win.AddImage(buttons[i].px + buttons[i].w/2, buttons[i].py + buttons[i].h/2, look, NULL, NULL, MyWindow::CENTER, 240, 240, 240);
	else
	    win.AddText(buttons[i].px + buttons[i].w/2, buttons[i].py + buttons[i].h/2, look, MyWindow::CENTER, 240, 240, 240);
    }
}

