/*=========================================================================
 *
 *  Copyright Insight Software Consortium
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0.txt
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 *=========================================================================*/
#ifndef __itkRegionGrowImageFilter_hxx
#define __itkRegionGrowImageFilter_hxx

#include "itkRegionGrowImageFilter.h"

namespace itk
{
template< typename TInputImage, typename TOutputImage >
RegionGrowImageFilter< TInputImage, TOutputImage >
::RegionGrowImageFilter()
{
  m_GridSize.Fill(2);
  m_MaximumNumberOfRegions = 0;
}

template< typename TInputImage, typename TOutputImage >
RegionGrowImageFilter< TInputImage, TOutputImage >
::~RegionGrowImageFilter()
{}

/**
 * PrintSelf
 */
template< typename TInputImage, typename TOutputImage >
void
RegionGrowImageFilter< TInputImage, TOutputImage >
::PrintSelf(std::ostream & os, Indent indent) const
{
  Superclass::PrintSelf(os, indent);
  os << indent << "Region grow image filter object" << std::endl;
  os << indent << "Maximum number of regions: " << m_MaximumNumberOfRegions << std::endl;
  os << indent << "Maximum grid size : " << m_GridSize << std::endl;
} // end PrintSelf
} // namespace itk

#endif
