#!/usr/bin/env python
# GPixPod - organize photos on your iPod, freely!
# Copyright (C) 2006 Flavio Gargiulo (FLAGAR.com)
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

from distutils.core import setup, Extension
import os

i, o = os.popen4('pkg-config --cflags gtk+-2.0')
includes = [x[2:] for x in o.read().split()]
i.close()
o.close()
i, o = os.popen4('pkg-config --libs-only-L gtk+-2.0')
libdirs = [x[2:] for x in o.read().split()]
i.close()
o.close()
i, o = os.popen4('pkg-config --libs-only-l gtk+-2.0')
libs = [x[2:] for x in o.read().split()]
i.close()
o.close()

imgconvert = Extension('imgconvert',
                       include_dirs = includes,
                       libraries = libs,
                       library_dirs = libdirs,
                       sources = [os.path.join('imgconvert', 'imgconvert.c'), os.path.join('imgconvert', 'imgconvertmodule.c')])

setup(name="gpixpod",
      version="0.6.2",
      description="GPixPod - organize photos on your iPod, freely!",
      author="Flavio Gargiulo",
      author_email="flagar@gmail.com",
      url="http://www.gpixpod.org",
      py_modules=['mh', 'gpixpod', 'gpixpod_cli', 'utils', 'ipodhal'],
      scripts = ['gpixpod'],
      ext_modules = [imgconvert],
      data_files = [('lib/gpixpod', ['gpixpod.glade']),
                    ('lib/gpixpod/po/it/LC_MESSAGES', ['po/it/LC_MESSAGES/gpixpod.mo']),
                    ('lib/gpixpod/po/es/LC_MESSAGES', ['po/es/LC_MESSAGES/gpixpod.mo']),
                    ('share/applications', ['GPixPod.desktop']),
                    ('share/man/man1', ['gpixpod.1.gz']),
                    ('share/doc/gpixpod', ['README', 'CHANGELOG', 'TODO', 'KNOWNBUGS']),
                    ('share/gpixpod', ['GPixPod.png', 'GPixPod_icon.png', 'ipod.png', 'photoalbum.png'])]
     )
