.\"
.\" GLE Tubing & Extrusions Library Documentation 
.\"
.TH gleSetJoinStyle 3GLE "3.0" "GLE" "GLE"
.SH NAME
gleSetJoinStyle, gleGetJoinStyle - Query and Set the GLE join style flags.
.SH SYNTAX
.nf
.LP
void gleSetJoinStyle (int style);
int gleGetJoinStyle (void);
.fi
.SH ARGUMENTS
.IP \fIstyle\fP 1i
bitwise OR of flags
.SH DESCRIPTION

Query and set the GLE join style flags. This word is a bitwise OR of
the flags described below.

The initial join style is TUBE_JN_ANGLE | TUBE_JN_CAP | TUBE_NORM_FACET. 

.B "Extrusion Join Styles"
.IP \fBTUBE_JN_RAW\fP
Draw polycylinders, polycones, extrusions, etc. with no special
treatment of the extrusion ends.
.IP \fBTUBE_JN_ANGLE\fP
Draw polycylinders, polycones, extrusions, etc. by extending the
different segments until they butt into each other with an
angular style.
.IP \fBTUBE_JN_CUT\fP
Draw polycylinders, polycones, extrusions, etc. by joining together the
different segments and slicing off the joint at half the angle between
the segments. A cap is drawn. Note that the slicing plane runs through
the origin of the contour coordinate system. Thus, the amount of slice
can be varied by offsetting the contour with respect to the origin.

Note that when two segments meet at a shallow angle, the cut join style
will potentially shave off a whole lot of the contour, leading to
"surprising" results...
.IP \fBTUBE_JN_ROUND\fP
Joints will be rounded. Strictly speaking, the part of the joint above
the origin will be rounded. The part below the origin will come
together in an angular join.
.IP \fBTUBE_JN_MASK\fP
Mask bits. This can be used to mask off the bit field that defines the
join style.

.B "End Caps"
.IP \fBTUBE_JN_CAP\fP
If this is set, a cap will be drawn at each end of the extrusion. 

.B "Automatic Normal Vector Generation"
.IP \fBTUBE_NORM_FACET\fP
A normal vector is generated per facet. Useful for having an extrusion
have a "faceted" look, such as when extruding a square -- each of the
four sides of the square will look flat.
.IP \fBTUBE_NORM_EDGE\fP
Normal vectors are generated so that they lie along edges. Useful for
making angular things look rounded under lighting. For example, when
extruding a hexagon and using this flag, the hexagonal extrusion will
look (more like a) smooth perfectly round cylinder, rather than a
six-sided shape.
.IP \fBTUBE_NORM_PATH_EDGE\fP
Normal vectors are generated so that they both lie on edges, and so
that they interpolate between neighboring segments. Useful for drawing
"spaghetti" -- extrusions that follow a spline path.  Because the
spline path must be "tessellated" into small straight segments, each
segment will look straight unless this flag is set.
.IP \fBTUBE_NORM_MASK\fP
A mask useful for masking out the "norm" bits. 

.B "Closed or Open Contours"
.IP \fBTUBE_CONTOUR_CLOSED\fP
If this bit is set, the contour will be treated as a "closed" contour,
where the last point connects back up to the first. It is useful to set
this flag when drawing closed shapes (such as extruded cylinders,
star-shapes, I-Beams, etc. When drawing open extrusions (e.g.
corrugated sheet metal), you DON'T want to set this flag.

.SH BUGS

Multiple threads using GLE share a single global join style
(although this should be easily fixable because GLE does use
a centralized graphics context).  

.SH SEE ALSO
gleExtrusion, gleTextureMode
.SH AUTHOR
Linas Vepstas (linas@linas.org)
