/*
 * Decompiled with CFR 0.152.
 */
package visad.python;

import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import javax.swing.JCheckBoxMenuItem;
import visad.VisADException;
import visad.python.JPythonEditor;
import visad.util.CodeFrame;
import visad.util.Util;

public class JPythonFrame
extends CodeFrame {
    protected boolean canRunSeparate = true;
    protected JCheckBoxMenuItem separateProcess;

    public JPythonFrame() throws VisADException {
        this((String)null);
    }

    public JPythonFrame(String filename) throws VisADException {
        this(new JPythonEditor(filename));
    }

    public JPythonFrame(JPythonEditor editor) throws VisADException {
        super(editor);
        ((JPythonEditor)this.textPane).setRunItem(this.getMenuItem("Command", "Run"));
        try {
            JPythonEditor.runCommand("java visad.python.RunJPython");
        }
        catch (IOException exc) {
            this.canRunSeparate = false;
        }
        catch (VisADException exc) {
            this.canRunSeparate = false;
        }
        ((JPythonEditor)this.textPane).setRunSeparateProcess(false);
        this.getMenuItem("Command", "Compile").setEnabled(false);
        this.addMenuSeparator("Command");
        this.separateProcess = new JCheckBoxMenuItem("Launch JPython in a separate process", false);
        this.addMenuItem("Command", this.separateProcess, "commandSeparate", 'l', this.canRunSeparate);
    }

    public void commandSeparate() {
        boolean separate = this.separateProcess.getState();
        ((JPythonEditor)this.textPane).setRunSeparateProcess(separate);
    }

    public void setWarnBeforeSave(boolean warn) {
        ((JPythonEditor)this.textPane).setWarnBeforeSave(warn);
    }

    public static void main(String[] args) {
        boolean warn = true;
        if (args.length > 0 && "-nowarn".equalsIgnoreCase(args[0])) {
            warn = false;
        }
        try {
            final JPythonFrame frame = new JPythonFrame();
            frame.setWarnBeforeSave(warn);
            frame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent e) {
                    frame.fileExit();
                }
            });
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            int w = screenSize.width > 550 ? 500 : screenSize.width - 50;
            int h = screenSize.height > 850 ? 800 : screenSize.height - 50;
            frame.setSize(w, h);
            Util.centerWindow(frame);
            frame.setVisible(true);
        }
        catch (VisADException exc) {
            exc.printStackTrace();
        }
    }
}

