#    debsigs: Package signing/verification system 
#    SPDX-FileCopyrightText: 2000   Progeny Linux Systems, Inc. <jgoerzen@progeny.com>
#    SPDX-FileCopyrightText: 2009   Peter Pentchev <roam@ringlet.net>
#    SPDX-License-Identifier: GPL-2.0-or-later

package Debian::debsigs::gpg;

use strict;
use warnings;

use Debian::debsigs::forktools ':all';

our $VERSION = '1.06';

sub getkeyfromfd {
  my $forkfd = shift @_;

  my ($gpgfd, $gpgpid) = forkreader($forkfd, "gpg", "--list-packets");
  
  my ($keyid, $date);

  my $line = <$gpgfd>;
  if ($line =~ /^#/) {
    $line = <$gpgfd>;
  };
  # print STDERR "gpg: got first line: $line";
  die 'bad gpg line' unless ($line =~ '^:signature packet:');
  ($keyid) = $line =~ /^:signature packet: .+ keyid ([0-9a-fA-F]+)/;
  die 'invalid gpg line' unless($keyid);
  while (defined($line = <$gpgfd>)) {
    # print STDERR "gpg: got line: $line";
    unless ($date) {
      ($date) = $line =~ /^\s+.*created ([0-9]+)/;
    }
  }
  
  assertsuccess($gpgpid, 'gpg --list-packets');
  # print STDERR "gpg: returning ($keyid, $date)\n";
  return ($keyid, $date);
}

sub getkeynamefromid {
  my $keyid = shift @_;

  my ($gpgfd, $gpgpid) = forkreader(undef, "gpg", "--list-keys", $keyid);
  
  my $line = <$gpgfd>;
  chomp $line;
  
  my ($name) = $line =~ m'pub\s+.+/[0-9A-Fa-f]+ \d\d\d\d-\d\d-\d\d (.+)$';
  return $name;
}

1;
