/*
 * Author: Andrei Zavada <johnhommer@gmail.com>
 *
 * License: GPL-2+
 *
 * Initial version: 2008-11-18
 *
 */

#include <cmath>
#include <cfloat>
#include <cstdio>

#include "config.h"

#include "pointaligned-s.hh"

using namespace std;

inline namespace {
int
n_frac_digits( double v)
{
	int d = 0;
	double dummy;
	while ( fabs( modf( v, &dummy)) > 1e-6 ) {
		v *= 10.; ++d;
	}
	return d;
}
} // inline namespace

const char*
Stilton::
double_dot_aligned_s( double val, int int_width, int frac_width)
{
	static char buf[40];

	if ( int_width + frac_width > 39 )
		int_width = 8, frac_width = 8;

	val = round(val * pow(10.,frac_width)) / pow(10.,frac_width);

	double	intval;
	double 	fracval = modf( val, &intval);
	int	frac_digits = n_frac_digits( val);
	int	frac_pad = frac_width - frac_digits;
	if ( frac_pad < 1 )
		frac_pad = 1;

	if ( frac_digits )
		if ( (int)intval )
			snprintf( buf, 40, "% *d.%0*ld%*s",
				  int_width, int(intval),
				  frac_digits, (long)round(pow(10., frac_digits) * fabs( fracval)),
				  frac_pad, " ");
		else
			snprintf( buf, 40, "%*s.%0*ld%*s",
				  int_width, " ",
				  frac_digits, (long)round(pow(10., frac_digits) * fabs( fracval)),
				  frac_pad, " ");

	else
		if ( (int)intval )
			snprintf( buf, 40, "%*d.%-*s",
				  int_width, int(intval), frac_width, " ");
		else
//			snprintf( buf, 40, "% *d.%-*d",
			snprintf( buf, 40, "%-*s0%-*s",
				  int_width, " ", frac_width, " ");

	return buf;

}


// eof
