{ -*- buffer-read-only: t -*-

  Copyright 2015-2018 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in nodes_specification/components/ ,
  - and regenerate include files by running
    nodes_specification/x3d-nodes-to-pascal/x3d-nodes-to-pascal.lpr .

  The documentation for properties should go to x3dnodes_documentation.txt . }

{$ifdef read_interface}

  strict private
    function GetEnabled: boolean;
    procedure SetEnabled(const Value: boolean);
    function GetRotation: TVector4;
    procedure SetRotation(const Value: TVector4);
    function GetTranslation: TVector3;
    procedure SetTranslation(const Value: TVector3);
    function GetBboxCenter: TVector3;
    procedure SetBboxCenter(const Value: TVector3);
    function GetBboxSize: TVector3;
    procedure SetBboxSize(const Value: TVector3);
  public
    property Enabled: boolean read GetEnabled write SetEnabled;
    property Rotation: TVector4 read GetRotation write SetRotation;
    property Translation: TVector3 read GetTranslation write SetTranslation;
    property BboxCenter: TVector3 read GetBboxCenter write SetBboxCenter;
    property BboxSize: TVector3 read GetBboxSize write SetBboxSize;

{$endif read_interface}

{$ifdef read_implementation}

{ TAbstractNBodyCollidableNode ----------------------------------------------- }

function TAbstractNBodyCollidableNode.GetEnabled: boolean;
begin
  Result := FdEnabled.Value;
end;

procedure TAbstractNBodyCollidableNode.SetEnabled(const Value: boolean);
begin
  FdEnabled.Send(Value);
end;

function TAbstractNBodyCollidableNode.GetRotation: TVector4;
begin
  Result := FdRotation.Value;
end;

procedure TAbstractNBodyCollidableNode.SetRotation(const Value: TVector4);
begin
  FdRotation.Send(Value);
end;

function TAbstractNBodyCollidableNode.GetTranslation: TVector3;
begin
  Result := FdTranslation.Value;
end;

procedure TAbstractNBodyCollidableNode.SetTranslation(const Value: TVector3);
begin
  FdTranslation.Send(Value);
end;

function TAbstractNBodyCollidableNode.GetBboxCenter: TVector3;
begin
  Result := FdBboxCenter.Value;
end;

procedure TAbstractNBodyCollidableNode.SetBboxCenter(const Value: TVector3);
begin
  FdBboxCenter.Send(Value);
end;

function TAbstractNBodyCollidableNode.GetBboxSize: TVector3;
begin
  Result := FdBboxSize.Value;
end;

procedure TAbstractNBodyCollidableNode.SetBboxSize(const Value: TVector3);
begin
  FdBboxSize.Send(Value);
end;

{$endif read_implementation}
