//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/Model/Axis/AmplitudeAxisItem.h
//! @brief     Defines various axis items
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_GUI_MODEL_AXIS_AMPLITUDEAXISITEM_H
#define BORNAGAIN_GUI_MODEL_AXIS_AMPLITUDEAXISITEM_H

#include "GUI/Model/Axis/BasicAxisItem.h"

class AmplitudeAxisItem : public BasicAxisItem {
    Q_OBJECT

public:
    explicit AmplitudeAxisItem(QObject* parent = nullptr);

    void writeTo(QXmlStreamWriter* w) const override;
    void readFrom(QXmlStreamReader* r) override;

    bool isLogScale() const;
    void setLogScale(bool value);

    bool isLocked() const;
    void setLocked(bool locked);

signals:
    void logScaleChanged(bool isLog);

private:
    bool m_lockMinMax;
    bool m_logScale;
};

#endif // BORNAGAIN_GUI_MODEL_AXIS_AMPLITUDEAXISITEM_H
