# avoid running mpi with serial (1 process) jobs
# by checking whether mpi is actually being used over multiple processes
# Probe number of processes with OMPI_COMM_WORLD_SIZE (openmpi) and MPI_LOCALNRANKS (mpich)

from os import getenv as os_getenv
from sys import modules as sys_modules
from importlib import import_module

_OPENMPI_MULTIPROC = os_getenv('OMPI_COMM_WORLD_SIZE') is not None
_MPICH_MULTIPROC = os_getenv('MPI_LOCALNRANKS') is not None
_MPI_USE_ALWAYS = os_getenv('ADIOS2_ALWAYS_USE_MPI') is not None

_MPI_ACTIVE = _OPENMPI_MULTIPROC or _MPICH_MULTIPROC or _MPI_USE_ALWAYS

if _MPI_ACTIVE:
    try:
        from . import adios2_mpi as _adios2
    except:
        from . import adios2_serial as _adios2
else:
    from . import adios2_serial as _adios2

__version__ = _adios2.__version__

# make generic adios2 module behaviour the same as specific builds
# by importing public and weak internal symbols (single _underscore)
api = [ k for k in _adios2.__dict__.keys() if not k.startswith('__') and not k.endswith('__') ]
this_module=sys_modules[__name__]
for key in api:
    # "imports" symbols (makes them accessible)
    setattr(this_module,key,getattr(_adios2,key))
    # rename symbols as properties of toplevel adios2 module
    sys_modules['adios2.{}'.format(key)] = getattr(_adios2,key)
del api
del this_module

del os_getenv, sys_modules, import_module
