#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2020 Antoine Le Gonidec <vv221@dotslashplay.it>
# SPDX-FileCopyrightText: © 2020 macaron
set -o errexit

###
# Monkey Island 4
# send your bug reports to vv221@dotslashplay.it
###

script_version=20251103.3

PLAYIT_COMPATIBILITY_LEVEL='2.33'

GAME_ID='monkey-island-4'
GAME_NAME='Monkey Island 4: Escape from Monkey Island'

## Monkey Island 4 (game installer)

ARCHIVE_BASE_EN_0_NAME='setup_escape_from_monkey_islandtm_1.1_(20987).exe'
ARCHIVE_BASE_EN_0_MD5='54978965b60294d5c1639b71c0a8159a'
ARCHIVE_BASE_EN_0_TYPE='innosetup'
ARCHIVE_BASE_EN_0_PART1_NAME='setup_escape_from_monkey_islandtm_1.1_(20987)-1.bin'
ARCHIVE_BASE_EN_0_PART1_MD5='21bc4e362f73b76e6808649167ee9d20'
ARCHIVE_BASE_EN_0_SIZE='1300000'
ARCHIVE_BASE_EN_0_VERSION='1.1-gog20987'
ARCHIVE_BASE_EN_0_URL='https://www.gog.com/game/escape_from_monkey_island'

ARCHIVE_BASE_FR_0_NAME='setup_escape_from_monkey_islandtm_1.1_(french)_(20987).exe'
ARCHIVE_BASE_FR_0_MD5='5ca039d42d53ad7fe206b289abe15deb'
ARCHIVE_BASE_FR_0_TYPE='innosetup'
ARCHIVE_BASE_FR_0_PART1_NAME='setup_escape_from_monkey_islandtm_1.1_(french)_(20987)-1.bin'
ARCHIVE_BASE_FR_0_PART1_MD5='c5bf233f09cca2a8e33d78d25cf58329'
ARCHIVE_BASE_FR_0_SIZE='1300000'
ARCHIVE_BASE_FR_0_VERSION='1.1-gog20987'
ARCHIVE_BASE_FR_0_URL='https://www.gog.com/game/escape_from_monkey_island'

## ScummVM patches

ARCHIVE_REQUIRED_PATCH_EN_NAME='MonkeyUpdate.exe'
ARCHIVE_REQUIRED_PATCH_EN_MD5='7c7dbd2349d49e382a2dea40bed448e0'
ARCHIVE_REQUIRED_PATCH_EN_URL='https://downloads.scummvm.org/frs/extras/patches/'

ARCHIVE_REQUIRED_PATCH_FR_NAME='MonkeyUpdate_FRA.exe'
ARCHIVE_REQUIRED_PATCH_FR_MD5='cc5ff3bb8f78a0eb4b8e0feb9cdd2e87'
ARCHIVE_REQUIRED_PATCH_FR_URL='https://downloads.scummvm.org/frs/extras/patches/'

CONTENT_PATH_DEFAULT='.'
## monkey4.exe requirements
CONTENT_LIBS_BIN_WINE_FILES='
mss32.dll
binkw32.dll'
CONTENT_GAME_BIN_WINE_FILES='
mp3dec.asi
monkey.exe
monkey4.exe
syscheck.exe
chorus.flt
reverb3.flt
sdelay.flt'
CONTENT_GAME0_BIN_WINE_PATH='__support/save'
CONTENT_GAME0_BIN_WINE_FILES='
saves'
CONTENT_GAME_L10N_FILES='
movies
art???.m4b
i9n.m4b
lip.m4b
voice???.m4b'
CONTENT_GAME_DATA_FILES='
textures
local.m4b
patch.m4b
sfx.m4b'
CONTENT_DOC_L10N_FILES='
*.pdf
*.txt'

USER_PERSISTENT_DIRECTORIES='
saves'

## Silence a ShellCheck false positive
## SC1003 (info): Want to escape a single quote? echo 'This is how it'\''s done'.
# shellcheck disable=SC1003
WINE_REGISTRY_INIT='
[HKEY_LOCAL_MACHINE\Software\LucasArts Entertainment Company LLC\Monkey4\Retail]

"Install path"="C:\\'"${GAME_ID}"'"'
WINE_VIRTUAL_DESKTOP='auto'

APP_SCUMMVM_SCUMMID='grim:monkey4'
APP_SCUMMVM_ICON='monkey4.exe'

APP_WINE_EXE='monkey4.exe'

PACKAGES_LIST='
PKG_BIN_SCUMMVM
PKG_BIN_WINE
PKG_L10N
PKG_DATA'

PKG_BIN_BASE_ID="$GAME_ID"

PKG_BIN_SCUMMVM_BASE_ID="${PKG_BIN_BASE_ID}-scummvm"
PKG_BIN_SCUMMVM_ID_EN="${PKG_BIN_SCUMMVM_BASE_ID}-en"
PKG_BIN_SCUMMVM_ID_FR="${PKG_BIN_SCUMMVM_BASE_ID}-fr"
PKG_BIN_SCUMMVM_PROVIDES="
$PKG_BIN_BASE_ID"
PKG_BIN_SCUMMVM_DESCRIPTION_EN='English version'
PKG_BIN_SCUMMVM_DESCRIPTION_FR='French version'
PKG_BIN_SCUMMVM_DEPENDENCIES_SIBLINGS='
PKG_L10N
PKG_DATA'

PKG_BIN_WINE_ARCH='32'
PKG_BIN_WINE_BASE_ID="${PKG_BIN_BASE_ID}-wine"
PKG_BIN_WINE_ID_EN="${PKG_BIN_WINE_BASE_ID}-en"
PKG_BIN_WINE_ID_FR="${PKG_BIN_WINE_BASE_ID}-fr"
PKG_BIN_WINE_PROVIDES="
$PKG_BIN_BASE_ID"
PKG_BIN_WINE_DESCRIPTION_EN='English version'
PKG_BIN_WINE_DESCRIPTION_FR='French version'
PKG_BIN_WINE_DEPENDENCIES_SIBLINGS='
PKG_L10N
PKG_DATA'

PKG_L10N_BASE_ID="${GAME_ID}-l10n"
PKG_L10N_ID_EN="${PKG_L10N_BASE_ID}-en"
PKG_L10N_ID_FR="${PKG_L10N_BASE_ID}-fr"
PKG_L10N_PROVIDES="
$PKG_L10N_BASE_ID"
PKG_L10N_DESCRIPTION_EN='English localisation'
PKG_L10N_DESCRIPTION_FR='French localisation'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

# Load common functions.

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run default initialisation actions.

initialization_default "$@"

# Check for the presence of the ScummVM patch.

case "$(current_archive)" in
	('ARCHIVE_BASE_EN_'*)
		archive_initialize_required \
			'ARCHIVE_PATCH' \
			'ARCHIVE_REQUIRED_PATCH_EN'
	;;
	('ARCHIVE_BASE_FR_'*)
		archive_initialize_required \
			'ARCHIVE_PATCH' \
			'ARCHIVE_REQUIRED_PATCH_FR'
	;;
esac

# Extract game data.

archive_extraction_default

# Include game data.

content_inclusion_icons 'PKG_DATA'
content_inclusion_default
## ScummVM - Include required patch.
install -D --mode=644 \
	"$(archive_path 'ARCHIVE_PATCH')" \
	"$(package_path 'PKG_BIN_SCUMMVM')$(path_game_data)/$(archive_name 'ARCHIVE_PATCH')"

# Write launchers.

## WINE - Install shipped libraries.
wineprefix_init_custom() {
	cat <<- EOF
	# Install shipped libraries.
	PATH_LIBRARIES_SYSTEM='$(path_libraries)'
	EOF
	cat <<- 'EOF'
	find "$PATH_LIBRARIES_SYSTEM" -iname '*.dll' | while read -r dll_source; do
		dll_destination="${PATH_PREFIX}${dll_source#"${PATH_LIBRARIES_SYSTEM}"}"
	    mkdir --parents "$(dirname "$dll_destination")"
	    ln --symbolic "$dll_source" "$dll_destination"
	done
	EOF
}

launchers_generation 'PKG_BIN_SCUMMVM' 'APP_SCUMMVM'
launchers_generation 'PKG_BIN_WINE' 'APP_WINE'

# Build packages.

packages_generation
printf '\n'
printf 'ScummVM:'
print_instructions 'PKG_DATA' 'PKG_L10N' 'PKG_BIN_SCUMMVM'
printf 'WINE:'
print_instructions 'PKG_DATA' 'PKG_L10N' 'PKG_BIN_WINE'

# Clean up.

working_directory_cleanup

exit 0
