/*###############################################################################
# Linux Management Providers (LMP), EthernetPort provider package
# Copyright (C) 2008 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr, guillaumebottex@gmail.com>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by <Author(s)>, <Affiliation>, <Year>
###############################################################################*/

#ifndef OPENDRIM_LANENDPOINTACCESS_H_
#define OPENDRIM_LANENDPOINTACCESS_H_

#include "EthernetPort_Common.h"

#include "OpenDRIM_LANEndpoint.h"

int EthernetPort_OpenDRIM_LANEndpoint_load(const CMPIBroker* broker, string& errorMessage);

int EthernetPort_OpenDRIM_LANEndpoint_unload(string& errorMessage);

int EthernetPort_OpenDRIM_LANEndpoint_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_LANEndpoint>& instances, const char** properties, string& errorMessage, const string& discriminant);

int EthernetPort_OpenDRIM_LANEndpoint_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_LANEndpoint& instance, const char** properties, string& errorMessage);

int EthernetPort_OpenDRIM_LANEndpoint_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_LANEndpoint& newInstance, const OpenDRIM_LANEndpoint& oldInstance, const char** properties, string& errorMessage);

int EthernetPort_OpenDRIM_LANEndpoint_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_LANEndpoint& instance, string& errorMessage);

int EthernetPort_OpenDRIM_LANEndpoint_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_LANEndpoint& instance, string& errorMessage);

int EthernetPort_OpenDRIM_LANEndpoint_RequestStateChange(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_LANEndpoint& instance, unsigned int& returnValue, const OpenDRIM_LANEndpoint_RequestStateChange_In& in, OpenDRIM_LANEndpoint_RequestStateChange_Out& out, string& errorMessage);

int EthernetPort_OpenDRIM_LANEndpoint_BroadcastReset(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_LANEndpoint& instance, unsigned int& returnValue, string& errorMessage);

int EthernetPort_OpenDRIM_LANEndpoint_populate(OpenDRIM_LANEndpoint& instance, string& errorMessage);

#endif /*OPENDRIM_LANENDPOINTACCESS_H_*/
