/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.utils.commandline;

import org.broadinstitute.gatk.utils.commandline.ArgumentMatchSourceType;

public class ArgumentMatchSource
implements Comparable<ArgumentMatchSource> {
    public static final ArgumentMatchSource COMMAND_LINE = new ArgumentMatchSource(ArgumentMatchSourceType.CommandLine, null);
    private final ArgumentMatchSourceType type;
    private final String description;

    public ArgumentMatchSource(String description) {
        this(ArgumentMatchSourceType.Provider, description);
    }

    private ArgumentMatchSource(ArgumentMatchSourceType type, String description) {
        if (type == ArgumentMatchSourceType.Provider && description == null) {
            throw new IllegalArgumentException("An argument match source provider cannot have a null description.");
        }
        this.type = type;
        this.description = description;
    }

    public ArgumentMatchSourceType getType() {
        return this.type;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ArgumentMatchSource that = (ArgumentMatchSource)o;
        return this.type == that.type && (this.description == null ? that.description == null : this.description.equals(that.description));
    }

    public int hashCode() {
        int result = this.type != null ? this.type.hashCode() : 0;
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        return result;
    }

    @Override
    public int compareTo(ArgumentMatchSource that) {
        String d2;
        int comp = this.type.compareTo(that.type);
        if (comp != 0) {
            return comp;
        }
        String d1 = this.description;
        if (d1 == null ^ (d2 = that.description) == null) {
            return d1 == null ? -1 : 1;
        }
        return d1 == null ? 0 : d1.compareTo(d2);
    }
}

