/*
**********************************************************************
**	File Name : dc395x_trm.h
**				
**  TEKRAM DC395U/UW/F ,DC315/U
**  PCI SCSI Bus Master Host AdapterDevice Driver
**  (SCSI chip set used Tekram ASIC TRM-S1040)
**		    				 
**********************************************************************
*/

/*
*****************************************************
**    Tekram TRM_S1040 for DC395x driver, header file
*****************************************************
*/
#ifndef DC395x_trm_H
#define DC395x_trm_H

#define DC395x_BANNER "Tekram DC395U/UW/F DC315/U"
#define DC395x_VERSION "1.09, 1999/07/18"

/* Kernel version autodetection */
#include <linux/version.h>
#ifndef KERNEL_VERSION
# define KERNEL_VERSION(V, P, S)	(((V) << 16) + ((P) << 8) + (S))
#endif

//-----------------------------------------------------
#if LINUX_VERSION_CODE < KERNEL_VERSION(1,3,50)
       #define VERSION_ELF_1_2_13
#elseif LINUX_VERSION_CODE < KERNEL_VERSION(1,3,95)
       #define VERSION_1_3_85
#else
       #define VERSION_2_0_0
#endif

#define DC395x_trm_MAX_CMD_QUEUE	20
#define DC395x_trm_MAX_QTAGS		32 
#define DC395x_trm_MAX_ADAPTER_NUM	4
#define DC395x_trm_MAX_TARGETS_NUM	16
#define DC395x_trm_MAX_SCSI_ID		16
#define DC395x_trm_MAX_CAN_QUEUE	7 * DC395x_trm_MAX_QTAGS 
#define DC395x_trm_MAX_CMD_PER_LUN	DC395x_trm_MAX_QTAGS 
#define DC395x_trm_MAX_SG_TABLESIZE	64 
#define DC395x_trm_MAX_SG_LISTENTRY	64
#define DC395x_trm_MAX_SRB_CNT		DC395x_trm_MAX_CMD_QUEUE+4
#define DC395x_trm_END_SCAN		2
#define DC395x_trm_SEL_TIMEOUT		153	/* 250 ms selection timeout (@ 40 MHz) */

#if defined(HOSTS_C) || defined(MODULE)

# include <scsi/scsicam.h>

extern  int DC395x_trm_detect(Scsi_Host_Template *psht);
extern  int DC395x_trm_queue_command(Scsi_Cmnd *cmd, void (*done)(Scsi_Cmnd *));
extern  int DC395x_trm_abort(Scsi_Cmnd *cmd);
extern  int DC395x_trm_reset(Scsi_Cmnd *cmd ,unsigned int resetFlags);
extern  int DC395x_trm_bios_param(Disk *disk, kdev_t devno, int geom[]);
//--------------
# ifdef  MODULE
static  int DC395x_trm_release(struct Scsi_Host *);
# else
#  define DC395x_trm_release NULL
# endif
//--------------
# ifndef VERSION_ELF_1_2_13
extern  struct proc_dir_entry DC395x_trm_proc_scsi;
extern  int DC395x_trm_proc_info(char*, char**, off_t, int, int, int);
# endif
//--------------

#if LINUX_VERSION_CODE < KERNEL_VERSION (2,1,70)
# define NO_NEW_EH
#else
# define NO_NEW_EH use_new_eh_code: 0,
#endif

#define DC395x_TRMS1040  {						\
		proc_dir:	&DC395x_trm_proc_scsi,			\
		proc_info:	DC395x_trm_proc_info,			\
		name:		DC395x_BANNER " V" DC395x_VERSION,	\
		detect:		DC395x_trm_detect,			\
		release:	DC395x_trm_release,			\
		queuecommand:	DC395x_trm_queue_command,		\
		abort:		DC395x_trm_abort,			\
		reset:		DC395x_trm_reset,			\
		bios_param:	DC395x_trm_bios_param,			\
		can_queue:	DC395x_trm_MAX_CAN_QUEUE,		\
		this_id:	7,					\
		sg_tablesize:	DC395x_trm_MAX_SG_TABLESIZE,		\
		cmd_per_lun:	DC395x_trm_MAX_CMD_PER_LUN,		\
		NO_NEW_EH						\
		unchecked_isa_dma: 0,					\
		use_clustering:	DISABLE_CLUSTERING			\
		}
#endif /* defined(HOSTS_C) || defined(MODULE) */
#endif /* DC395x_trm_H */
