//  
//  Copyright (c) 1994 by Mike Romberg (  romberg@md.fsl.noaa.gov )
//
//  This file may be distributed under terms of the GPL
//

#include "memmeter.h"
#include <unistd.h>

static const char COLORS[4][33] = { "blue", "yellow", "red", "green" };


MemMeter::MemMeter( XOSView *parent, int x, int y, int width, int height )
: FieldMeter( parent, x, y, width, height, 4, "MEM", "TEXT/USED/OTHER/FREE" ){
  for ( int i = 0 ; i < numfields_ ; i++ )
    setfieldcolor( i, COLORS[i] );

  struct pst_static pststatic;

  pstat_getstatic( &pststatic, sizeof( struct pst_static ), 1, 0 );
  total_ = pststatic.physical_memory;

  stats_ = new struct pst_status[pststatic.max_proc];
}

MemMeter::~MemMeter( void ){
  delete[] stats_;
}

void MemMeter::checkevent( void ){
  static int pass = 0;

  pass = (pass + 1)%5;
  if ( pass != 0 )
    return;
  
  getmeminfo();
  drawfields();
}

void MemMeter::getmeminfo( void ){
  struct pst_dynamic stats;

  pstat_getdynamic( &stats, sizeof( pst_dynamic ), 128, 128 );

  fields_[0] = stats.psd_rmtxt;
  fields_[1] = stats.psd_rm - stats.psd_rmtxt;
  fields_[2] = total_ - fields_[0] - fields_[1] - stats.psd_free;
  fields_[3] = stats.psd_free;
}


