/* Copyright (C) 1994 
            Olav Woelfelschneider (wosch@rbg.informatik.th-darmstadt.de)

 This library is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <X11/Xlib.h>
#include <stdio.h>
#include <string.h>
#include "McAlloc.h"
#include "McApp.h"
#include "McGadget.h"
#include "McMeter.h"

#define METER ((McMeter *)(gadget->specialInfo))
#define LED_WIDTH  10
#define LED_HEIGHT  3

/****************************************************************************/

static void MeterUpdate(McGadget *gadget, int busy, int all);
static int MeterEvent(McGadget *gadget, XEvent *event);
static void MeterCleanup(McGadget *gadget);

/****************************************************************************/

McSpecialInfo *McCreateMeter(unsigned int flags, int nleds,
				    int oyellow, int ored) {
  McMeter *meter = (McMeter *) McAlloc(sizeof(McMeter));
  meter->flags = flags;
  meter->nleds=nleds;
  meter->oyellow=oyellow;
  meter->ored=ored;
  meter->value=nleds>>1;
  
  meter->specialInfo.updateProc  = MeterUpdate;
  meter->specialInfo.eventProc   = MeterEvent;
  meter->specialInfo.cleanupProc = MeterCleanup;

  return (McSpecialInfo *)meter;
}

/****************************************************************************/

static void MeterCleanup(McGadget *gadget) {
  McFree(gadget->specialInfo);
}

/****************************************************************************/

#define METERCOLOR(clr) \
    if (col!=clr) XSetForeground(app->display, gc, app->colors[(col=clr)]);

static void MeterUpdate(McGadget *gadget, int busy, int all) {
  McMeter *meter=METER;
  McWindow *mcw=gadget->mcw;
  McApp *app=mcw->app;
  Display *display=app->display;
  int i,y,col;
  GC gc;
  XPoint points[3];

  gc=app->gc[GC_NORMAL];
  col=-1;
  y=gadget->y+(LED_HEIGHT+4)*(meter->nleds-1);
  for (i=0; i<meter->nleds; i++) {

    if (all) {
      points[0].x=gadget->x+LED_WIDTH+1;
      points[0].y=y;
      points[1].x=gadget->x;
      points[1].y=y;
      points[2].x=gadget->x;
      points[2].y=y+LED_HEIGHT+1;
      XDrawLines(display, mcw->window, app->gc[GC_BRIGHT],
		 points, 3, CoordModeOrigin);

      points[0].x=gadget->x+LED_WIDTH+1;
      points[0].y=y+1;
      points[1].x=gadget->x+LED_WIDTH+1;
      points[1].y=y+LED_HEIGHT+1;
      points[2].x=gadget->x+1;
      points[2].y=y+LED_HEIGHT+1;
      XDrawLines(display, mcw->window, app->gc[GC_DARK],
		 points, 3, CoordModeOrigin);
    }

    if (app->flags&MCAPP_COLOR) {
      if (i<meter->value) {
	if (i>=meter->ored) {
	  METERCOLOR(COL_RED);
	} else if (i>=meter->oyellow) {
	  METERCOLOR(COL_YELLOW);
	} else {
	  METERCOLOR(COL_GREEN);
	}
      } else {
	METERCOLOR(COL_WHITE);
      }
    } else {
      if (i<meter->value) {
	gc=app->gc[GC_SELECTED];
      } else {
	gc=app->gc[GC_NORMAL];
      }
    }
    
    XDrawLine(display, mcw->window, gc,
	      gadget->x+2, y+2, gadget->x+LED_WIDTH-1, y+2);

    y-=LED_HEIGHT+4;
  }

  if (app->flags&MCAPP_COLOR) {
    METERCOLOR(COL_FOREGROUND);
  }
  
}

/****************************************************************************/

static int MeterEvent(McGadget *gadget, XEvent *event) {
  return 0;
}

/****************************************************************************/

McGadget *MakeMeter(McWindow *mcw, int x, int y,
		    int nleds, int oyellow, int ored) {
  int w = LED_WIDTH+2;
  int h = (LED_HEIGHT+4)*nleds-2;
  McGadget *gad = McCreateGadget(mcw, 0, METERGADGET, x, y, w, h);

  gad->specialInfo=McCreateMeter(0, nleds, oyellow, ored);

  return gad;
}
