/*
 * Programm XBLAST V1.2.8 or higher
 * (C) by Oliver Vogel (e-mail: vogel@ikp.uni-koeln.de)
 * February 17th 1996
 * started August 1993
 *
 * File: event.c
 * event handlig routines
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public Licences as by published
 * by the Free Software Foundation; either version 2; or (at your option)
 * any later version
 *
 * This program is distributed in the hope that it will entertaining,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILTY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Publis License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.
 * 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#define _EVENT_C

#include <stdio.h>
#include <stdlib.h>
#include <sys/time.h>
#include <time.h>
#include <unistd.h>
#include <X11/X.h>
#include <X11/Xlib.h>
#include <X11/keysym.h>

#include "const.h"
#include "include.h"
#include "mytypes.h"
#include "graphics.h"
#include "maze.h"
#include "status.h"
#include "main.h"
#include "func.h"

/*
 * local constants
 */
#define ABORT_NONE   0
#define ABORT_TRUE   1
#define ABORT_CANCEL 2

/*
 * local variables for delay etc 
 */
static int last_delay = 0;
static int skip_frame = 0;
static max_skip_frame = 0;
static int SkipTime =0;
static struct timeval tv1,tv2,tvgame;
static struct timezone tzp;

/*
 * local variables for player_key etc
 */
static PlayerAction player_action[MAX_PLAYER];
DispPlayer disp_player[MAX_PLAYER];

/*
 * local prototypes
 */
#ifdef __STDC__
static int get_timer (void);
static int wait_usec (int i);
#else
static int get_timer ();
static int wait_usec ();
#endif


/*
 * public function init_delta_time
 */
#ifdef __STDC__
void 
init_timer (void)
#else
void 
init_timer ()
#endif
{
  /* init timer constants */
  last_delay     = 0;
  skip_frame     = 0;
  max_skip_frame = 1;
  SkipTime       = -FrameTime/2;
     
  /* Now including a bugfix for Solaris */
  /* send in by ianj@melko.co.uk */
  do {
    gettimeofday(&tv1,&tzp);
  } while( tv1.tv_usec >999999);
  
  tvgame = tv1;
}



/*
 * public function get_delta_time
 */
#ifdef __STDC__
static int 
get_timer (void)
#else
static int 
get_timer ()
#endif
{
  int rueck;

  do {
    gettimeofday(&tv2,&tzp);
  } while( tv2.tv_usec > 999999);
  rueck = ( 1000000*(tv2.tv_sec-tv1.tv_sec)+(tv2.tv_usec-tv1.tv_usec));
  tv1 = tv2;

  return rueck;
}



/*
 * local  function wait_micsec
 */
#ifdef __STDC__
static int 
wait_usec (int i)
#else
static int 
wait_usec (i)
     int i;
#endif
{
  static struct timeval tv;

  if (i>0) {
    tv.tv_sec = 0;
    tv.tv_usec = i;
    select(0,NULL,NULL,NULL,&tv);
  }

  return i;
}


/*
 * local function flush_all_displays
 */
#ifdef __STDC__
static void
flush_all_displays (int num_disp)
#else
static void
flush_all_displays (num_disp)
     int num_disp;
#endif
{
  int disp;
  
  for (disp=0; disp<num_disp; disp ++) {
    update_maze(disp);
    draw_sprites(disp);
    flush_pixmap(disp, num_disp, 1);
  }
}



/*
 * local function flush_all_displays
 */
#ifdef __STDC__
static void
intro_flush_all (int num_disp)
#else
static void
intro_flush_all (num_disp)
     int num_disp;
#endif
{
  int disp;
  
  for (disp=0; disp<num_disp; disp ++) {
    draw_sprites(disp);
    update_expl(disp);
    flush_pixmap(disp, num_disp, 1);
  }
}




/* 
 * local function game_expose 
 */
#ifdef __STDC__
static void 
game_expose (int disp, 
	     XExposeEvent *xev) 
#else
static void
game_expose (disp, xev)
     int disp;
     XExposeEvent *xev;
#endif
{
  flush_pixmap(disp, disp, 0);
}



/* 
 * local function game_expose 
 */
#ifdef __STDC__
static void 
no_expose (int disp, 
	   XExposeEvent *xev) 
#else
static void
no_expose (disp, xev)
     int disp;
     XExposeEvent *xev;
#endif
{
}



/*
 * local function game_key
 */
#ifdef __STDC__
static void
game_key (int disp, 
	  int keysym) 
#else
static void
game_key (disp, keysym)
     int disp; 
     int keysym; 
#endif
{
  PlayerAction *p1, *p2;

  /* set player indices */
  p1 = &(player_action[disp_player[disp].p1]);
  p2 = &(player_action[disp_player[disp].p2]);
  
  switch (keysym) {

    /* quit on Q */
#if 0
  case XK_q: 
#endif
  case XK_Escape:
    fprintf(stderr, "Quit!\n");
    exit(-1);
    break;
    
    /* pause */
  case XK_p:
  case XK_P:
    p1->pause = TRUE;
    break;

    /* 
     * player at num keys 
     */
    
    /* go up */
  case XK_KP_8:
  case XK_Up:
    p1->dir = GoUp;
    break;

    /* go right */
  case XK_KP_6:
  case XK_Right:
    p1->dir = GoRight;
    break;

    /* stop */
  case XK_KP_5:
  case XK_R11:
  case XK_Begin:
  case 0x00:
    p1->dir = GoStop;
    break;

    /* left */
  case XK_KP_4:
  case XK_Left:
    p1->dir = GoLeft;
    break;

    /* down */
  case XK_KP_2:
  case XK_Down:
    p1->dir = GoDown;
    break;

    /* drop bomb */
  case XK_KP_0:
  case XK_Insert:
    p1->bomb = TRUE;
    break;

    /* activate special */
  case XK_KP_Add:
  case XK_Return:
    p1->special = TRUE;
    break;

    /* try to abort */
  case XK_KP_Multiply:
    p1->abort = ABORT_TRUE;
    break;
    
    /* cancel abort */
  case XK_KP_Divide:
    p1->abort = ABORT_CANCEL;
    break;

    /* 
     * player at alpha keys 
     */
    
    /* go up */
  case XK_t:
  case XK_T:
    p2->dir = GoUp;
    break;

    /* go right */
  case XK_h:
  case XK_H:
    p2->dir = GoRight;
    break;

    /* stop */
  case XK_g:
  case XK_G:
    p2->dir = GoStop;
    break;

    /* left */
  case XK_f:
  case XK_F:
    p2->dir = GoLeft;
    break;

    /* down */
  case XK_b:
  case XK_B:
  case XK_v:
  case XK_V:
    p2->dir = GoDown;
    break;

    /* drop bomb */
  case XK_space:
    p2->bomb = TRUE;
    break;

    /* activate special */
  case XK_Tab:
    p2->special = TRUE;
    break;
    
    /* try to abort */
  case XK_a:
  case XK_A:
    p2->abort = ABORT_TRUE;
    break;
    
    /* cancel abort */
  case XK_z:
  case XK_Z:
    p2->abort = ABORT_CANCEL;
    break;
  }
}


/*
 * public function game_event 
 */
#ifdef __STDC__
void
game_event (int num_disp) 
#else
void
game_event (num_disp)
     int num_disp;
#endif
{
  int disp;

  /* check if frame must be skipped */
#if 0
  if (last_delay >= SkipTime) {
    /* delay to get correct frame rate */
    last_delay=wait_usec(FrameTime - get_timer() + last_delay);
    /* don't skip frame */
    set_redraw_rectangles();
    /* redraw all display */
    flush_all_displays(num_disp);
    /* check all events for all players */
    for (disp = 0; disp < num_disp; disp ++) {
      check_event(disp, game_expose, game_key);
    }
    clear_redraw_map();
    skip_frame = max_skip_frame;
  } else {
    /* skip drawing of frame */
    /* delay to get correct frame rate */
    last_delay=wait_usec(FrameTime - get_timer() + last_delay);
    /* check all events for all players */
    for (disp = 0; disp < num_disp; disp ++) {
      check_event(disp, game_expose, game_key);
    }
    skip_frame --;
  }

  /* if too much frames had to be skipped force draw ... */
  if ( (!skip_frame) && (last_delay < SkipTime) ) {
    last_delay = SkipTime;
  }

#else
  last_delay=wait_usec(FrameTime - get_timer() + last_delay);

  /* don't skip frame */
  set_redraw_rectangles();
  /* redraw all display */
  flush_all_displays(num_disp);
  /* check all events for all players */
  for (disp = 0; disp < num_disp; disp ++) {
    check_event(disp, game_expose, game_key);
  }
  clear_redraw_map();

  if ( (last_delay < SkipTime) ) {
    last_delay = SkipTime;
  }
#endif
}  


/*
 * public function intro_event 
 */
#ifdef __STDC__
void
intro_event (int num_disp)
#else
void
intro_event (num_disp)
     int num_disp;
#endif
{
  int disp;

  /* delay to get correct frame rate */
  last_delay=wait_usec(FrameTime - get_timer() + last_delay);

  set_redraw_rectangles();
  /* redraw all display */
  intro_flush_all(num_disp);
  /* check all events for all players */
  for (disp = 0; disp < num_disp; disp ++) {
    check_event(disp, game_expose, game_key);
  }
  clear_redraw_map();
}  


/*
 * public function game_event 
 */

#ifdef __STDC__
void
wait2_event (int num_disp)
#else
void
wait2_event (num_disp)
     int num_disp;
#endif
{
  int disp;

  /* delay to get correct frame rate */
  last_delay=wait_usec(FrameTime - get_timer() + last_delay);

  clear_redraw_map();
  flush_all_displays(num_disp);
  for (disp = 0; disp < num_disp; disp ++) {
    check_event(disp, game_expose, game_key);
  }
}  


/*
 * public function set_players_for_display 
 */
#ifdef __STDC__
void
set_players_for_display (int disp, 
			 int player1, 
			 int player2)
#else
void
set_players_for_display (disp, player1, player2)
     int disp;
     int player1;
     int player2;
#endif
{
#ifdef DEBUG
  fprintf(stderr, "set player (%d,%d) for display %d\n",player1,player2,disp); 
#endif
  disp_player[disp].num = (player1 == player2) ? 1 : 2;
  disp_player[disp].p1 = player1;
  disp_player[disp].p2 = player2;
}


#ifdef __STDC__
void
config_players (XBConfig *config) 
#else
void
config_players (config)
     XBConfig *config; 
#endif
{
  int i;

  for (i=0; i<config->num_disp; i++) {
    disp_player[i] = config->disp_player[i];
  }
}



/*
 * public function clear_keys
 */
#ifdef __STDC__
void
clear_keys(int num_player) 
#else
void
clear_keys(num_player) 
     int num_player;
#endif
{
  int player;

  for (player=0; player<num_player; player++) {
    player_action[player].dir     = GoDefault;
    player_action[player].bomb    = FALSE;
    player_action[player].special = FALSE;
    player_action[player].pause   = FALSE;
    player_action[player].abort   = ABORT_NONE;
  }
}



/*
 * public function game_eval_keys
 */
#ifdef __STDC__
int
game_eval_keys(int num_player, 
	       BMPlayer *player_stat,
	       PlayerStrings *p_string,
	       int *pause_mode) 
#else
int
game_eval_keys(num_player, player_stat, p_string, pause_mode) 
     int num_player;
     BMPlayer *player_stat;
     PlayerStrings *p_string;
     int *pause_mode;
#endif
{
  int player;
  BMPlayer *ps;
  PlayerAction *pa;
  int result = FALSE;
  int do_abort;

  for (player=0; player<num_player; player++) {
    ps = player_stat + player;
    pa = player_action + player;

    /* toggle pause mode */
    if (pa->pause) {
      if (*pause_mode == player) {
	/* pause mode off */
	*pause_mode = -1;
      } else if (*pause_mode == -1) {
	/* pause_mode on */
	*pause_mode = player;
      }
      result = TRUE;
    }

    /* drop bomb if needed */
    if (pa->bomb) {
      drop_bomb(player, ps, defaultBMT);
    }
    /* execute special key function */
    if (pa->special) {
      (*special_key_function)(ps, player);
    }
    /* try to abort game if needed */
    if (pa->abort == ABORT_CANCEL) {
      if ((ps->lives >0) && (ps->abort)) {
	set_message (p_string[player].abortcancel, FALSE);
      }
      ps->abort=FALSE;
    }
    if (pa->abort == ABORT_TRUE) {
      if (ps->lives>0) {
	ps->abort = TRUE;
	set_message (p_string[player].abort, FALSE);
	do_abort = TRUE;
	for (player=0;player<num_player;player++) {
	  if (player_stat[player].lives >0) {
	    do_abort &= player_stat[player].abort;
	  }
	}
	if (do_abort) {
	  /* Only if everyone agrees */
	  ignite_bombs();
	  set_message("* * Level Aborted * *", TRUE);
	  for (player=0;player<num_player;player++) {
	    if (player_stat[player].lives > 0) {
	      player_stat[player].lives = 1;
	      player_stat[player].dying = DEAD_TIME;
	    }
	  }
	}
      }
    }

    /* get direction */
    if (pa->dir != GoDefault) {
      /* reverse direction  if player is ill */
      if (ps->illness == IllReverse) {
	switch (pa->dir) {
	case GoUp:
	  pa->dir = GoDown;
	  break;
	case GoDown:
	  pa->dir = GoUp;
	  break;
	case GoLeft:
	  pa->dir = GoRight;
	  break;
	case GoRight:
	  pa->dir = GoLeft;
	  break;
	}
      }
      /* set new course */
      ps->d_soll = pa->dir;
      /* look if player reverts course */
      switch (ps->d_ist) {
      case GoUp:
	if (GoDown == ps->d_soll) {
	  ps->d_ist = GoDown;
	}
	break;
      case GoDown:
	if (GoUp == ps->d_soll) {
	  ps->d_ist = GoUp;
	}
	break;
      case GoRight:
	if (GoLeft == ps->d_soll) {
	  ps->d_ist = GoLeft;
	}
	break;
      case GoLeft:
	if (GoRight == ps->d_soll) {
	  ps->d_ist = GoRight;
	}
	break;
      }
    }
    
    /* clear action struct */
    pa->dir     = GoDefault;
    pa->bomb    = FALSE;
    pa->special = FALSE;
    pa->pause   = FALSE;
    pa->abort   = ABORT_NONE;
  }

  return result;
}


#ifdef __STDC__
int
wait_eval_keys (int num_player)
#else
int
wait_eval_keys (num_player)
     int num_player;
#endif
{
  int player;
  PlayerAction *pa;
  int result = 0;

  for (player=0; player<num_player; player ++) {
    pa = player_action + player;

    /* bit 0 shifted by player number for resulr mask */
    result |= ((pa->bomb) << player);

    /* clear action struct */
    pa->dir     = GoDefault;
    pa->bomb    = FALSE;
    pa->special = FALSE;
    pa->pause   = FALSE;
  }

  return result;
}



/* 
 * public function fade_in 
 */
#ifdef __STDC__
void 
fade_in (int num_disp)
#else
void 
fade_in (num_disp)
     int num_disp;
#endif
{
  int disp;
  int count;
  count = FADE_STEP;

  init_timer();
  last_delay = 0;

  while (count > 1) {
    init_fade(count);
    last_delay=wait_usec(FrameTime - get_timer() + last_delay);
    for (disp=0; disp < num_disp; disp++) {
      fade_in_window(disp, num_disp);
    }
    for (disp = 0; disp < num_disp; disp ++) {
      check_event(disp, game_expose, game_key);
    }
    count /= 2;
  }
}


/* 
 * public function fade_in 
 */
#ifdef __STDC__
void 
fade_out (int num_disp)
#else
void 
fade_out (num_disp)
     int num_disp;
#endif
{
  int disp;
  int count;
  count = FADE_STEP;

  init_timer();
  last_delay = 0;

  while (count > 1) {
    init_fade(count);
    last_delay=wait_usec(FrameTime - get_timer() + last_delay);
    for (disp=0; disp < num_disp; disp++) {
      fade_out_window(disp, num_disp);
    }
    for (disp = 0; disp < num_disp; disp ++) {
      check_event(disp, no_expose, game_key);
    }
    count /= 2;
  }
}



/*
 * public function circle_in
 */
#ifdef __STDC__
void
circle_in (int num_disp)
#else
void
circle_in (num_disp)
     int num_disp;
#endif
{
  int disp, radius;

  init_timer();
  
  for (radius = BLOCK_WIDTH/4; radius < 9*BLOCK_WIDTH; radius+=BLOCK_WIDTH/4) {
    last_delay=wait_usec(FrameTime - get_timer() + last_delay);
    for (disp=0; disp<num_disp; disp ++) {
      draw_circle_from_pixmap(disp, PIXW/2, PIXH/2, radius);
    }
    for (disp = 0; disp < num_disp; disp ++) {
      check_event(disp, game_expose, game_key);
    }
  }
}



/* 
 * public function wait_two_text 
 */
#ifdef __STDC__
void 
wait2_two_text (int num_disp,
		int num_player,
		char *text1, 
		char *text2)
#else
void 
wait2_two_text (num_disp, num_player, text1, text2)
     int num_disp;
     int num_player;
     char *text1, *text2;
#endif
{
  int count;

  set_message (text1,TRUE);
  
  init_timer();
  count = 0;
  do {
    count ++;
    if (count & 0x1f) {
      mark_maze(4, MAZE_H, 10, MAZE_H);
      if (count & 0x20) {
	set_message(text2,TRUE);
      } else {
	set_message(text1,TRUE);
      }
    }
    /* update status bar */
    update_status_bar (player_stat, game_time);
    game_event(num_disp);
  } while (!wait_eval_keys(num_player));
  reset_message();
}


/*
 * end of file event.c
 */

