/*
 * pam_delay.c
 *
 * Written by Andrew G. Morgan <morgan@physics.ucla.edu> 1996/7/4
 *
 * $Id: pam_delay.c,v 1.1 1996/07/08 00:07:07 morgan Exp $
 *
 * $Log: pam_delay.c,v $
 * Revision 1.1  1996/07/08 00:07:07  morgan
 * Initial revision
 *
 */

/*
 * this file is likely to change. Currently it is a simple
 * implementation of a delay on failure mechanism; an attempt to
 * overcome authentication-time attacts in a simple manner.
 */

#ifdef PAM_FAIL_DELAY_ON

#include <unistd.h>
#include "pam_private.h"

#ifdef DEBUG
#define D(x) _pam_debug x
#else
#define D(x)
#endif

/* **********************************************************************
 * initialize the time as unset, this is set on the return from most
 * of the libpam pam_XXX calls.
 */

void _pam_reset_timer(pam_handle_t *pamh)
{
     D(("setting pamh->fail_delay.set to FALSE"));
     pamh->fail_delay.set = PAM_FALSE;
}

/* **********************************************************************
 * this function sets the start time for possible delayed failing
 *
 * Currently, it does nothing, since the delay is the longest of
 * the requested delays rounded to the nearest second.
 */

void _pam_start_timer(pam_handle_t *pamh)
{
     D(("starting timer..."));
}

/* **********************************************************************
 * the following function will eventually determine the ammount of CPU
 * time the module has already taken. It will subtract that from the
 * ammount of real time that it has been requested to sleep.
 *
 * *Currently*, the function sleeps for the rounded number of seconds that
 * are contained in pamh->fail_delay.delay  :*(
 */

void _pam_await_timer(pam_handle_t *pamh, int status)
{
     D(("waiting?..."));

     if (status != PAM_SUCCESS && pamh->fail_delay.set) {
          int delay = pamh->fail_delay.delay.tv_sec;

	  D(("will wait"));
          if (pamh->fail_delay.delay.tv_usec >= 500000) {
	       delay += 1;
	  }

	  D(("[sleep(%u)", delay));
	  while (delay > 0) {
	       D(("+sleep(%u)", delay));
	       delay = sleep(delay);
	  }
     }
     _pam_reset_timer(pamh);
     D(("waiting done"));
}

/* **********************************************************************
 * this function is known to both the module and the application, it
 * keeps a running score of the largest-requested delay so far, as
 * specified by either modules or an application.
 */

int pam_fail_delay(pam_handle_t *pamh, unsigned int usec)
{
     int largest;

     IF_NO_PAMH("pam_fail_delay",pamh,PAM_SYSTEM_ERR);

     D(("setting delay to %u",usec));

     if (pamh->fail_delay.set) {
          largest = pamh->fail_delay.delay.tv_sec * 1000000
	          + pamh->fail_delay.delay.tv_usec;
     } else {
          largest = 0;
     }

     D(("largest = %u",largest));

     if (largest < usec) {
          D(("setting largest"));
          pamh->fail_delay.set = PAM_TRUE;
	  pamh->fail_delay.delay.tv_sec  = usec / 1000000;
	  pamh->fail_delay.delay.tv_usec = usec % 1000000;
     }

     return PAM_SUCCESS;
}

#endif /* PAM_FAIL_DELAY_ON */
