/**
 *
 * $Id: ScaleP.h,v 1.2 1995/10/18 06:30:42 toshok Exp $
 * 
 * Copyright (C) 1995 Free Software Foundation, Inc.
 *
 * This file is part of the GNU LessTif Library.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 **/
 
#ifndef XM_SCALE_P_H
#define XM_SCALE_P_H

#include <Xm/Scale.h>
#include <Xm/ManagerP.h>

#ifdef __cplusplus
extern "C" {
#endif

/* Define the scale instance part */
typedef struct {
    int value;
    int maximum;
    int minimum;
    unsigned char orientation;
    unsigned char processing_direction;
    XmString title;
    XmFontList font_list;
    XFontStruct *font_struct;
    Boolean show_value;
    short decimal_points;
    Dimension scale_width;
    Dimension scale_height;
    Dimension highlight_thickness;
    Boolean highlight_on_enter;
    XtCallbackList drag_callback;
    XtCallbackList value_changed_callback;

    int last_value;
    int slider_size;
    GC foreground_GC;
    int show_value_x;
    int show_value_y;
    int show_value_width;
    int show_value_height;
    int scale_multiple;
} XmScalePart;

/* Define the full instance record */
typedef struct _XmScaleRec {
    CorePart core;
    CompositePart composite;
    ConstraintPart constraint;
    XmManagerPart manager;
    XmScalePart scale;
} XmScaleRec;

/* Define class part structure */
typedef struct {
    XtPointer extension;
} XmScaleClassPart;

/* Define the full class record */
typedef struct _XmScaleClassRec {
    CoreClassPart core_class;
    CompositeClassPart composite_class;
    ConstraintClassPart constraint_class;
    XmManagerClassPart manager_class;
    XmScaleClassPart scale_class;
} XmScaleClassRec;

/* Define the Constraint Resources */
typedef struct _XmScaleConstraintPart {
    int foo;
} XmScaleConstraintPart;

typedef struct _XmScaleConstraintRec {
    XmScaleConstraintPart scale;
} XmScaleConstraintRec, *XmScaleConstraints;

extern XmScaleClassRec xmScaleClassRec;

#define Scale_ShadowThickness(x)        2

#define Scale_HighlightThickness(x) \
    (((XmScaleWidget)(x))->scale.highlight_thickness)

#define Scale_HighlightOnEnter(x) \
    (((XmScaleWidget)(x))->scale.highlight_on_enter)

#define Scale_ForegroundGC(x) \
    (((XmScaleWidget)(x))->scale.foreground_GC)

#define Scale_Orientation(x) \
    (((XmScaleWidget)(x))->scale.orientation)

#define Scale_ProcessingDirection(x) \
    (((XmScaleWidget)(x))->scale.processing_direction)

#define Scale_DecimalPoints(x) \
    (((XmScaleWidget)(x))->scale.decimal_points)

#define Scale_ScaleWidth(x) \
    (((XmScaleWidget)(x))->scale.scale_width)

#define Scale_ScaleHeight(x) \
    (((XmScaleWidget)(x))->scale.scale_height)

#define Scale_Minimum(x) \
    (((XmScaleWidget)(x))->scale.minimum)

#define Scale_Maximum(x) \
    (((XmScaleWidget)(x))->scale.maximum)

#define Scale_Value(x) \
    (((XmScaleWidget)(x))->scale.value)

#define Scale_LastValue(x) \
    (((XmScaleWidget)(x))->scale.last_value)

#define Scale_ShowValue(x) \
    (((XmScaleWidget)(x))->scale.show_value)

#define Scale_ShowValueX(x) \
    (((XmScaleWidget)(x))->scale.show_value_x)

#define Scale_ShowValueY(x) \
    (((XmScaleWidget)(x))->scale.show_value_y)

#define Scale_ShowValueWidth(x) \
    (((XmScaleWidget)(x))->scale.show_value_width)

#define Scale_ShowValueHeight(x) \
    (((XmScaleWidget)(x))->scale.show_value_height)

#define Scale_FontList(x) \
    (((XmScaleWidget)(x))->scale.font_list)

#define Scale_FontStruct(x) \
    (((XmScaleWidget)(x))->scale.font_struct)

#define Scale_ScaleMultiple(x) \
    (((XmScaleWidget)(x))->scale.scale_multiple)

#define Scale_Title(x) \
    (((XmScaleWidget)(x))->scale.title)

#define Scale_SliderSize(x) \
    (((XmScaleWidget)(x))->scale.slider_size)

#define Scale_ValueChangedCallback(x) \
    (((XmScaleWidget)(x))->scale.value_changed_callback)

#define Scale_DragCallback(x) \
    (((XmScaleWidget)(x))->scale.drag_callback)

#ifdef __cplusplus
};
#endif

#endif /* XM_SCALE_P_H */
