#include "cs.h"	/*							UGENS6.C	*/
#include "ugens6.h"
#include <math.h>

static float	log001 = -6.9078f;	/* log(.001) */

void downset(DOWNSAMP *p)
{
	if ((p->len = (int)*p->ilen) > ksmps)
		initerror("ilen > ksmps");
}

void downsamp(DOWNSAMP *p)
{
        float	*asig, sum;
        int	len;

	if (p->len <= 1)
		*p->kr = *p->asig;
	else {
		asig = p->asig;
		sum = 0.0f;
		len = p->len;
		do sum += *asig++;
		while (--len);
		*p->kr = sum / p->len;
	}
}

void upsamp(UPSAMP *p)
{
        float	*ar, kval;
        int	nsmps = ksmps;

	ar = p->ar;
	kval = *p->ksig;
	do *ar++ = kval;
	while (--nsmps);
}

void indfset(INDIFF *p)
{
	if (*p->istor == 0.0f)
		p->prev = 0.0f;
}

void interp(INDIFF *p)
{
        float	*ar, val, incr;
        int	nsmps = ksmps;

	ar = p->rslt;
	val = p->prev;
	incr = (*p->xsig - val) / ensmps;
	do *ar++ = val += incr;
	while (--nsmps);
	p->prev = val;
}

void kntegrate(INDIFF *p)
{
	*p->rslt = p->prev += *p->xsig;
}

void integrate(INDIFF *p)
{
        float	*rslt, *asig, sum;
        int	nsmps = ksmps;

	rslt = p->rslt;
	asig = p->xsig;
	sum = p->prev;
	do *rslt++ = sum += *asig++;
	while (--nsmps);
	p->prev = sum;
}

void kdiff(INDIFF *p)
{
	*p->rslt = *p->xsig - p->prev;
	p->prev = *p->xsig;
}

void diff(INDIFF *p)
{
        float	*ar, *asig, prev;
        int	nsmps = ksmps;

	ar = p->rslt;
	asig = p->xsig;
	prev = p->prev;
	do {
		*ar++ = *asig - prev;
		prev = *asig++;
	}
	while (--nsmps);
	p->prev = prev;
}

void samphset(SAMPHOLD *p)
{
	if (!(*p->istor))
		p->state = *p->ival;
	p->audiogate = (p->XINCODE & 01) ? 1 : 0;
}

void ksmphold(SAMPHOLD *p)
{
	if (*p->xgate > 0.)
		p->state = *p->xsig;
	*p->xr = p->state;
}

void samphold(SAMPHOLD *p)
{
        float	*ar, *asig, *agate, state;
        int	nsmps = ksmps;

	ar = p->xr;
	asig = p->xsig;
	state = p->state;
	if (p->audiogate) {
		agate = p->xgate;
		do {
			if (*agate++ > 0.)
				state = *asig;
			*ar++ = state;
			asig++;
		}
		while (--nsmps);
	}
	else {
		if (*p->xgate > 0.) {
			do *ar++ = state = *asig++;
			while (--nsmps);
		}
		else {
			do *ar++ = state;
			while (--nsmps);
		}
	}
	p->state = state;
}

void delset(DELAY *p)
{
        long	npts;
        char	*auxp;

	if (*p->istor && p->auxch.auxp != NULL)
		return;
	if ((npts = (long)(*p->idlt * esr)) <= 0) {
		initerror("illegal delay time");
		return;
	}
	if ((auxp = p->auxch.auxp) == NULL || npts != p->npts) { /* new space if reqd */
		auxalloc((long)npts*sizeof(float), &p->auxch);
		auxp = p->auxch.auxp;
		p->npts = npts;
	}
	else if (!(*p->istor)) {  			/* else if requested */
	  long *lp = (long *)auxp;
		do  *lp++ = 0; 				/*   clr old to zero */
		while (--npts);
	}
	p->curp = (float *) auxp;
}

static	DELAYR	*dlrdadr;

void delrset(DELAYR *p)
{
        long	npts;
        char	*auxp;

    dlrdadr = p;				/* store structadr for delayw */
	if (*p->istor && p->auxch.auxp != NULL)
		return;
	if ((npts = (long)(*p->idlt * esr)) < ksmps) {		/* ksmps is min dely */
		initerror("illegal delay time");
		return;
	}
    if ((auxp = p->auxch.auxp) == NULL || 	/* new space if reqd */
        npts != p->npts) {
		auxalloc((long)npts*sizeof(float), &p->auxch);
		auxp = p->auxch.auxp;
		p->npts = npts;
	}
	else if (!(*p->istor)) {			/* else if requested */
	  long *lp = (long *)auxp;
		do  *lp++ = 0;				/*   clr old to zero */
		while (--npts);
	}
	p->curp = (float *) auxp;
}

void delwset(DELAYW *p)
{
	p->delayr = dlrdadr;				/* adr delayr struct */
}

void tapset(DELTAP *p)
{
	p->delayr = dlrdadr;				/* adr delayr struct */
}

void delay(DELAY *p)
{
        float	*ar, *asig, *curp, *endp;
        int	nsmps = ksmps;

	if (p->auxch.auxp==NULL) { /* RWD fix */
          initerror("delay: not initialized");
          return;
	}
	ar = p->ar;
	asig = p->asig;
	curp = p->curp;
	endp = (float *) p->auxch.endp;
	do {
		*ar++ = *curp;
		*curp = *asig++;
		if (++curp >= endp)
			curp = (float *) p->auxch.auxp;
	}
	while (--nsmps);
	p->curp = curp;					/* sav the new curp */
}

void delayr(DELAYR *p)
{
        float	*ar, *curp, *endp;
        int	nsmps = ksmps;

	if (p->auxch.auxp==NULL) { /* RWD fix */
          initerror("delayr: not initialized");
          return;
	}
	ar = p->ar;
	curp = p->curp;
	endp = (float *) p->auxch.endp;
	do {
		*ar++ = *curp++;
		if (curp >= endp)
			curp = (float *) p->auxch.auxp;
	}
	while (--nsmps);
}							/* leave old curp */

void delayw(DELAYW *p)
{
        DELAYR	*q = p->delayr;
        float	*asig, *curp, *endp;
        int	nsmps = ksmps;
	
	if (q->auxch.auxp==NULL) { /* RWD fix */
		initerror("delayw: not initialized");
		return;
	}
	asig = p->asig;
	curp = q->curp;
	endp = (float *) q->auxch.endp;
	do {
		*curp = *asig++;
		if (++curp >= endp)
			curp = (float *) q->auxch.auxp;
	}
	while (--nsmps);
	q->curp = curp;					/* now sav new curp */
}

void deltap(DELTAP *p)
{
        DELAYR	*q = p->delayr;
        float	*ar, *tap, *endp;
        int	nsmps = ksmps;
	
	if (q->auxch.auxp==NULL) { /* RWD fix */
          initerror("deltap: not initialized");
          return;
	}
	ar = p->ar;
    tap = q->curp - (long)(*p->xdlt * esr);
    while (tap < (float *) q->auxch.auxp)
		tap += q->npts;
	endp = (float *) q->auxch.endp;
	do {
		if (tap >= endp)
			tap -= q->npts;
		*ar++ = *tap++;
	}
	while (--nsmps);
}

void deltapi(DELTAP *p)
{
        DELAYR	*q = p->delayr;
        float	*ar, *tap, *prv, *begp, *endp;
        int	nsmps = ksmps;
        long	idelsmps;
	float	delsmps, delfrac;

	if (q->auxch.auxp==NULL) {
          initerror("deltapi: not initialized");
          return;
	}
	ar = p->ar;
	begp = (float *) q->auxch.auxp;
	endp = (float *) q->auxch.endp;
	if (!p->XINCODE) {
		delsmps = *p->xdlt * esr;
		idelsmps = (long)delsmps;
		delfrac = delsmps - idelsmps;
      tap = q->curp - idelsmps;
      while (tap < begp) tap += q->npts;
		do {
			if (tap >= endp)
				tap -= q->npts;
			if ((prv = tap - 1) < begp)
				prv += q->npts;
			*ar++ = *tap + (*prv - *tap) * delfrac;
			tap++;
		}
		while (--nsmps);
	}
	else {
	        float *timp = p->xdlt, *curq = q->curp;
		do {
			delsmps = *timp++ * esr;
			idelsmps = (long)delsmps;
			delfrac = delsmps - idelsmps;
        tap = curq++ - idelsmps;
        if (tap < begp) tap += q->npts;
			else if (tap >= endp)
				tap -= q->npts;
			if ((prv = tap - 1) < begp)
				prv += q->npts;
			*ar++ = *tap + (*prv - *tap) * delfrac;
		}
		while (--nsmps);
	}
}
/* ***** From Hans Mikelson ************* */
/* Delay N samples */
void deltapn(DELTAP *p)
{
  DELAYR *q = p->delayr;
  float *ar, *tap, *begp, *endp;
  int nsmps = ksmps;
  long idelsmps;
  float delsmps;

  if (q->auxch.auxp==NULL) {
    initerror("deltapn: not initialized");
    return;
  }
  ar = p->ar;
  begp = (float *) q->auxch.auxp;
  endp = (float *) q->auxch.endp;
  if (!p->XINCODE) {
    delsmps = *p->xdlt;
    idelsmps = (long)delsmps;
    tap = q->curp - idelsmps;
    while (tap < begp) tap += q->npts;
    do {
      if (tap >= endp )
        tap -= q->npts;
      if (tap < begp)
        tap += q->npts;
      *ar++ = *tap;
      tap++;
    }
    while (--nsmps);
  }
  else {
    float *timp = p->xdlt, *curq = q->curp;
    do {
      delsmps = *timp++;
      idelsmps = (long)delsmps;
      if ((tap = curq++ - idelsmps) < begp)
        tap += q->npts;
      else if (tap >= endp)
        tap -= q->npts;
      *ar++ = *tap;
    }
    while (--nsmps);
  }
}

/* **** JPff **** */
void deltap3(DELTAP *p)
{
    DELAYR	*q = p->delayr;
    float	*ar, *tap, *prv, *begp, *endp;
    int	nsmps = ksmps;
    long	idelsmps;
    float	delsmps, delfrac;

    if (q->auxch.auxp==NULL) {
      initerror("deltap3: not initialized");
      return;
    }
    ar = p->ar;
    begp = (float *) q->auxch.auxp;
    endp = (float *) q->auxch.endp;
    if (!p->XINCODE) {
      delsmps = *p->xdlt * esr;
      idelsmps = (long)delsmps;
      delfrac = delsmps - idelsmps;
      tap = q->curp - idelsmps;
      while (tap < begp) tap += q->npts;
      do {
        float ym1, y0, y1, y2;
        if (tap >= endp)
          tap -= q->npts;
        if ((prv = tap - 1) < begp)
          prv += q->npts;
        if (prv - 1 < begp) y2 = *(prv-1+q->npts);
        else                y2 = *(prv-1);
        if (tap + 1 > endp) ym1 = *(tap+1-q->npts);
        else                ym1 = *(tap+1);
        y0 = *tap; y1 = *prv;
        {
          float frsq = delfrac*delfrac;
          float frcu = frsq*ym1;
          float t1 = y2 + 3*y0;
          *ar++ = y0 + 0.5f*frcu +
            delfrac*(y1 - frcu/6.0f - t1/6.0f - ym1/3.0f) +
            frsq*delfrac*(t1/6.0f - 0.5f*y1) + frsq*(0.5f* y1 - y0);
        }
        tap++;
      }
      while (--nsmps);
    }
    else {
      float *timp = p->xdlt, *curq = q->curp;
      do {
        float ym1, y0, y1, y2;
        delsmps = *timp++ * esr;
        idelsmps = (long)delsmps;
        delfrac = delsmps - idelsmps;
        if ((tap = curq++ - idelsmps) < begp)
          tap += q->npts;
        else if (tap >= endp)
          tap -= q->npts;
        if ((prv = tap - 1) < begp)
          prv += q->npts;
        if (prv - 1 < begp) y2 = *(prv-1+q->npts);
        else                y2 = *(prv-1);
        if (tap + 1 > endp) ym1 = *(tap+1-q->npts);
        else                ym1 = *(tap+1);
        y0 = *tap; y1 = *prv;
        {
          float frsq = delfrac*delfrac;
          float frcu = frsq*ym1;
          float t1 = y2 + 3*y0;
          *ar++ = y0 + 0.5f*frcu +
            delfrac*(y1 - frcu/6.0f - t1/6.0f - ym1/3.0f) +
            frsq*delfrac*(t1/6.0f - 0.5f*y1) + frsq*(0.5f* y1 - y0);
        }
      }
      while (--nsmps);
    }
}

void del1set(DELAY1 *p)
{
	if (!(*p->istor))
		p->sav1 = 0.0f;
}

void delay1(DELAY1 *p)
{
        float	*ar, *asig;
        int	nsmps = ksmps - 1;

	ar = p->ar;
	asig = p->asig;
	*ar++ = p->sav1;
	if (nsmps) {
		do *ar++ = *asig++;
		while (--nsmps);
	}
	p->sav1 = *asig;
}

void cmbset(COMB *p)
{
        long	lpsiz, nbytes;

	if ((lpsiz = (long)(*p->ilpt * esr)) <= 0) {
		initerror("illegal loop time");
		return;
	}
	nbytes = lpsiz * sizeof(float);
	if (p->auxch.auxp == NULL || nbytes != p->auxch.size) {
		auxalloc((long)nbytes, &p->auxch);
		p->pntr = (float *) p->auxch.auxp;
		p->prvt = 0.0f;
	}
	else if (!(*p->istor)) {
	  long *fp = (long *) p->auxch.auxp;
		p->pntr = (float *) fp;
		do  *fp++ = 0;
		while (--lpsiz);
		p->prvt = 0.0f;
	}
}

void comb(COMB *p)
{
        int	nsmps = ksmps;
        float	*ar, *asig, *xp, *endp;

	if (p->auxch.auxp==NULL) { /* RWD fix */
          initerror("comb: not initialized");
          return;
	}
	if (p->prvt != *p->krvt) {
#ifdef __alpha__
	  /*
	   * The argument to exp() in the following is sometimes a small
	   * enough negative number to result in a denormal (or worse)
	   * on Alpha. So if the result would be less than 1.0e-16, we
	   * just say it's zero and don't call exp().  heh 981101
	   */
	        double exp_arg = (double)(log001 * *p->ilpt / *p->krvt);
		if (exp_arg < -36.8413615)    /* ln(1.0e-16) */
		    p->coef = 0.0f;
		else
		    p->coef = (float)exp(exp_arg);
#else
		p->coef = (float)exp((double)(log001 * *p->ilpt / *p->krvt));
#endif
		p->prvt = *p->krvt;
	}
	xp = p->pntr;
	endp = (float *) p->auxch.endp;
	ar = p->ar;
	asig = p->asig;
	do {
		*ar++ = *xp;
		*xp *= p->coef;
		*xp += *asig++;
		if (++xp >= endp)
			xp = (float *) p->auxch.auxp;
	}
	while (--nsmps);
	p->pntr = xp;
}

void alpass(COMB *p)
{
        int	nsmps = ksmps;
        float	*ar, *asig, *xp, *endp;
        float	y, z;

	if (p->auxch.auxp==NULL) { /* RWD fix */
          initerror("allpadd: not initialized");
          return;
	}
	if (p->prvt != *p->krvt) {
		p->coef = (float)exp((double)(log001 * *p->ilpt / *p->krvt));
		p->prvt = *p->krvt;
	}
	xp = p->pntr;
	endp = (float *) p->auxch.endp;
	ar = p->ar;
	asig = p->asig;
	do {
		y = *xp;
		*xp++ = z = p->coef * y + *asig++;
		*ar++ = y - p->coef * z;
		if (xp >= endp)
			xp = (float *) p->auxch.auxp;
	}
	while (--nsmps);
	p->pntr = xp;
}

static	float	revlptimes[6] ={.0297f, .0371f, .0411f, .0437f, .005f, .0017f};
static	long	revlpsiz[6];
static	long	revlpsum;

void reverbinit(void)			/* called once by oload */
{					/*  to init reverb data */
     float	*lptimp = revlptimes;
     long	*lpsizp = revlpsiz;
     int	n = 6;

     revlpsum = 0;
     do {
           *lpsizp = (long)(*lptimp++ * esr);
           revlpsum += *lpsizp++;
     }
     while (--n);
}

void rvbset(REVERB *p)
{
	if (p->auxch.auxp == NULL) {				/* if no space yet, */
	  long	*sizp = revlpsiz;
		auxalloc(revlpsum*sizeof(float),&p->auxch);	/*    allocate it   */
		p->adr1 = p->p1 = (float *) p->auxch.auxp;
		p->adr2 = p->p2 = p->adr1 + *sizp++;
		p->adr3 = p->p3 = p->adr2 + *sizp++;    	/*    & init ptrs   */
		p->adr4 = p->p4 = p->adr3 + *sizp++;
		p->adr5 = p->p5 = p->adr4 + *sizp++;
		p->adr6 = p->p6 = p->adr5 + *sizp++;
		if (p->adr6 + *sizp != (float *) p->auxch.endp) {
			printf("revlpsiz inconsistent\n");
			exit(1);
		}
		p->prvt = 0.0f;
	}
	else if (!(*p->istor)) {			/* else if istor = 0 */
	  float	*fp = p->adr1;
	  long	nn = revlpsum;
		do  *fp++ = 0.0f;			/*  clr existing spc */
		while (--nn);
		p->p1 = p->adr1;			/*  and reset	*/
		p->p2 = p->adr2;
		p->p3 = p->adr3;
		p->p4 = p->adr4;
		p->p5 = p->adr5;
		p->p6 = p->adr6;
		p->prvt = 0.0f;
	}
}

void reverb(REVERB *p)
{
        float	*asig, *p1, *p2, *p3, *p4, *p5, *p6, *ar, *endp;
	int	nsmps = ksmps;

	if (p->auxch.auxp==NULL) { /* RWD fix */
          initerror("reverb: not intialized");
          return;
	}
	if (p->prvt != *p->krvt) {
		float	*lptimp = revlptimes;
		float	logdrvt = log001 / *p->krvt;
		p->c1 = (float)exp(logdrvt * *lptimp++);
		p->c2 = (float)exp(logdrvt * *lptimp++);
		p->c3 = (float)exp(logdrvt * *lptimp++);
		p->c4 = (float)exp(logdrvt * *lptimp++);
		p->c5 = (float)exp(logdrvt * *lptimp++);
		p->c6 = (float)exp(logdrvt * *lptimp++);
	}
	p1 = p->p1;
	p2 = p->p2;
	p3 = p->p3;
	p4 = p->p4;
	p5 = p->p5;
	p6 = p->p6;
	endp = (float *) p->auxch.endp;

	ar = p->ar;
	asig = p->asig;
	do {
		float	cmbsum, y1, y2, z;
		cmbsum = *p1 + *p2 + *p3 + *p4;
		*p1 = p->c1 * *p1 + *asig;
		*p2 = p->c2 * *p2 + *asig;
		*p3 = p->c3 * *p3 + *asig;
		*p4 = p->c4 * *p4 + *asig++;
		p1++; p2++; p3++; p4++;
		y1 = *p5;
		*p5++ = z = p->c5 * y1 + cmbsum;
		y1 -= p->c5 * z;
		y2 = *p6;
		*p6++ = z = p->c6 * y2 + y1;
		*ar++ = y2 - p->c6 * z;
		if (p1 >= p->adr2)	p1 = p->adr1;
		if (p2 >= p->adr3)	p2 = p->adr2;
		if (p3 >= p->adr4)	p3 = p->adr3;
		if (p4 >= p->adr5)	p4 = p->adr4;
		if (p5 >= p->adr6)	p5 = p->adr5;
		if (p6 >= endp) 	p6 = p->adr6;
	}
	while (--nsmps);
	p->p1 = p1;
	p->p2 = p2;
	p->p3 = p3;
	p->p4 = p4;
	p->p5 = p5;
	p->p6 = p6;
}

void panset(PAN *p)
{
        FUNC *ftp;

	if ((ftp = ftfind(p->ifn)) == NULL)
		return;
	p->ftp = ftp;
	if (*p->imode)
		p->xmul = (float)ftp->flen;
	else	p->xmul = 1.0f;
	if (*p->ioffset)
		p->xoff = ftp->flen >> 1;
	else	p->xoff = 0;
}

void pan(PAN *p)
{
        float	*r1, *r2, *r3, *r4, *sigp, ch1, ch2, ch3, ch4;
        long	xndx, yndx, flen;
        int	nsmps = ksmps;
        FUNC	*ftp;

	ftp = p->ftp;
	if (ftp==NULL) {        /* RWD fix */
          initerror("pan: not initialized");
          return;
	}
	flen = ftp->flen;
	xndx = (long)(*p->kx * p->xmul) - p->xoff;
	yndx = (long)(*p->ky * p->xmul) - p->xoff;
	if (xndx < 0L || xndx > flen
	 || yndx < 0L || yndx > flen) {
	  long xt, yt, off = flen >>1;
		xt = xndx - off;
		yt = yndx - off;
		if (xt*xt > yt*yt) {
			if (xt < 0) xt = -xt;
			yndx = yt * off / xt + off;
		}
		else {
			if (yt < 0) yt = -yt;
			xndx = xt * off / yt + off;
		}
		if (xndx < 0)		xndx = 0;
		else if (xndx > flen)	xndx = flen;
		if (yndx < 0)		yndx = 0;
		else if (yndx > flen)	yndx = flen;
	}
	ch2 = *(ftp->ftable + xndx) * *(ftp->ftable + yndx);
	ch4 = *(ftp->ftable + xndx) * *(ftp->ftable + flen - yndx);
	ch1 = *(ftp->ftable + flen - xndx) * *(ftp->ftable + yndx);
	ch3 = *(ftp->ftable + flen - xndx) * *(ftp->ftable + flen - yndx);
	r1 = p->r1;
	r2 = p->r2;
	r3 = p->r3;
	r4 = p->r4;
	sigp = p->asig;
	do {
		*r1++ = *sigp * ch1;
		*r2++ = *sigp * ch2;
		*r3++ = *sigp * ch3;
		*r4++ = *sigp * ch4;
		sigp++;
	}
	while (--nsmps);
}
