/* csoundrc.c - run control file parsing for Csound */
/* Fred Floberg emng@geocities.com 12/14/98 */
/* GNU CopyLeft, etc. */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "getlongopts.h" /* For typedef of Csound_Options */

extern Csound_Options opts_n_help[];

/* Binary table lookup. Requires opts_n_help[] to be sorted by long option names */
/* Returns pointer to given option processing function, or NULL if not found. */
void *lookup(char *token)
{
	Csound_Options *opts = opts_n_help;
	int opts_index, opts_end = 0, opts_start = 0;
	int res;

	while(opts[++opts_end].opt.name != NULL);
	opts_end -= 2;

	while(opts_start <= opts_end){

		opts_index = (opts_start + opts_end) / 2;
		res = strcmp(opts[opts_index].opt.name, token);

		if(res == -1)
			opts_start = opts_index + 1;
		else if(res == 1)
			opts_end =  opts_index - 1;
		else
			return(opts[opts_index].func);
	}
	return(NULL);
}

/* Scan ~/.csoundrc, breaking lines into tokens to be passed to lookup function */
/* and call associated function with tokenized argument string in order to process the option */
void parse_rc(void)
{
	FILE *fp;
	char *cp, *envp, line[256], *lp, rcpath[256];
	void(*func)();
	int i = 0;

	if((envp = getenv("HOME")) == NULL){
		printf("$HOME envirionment variable not set.\n");
		return;
	}

	strcpy(rcpath, envp);
	strcat(rcpath, "/.csoundrc");

	if((fp = fopen(rcpath, "r")) == NULL){
		printf("Can't open %s\n", rcpath);
		return;
	}

	while(!feof(fp)){
		++i;
		if ((fgets(line, 256, fp) == NULL) || line[0] == '\n' || line[0] == '#') /* Skip comments */
			continue;

		if ((cp = strtok(line, " \t\n")) == NULL) /* Skip lines containing only whitespace */
			continue;

		if (func = lookup(cp)) { /* Send potentially valid token to lookup() */
			lp = strtok(NULL, " \t\n"); /* Extract argument, if any */
				func(lp); /* Process the option */
		} else printf("Malformed line in %s:%i: %s\n", rcpath, i, line);
	}
	fclose(fp);
}
