/* Resonant Lowpass filters by G.Maldonado */

#include <math.h>
#include "cs.h"
#include "lowpassr.h"

void lowpr_set(LOWPR *p)
{
    if (*p->istor==0.0f)
      p->ynm1 = p->ynm2 = 0.0f;
}

void lowpr(LOWPR *p)
{
    float b, k;
    float *ar, *asig, yn, ynm1, ynm2 ;
    float kfco = *p->kfco;
    float coef1, coef2;
    int	nsmps = ksmps;
		
    b = 10.0f / (*p->kres * (float)sqrt((double)kfco)) - 1.0f;
    k = 1000.0f / kfco;
    coef1 = (b+2.0f * k);
    coef2 = 1.0f/(1.0f + b + k);

    ar = p->ar;
    asig = p->asig;
    ynm1 = p->ynm1;
    ynm2 = p->ynm2;

    do {
      *ar++ = yn = (coef1 * ynm1 - k * ynm2 + *asig++) * coef2;
      ynm2 = ynm1;
      ynm1 =  yn;
    } while (--nsmps);	
    p->ynm1 = ynm1;
    p->ynm2 = ynm2;		/* And save */

}

void lowpr_setx(LOWPRX *p)
{
    int j;
    if ((p->loop = (int) (*p->ord + 0.5f)) < 1) p->loop = 4; /*default value*/
    else if (p->loop > 10)
      initerror("illegal order num. (min 1, max 10)");

    if (*p->istor!= 0)
      for (j=0; j< p->loop; j++)  p->ynm1[j] = p->ynm2[j] = 0.0f;

}

void lowprx(LOWPRX *p)
{
    float b, k;
    float *ar, *asig, yn,*ynm1, *ynm2 ;
    float coef1, coef2;
    float kfco = *p->kfco;
    int	nsmps, j;

    b = (float)(10.0f / (*p->kres * (float)sqrt((double)kfco)) - 1.0f );
    k = 1000.0f / kfco;
    coef1 = (b+2.0f *k);
    coef2=1.0f/(1.0f + b + k);
	
    ynm1 = p->ynm1;
    ynm2 = p->ynm2;
    asig = p->asig;
	
    for (j=0; j< p->loop; j++) {
      nsmps = ksmps;
      ar = p->ar;
		
      do {
	*ar++ = yn = (coef1 * *ynm1 - k * *ynm2 + *asig++) * coef2;
	*ynm2 = *ynm1;
	*ynm1 = yn;
      } while (--nsmps);
      ynm1++;
      ynm2++;
      asig= p->ar;
    }
}


void lowpr_w_sep_set(LOWPR_SEP *p)
{
    int j;
    if ((p->loop = (int) (*p->ord + 0.5)) < 1) p->loop = 4; /*default value*/
    else if (p->loop > 10)
      initerror("illegal order num. (min 1, max 10)");

    for (j=0; j< p->loop; j++)  p->ynm1[j] = p->ynm2[j] = 0.0f;
}

void lowpr_w_sep(LOWPR_SEP *p)
{
    float b, k;
    float *ar, *asig, yn,*ynm1, *ynm2 ;
    float coef1, coef2;
    float kfcobase = *p->kfco;
    float sep = (*p->sep / p->loop);
    int	nsmps, j;

    float kres = *p->kres;
    float kfco;
    ynm1 = p->ynm1;
    ynm2 = p->ynm2;
    asig = p->asig;

    for (j=0; j< p->loop; j++) {
		/*
		linfco=log((double) kfco)*ONEtoLOG2	;
		linfco = linfco + (sep / p->loop)*j;
		kfco = (float) pow(2.,linfco);
		*/
      kfco = kfcobase * (1.0f + (sep * j));
		
      b = 10.0f / ( kres * (float)sqrt((double)kfco)) - 1.0f;
      k = 1000.0f / kfco;
      coef1 = (b+2.0f *k);
      coef2 = 1.0f/(1.0f + b + k);
	
      nsmps = ksmps;
      ar = p->ar;
      do {			/* This can be speeded up avoiding indirection */
	*ar++ = yn = (coef1 * *ynm1 - k * *ynm2 + *asig++) * coef2;
	*ynm2 = *ynm1;
	*ynm1 =  yn;
      } while (--nsmps);
      ynm1++;
      ynm2++;
      asig= p->ar;
    }
}

