#include "cs.h"			/* Flanger by Maldonado, with coding
				   enhancements by JPff -- July 1998 */
#include <math.h>
#include "flanger.h"

void flanger_set (FLANGER *p)
{
	/*---------------- delay  -----------------------*/
    p->maxdelay = (unsigned long)(*p->maxd  * esr);
    auxalloc(p->maxdelay * sizeof(float), &p->aux);
    p->left = 0;
    p->yt1 = 0.0f;
    p->fmaxd = (float) p->maxdelay;
}

void flanger(FLANGER *p)
{
	/*---------------- delay -----------------------*/
    unsigned long  indx = p->left;
    float *out = p->ar;  /* assign object data to local variables   */
    float *in = p->asig;
    float maxdelay = p->fmaxd, maxdelayM1 = maxdelay-1;
    float *buf = (float *)p->aux.auxp;
    float *freq_del = p->xdel; 
    float feedback =  *p->kfeedback;
    float fv1;
    long  v2;
    long  v1;
    float *yt1= &(p->yt1);

    int	nsmps = ksmps;
   
    do {
		/*---------------- delay -----------------------*/
      buf[indx] = *in++ + (*yt1 * feedback); 
      fv1 = indx - (*freq_del++ * esr); /* Make sure inside the buffer     */
      while (fv1 < 0)    fv1 += maxdelay;
      v1 = (long)fv1;
      v2 = (fv1 < maxdelayM1)? v1+1 : 0; /*Find next sample for interpolation*/
      *out++ = *yt1 = buf[v1] + (fv1 - v1) * ( buf[v2] - buf[v1]);
      if (++indx == maxdelay) indx = 0;        /* Advance current pointer */
    } while (--nsmps);
    p->left = indx;
}

#define MAXDELAY	.2 /* 5 Hz */

void wguide1set (WGUIDE1 *p)
{
	/*---------------- delay -----------------------*/
    auxalloc((p->maxd=(unsigned long)(MAXDELAY * esr)) * sizeof(float), &p->aux);
    p->left = 0;
	/*---------------- filter -----------------------*/
    p->c1 = p->prvhp = 0.0f;
    p->c2 = 1.0f;
    p->yt1 = 0.0f;
}

void wguide1(WGUIDE1 *p)
{
	/*---------------- delay -----------------------*/
    unsigned long  indx;
    float *out = p->ar;  /* assign object data to local variables   */
    float *in = p->asig;
    float *buf = (float *)p->aux.auxp;
    float freq_del = (1 / *p->xdel)  * esr; 
    float feedback =  *p->kfeedback;	
    float  fv1, fv2, out_delay,bufv1 ;
    long   v1;
	/*---------------- filter -----------------------*/
    float c1, c2, *yt1; 
    int	nsmps = ksmps;
	
	/*---------------- delay -----------------------*/
    indx = p->left;
	/*---------------- filter -----------------------*/
    if (*p->filt_khp != p->prvhp) {
      float b;
      p->prvhp = *p->filt_khp;
      b = 2.0f - (float)cos((double)(*p->filt_khp * tpidsr));
      p->c2 = b - (float)sqrt((double)(b * b - 1.0));
      p->c1 = 1.0f - p->c2;
    }
    c1= p->c1;  
    c2= p->c2;  
    yt1= &(p->yt1);
    do {
		/*---------------- delay -----------------------*/
      buf[indx] = *in++ + (*yt1 * feedback); 
      fv1 = indx - freq_del; /* Make sure inside the buffer     */
      while (fv1 < 0)    fv1 += p->maxd;
      fv2 = (fv1 < p->maxd-1) ? fv1 + 1 : 0;  /* Find next sample for interpolation       */
      bufv1 = buf[v1=(long)fv1];
      out_delay = bufv1 + (fv1 - v1) * ( buf[(long)fv2] - bufv1);
      if (++indx == p->maxd) indx = 0;        /* Advance current pointer */
      /*---------------- filter -----------------------*/
      *out++ = *yt1 = c1 * out_delay + c2 * *yt1;
    } while (--nsmps);
    p->left = indx;
}


void wguide2set (WGUIDE2 *p)
{
	/*---------------- delay1 -----------------------*/
    auxalloc((p->maxd = (unsigned long)(MAXDELAY * esr)) * sizeof(float), &p->aux1);
    p->left1 = 0;
	/*---------------- delay2 -----------------------*/
    auxalloc(p->maxd * sizeof(float), &p->aux2);
    p->left2 = 0;
	/*---------------- filter1 -----------------------*/
    p->c1_1 = p->prvhp1 = 0.0f;
    p->c2_1 = 1.0f;
    p->yt1_1 = 0.0f;
	/*---------------- filter2 -----------------------*/
    p->c1_2 = p->prvhp2 = 0.0f;
    p->c2_2 = 1.0f;
    p->yt1_2 = 0.0f;

    p->old_out=0.0f;

}

void wguide2(WGUIDE2 *p)
{
    float *out = p->ar;  
    float *in = p->asig;
    int	nsmps = ksmps;
    float out1,out2, *old_out = &(p->old_out);
	
    /*---------------- delay1 -----------------------*/
    unsigned long  indx1;
    float *buf1 = (float *)p->aux1.auxp;
    float freq_del1 = (1.0f / *p->xdel1)  * esr; 
    float feedback1 =  *p->kfeedback1;	 
    float  fv1_1, fv2_1, out_delay1 ;
    long   v1_1;
	/*---------------- filter1 -----------------------*/
    float c1_1, c2_1, *yt1_1; 
	/*---------------- delay2 -----------------------*/
	unsigned long  indx2;
    float *buf2 = (float *)p->aux2.auxp;
    float freq_del2 = (1.0f / *p->xdel2)  * esr;
    float feedback2 =  *p->kfeedback2;	
    float  fv1_2, fv2_2, out_delay2 ;
    long   v1_2;
	/*---------------- filter2 -----------------------*/
    float c1_2, c2_2, *yt1_2;
	/*-----------------------------------------------*/
	
    indx1 = p->left1;
    indx2 = p->left2;
    if (*p->filt_khp1 != p->prvhp1) {
      float b;
      p->prvhp1 = *p->filt_khp1;
      b = 2.0f - (float)cos((double)(*p->filt_khp1 * tpidsr));
      p->c2_1 = b - (float)sqrt((double)(b * b) - 1.0);
      p->c1_1 = 1.0f - p->c2_1;
    }
    if (*p->filt_khp2 != p->prvhp2) {
      float b;
      p->prvhp2 = *p->filt_khp2;
      b = 2.0f - (float)cos((double)(*p->filt_khp2 * tpidsr));
      p->c2_2 = b - (float)sqrt((double)(b * b) - 1.0);
      p->c1_2 = 1.0f - p->c2_2;
    }
    c1_1= p->c1_1; 
    c2_1= p->c2_1; 
    c1_2= p->c1_2; 
    c2_2= p->c2_2; 
    yt1_1= &(p->yt1_1);
    yt1_2= &(p->yt1_2);

    do {
      buf1[indx1] = buf2[indx2] =
	*in++ + (*old_out * feedback1) + (*old_out * feedback2); 
      fv1_1 = indx1 - freq_del1; /*Make sure inside the buffer     */
      fv1_2 = indx2 - freq_del2; /* Make sure inside the buffer     */
      while (fv1_1 < 0)    fv1_1 += p->maxd;
      while (fv1_2 < 0)    fv1_2 += p->maxd;
      fv2_1 = (fv1_1 < p->maxd-1) ? fv1_1 + 1 : 0;  /*Find next sample for interpolation      */
      fv2_2 = (fv1_2 < p->maxd-1) ? fv1_2 + 1 : 0;  /*Find next sample for interpolation      */
      v1_1 = (long)fv1_1;
      v1_2 = (long)fv1_2;
      out_delay1 = buf1[v1_1] + (fv1_1 - v1_1) * ( buf1[(long)fv2_1] - buf1[v1_1]);
      out_delay2 = buf2[v1_2] + (fv1_2 - v1_2) * ( buf2[(long)fv2_2] - buf2[v1_2]);
      if (++indx1 == p->maxd) indx1 = 0;        /* Advance current pointer */
      if (++indx2 == p->maxd) indx2 = 0;        /* Advance current pointer */
      out1 = *yt1_1 = c1_1 * out_delay1 + c2_1 * *yt1_1;
      out2 = *yt1_2 = c1_2 * out_delay2 + c2_2 * *yt1_2;
      *out++ = *old_out = out1 + out2;
    } while (--nsmps);
    p->left1 = indx1;
    p->left2 = indx2;
}



