#include "cs.h"                                        /*  FILOPEN.C    */
#include <ctype.h>

#ifdef macintosh
#include <unix.h>
#endif

#define	ERRSIZ	200
#define	WARNMSG	04

char	errmsg[ERRSIZ];	               /* sprintf space for compiling msgs */
static	char	*ssdirpath, *sfdirpath;
        char    *sadirpath, *retfilnam;       /* actual filename returned  */

void sssfinit(void)
{
#if defined(macintosh) || defined(SYMANTEC)
        extern char ssdir_path[], sfdir_path[], sadir_path[];
	if (ssdir_path != NULL && ssdir_path[0] != '\0')
	    ssdirpath = ssdir_path;
	else ssdirpath = NULL;
	if (sfdir_path != NULL && sfdir_path[0] != '\0')
	    sfdirpath = sfdir_path;
	else sfdirpath = NULL;
	if (sadir_path != NULL && sadir_path[0] != '\0')
	    sadirpath = sadir_path;
	else sadirpath = NULL;
#else
	char	*getenv(const char *);
	ssdirpath = getenv("SSDIR");
	sfdirpath = getenv("SFDIR");
	sadirpath = getenv("SADIR");
#endif
}

int isfullpath(char *name)
{
#if defined(macintosh) || defined(SYMANTEC)
	if (strchr(name,':') != NULL)      /* if name already a pathname */
#else
        if (
# if defined (__ZPC__) || defined (DOSGCC) || defined (LATTICE) || defined(__BORLANDC__) || defined(__WATCOMC__) || defined(WIN32)
	    (isalpha(*name) && *(name+1)==':') || 
# endif
	    *name == '/' || *name == '.')	
#endif
	  return(1);                     /*   return yes  */
	else return(0);
}

char *catpath(char *path, char *name) /*  build a fullpath filename	*/
{
        static char fullname[MAXNAME];
        sprintf(fullname,"%s%s%s",path,
#if defined(macintosh) || defined(SYMANTEC)
		":",
#else
		"/",
#endif
		name);
	return(fullname);
}

char *unquote(char *name)	/* remove any quotes from a filename   */
				/* also for THINKC rm ./ & cvt / to :  */
{
        static char newname[MAXNAME];
	char c, *old = name, *nnew = newname;
	do {
	    if ((c = *old++) != '"') {
#if defined(macintosh) || defined(SYMANTEC)
		if (nnew == newname && (c == '.' || c == '/'))
		    continue;
	        if (c == '/')  c = ':';
#endif
	        *nnew++ = c;
	    }
	} while (c);
	return(newname);
}

#if defined MSVC
#define RD_OPTS  O_RDONLY | O_BINARY
#define WR_OPTS  O_TRUNC | O_CREAT | O_WRONLY | O_BINARY,_S_IWRITE
#elif defined(macintosh) || defined(SYMANTEC) || defined(WIN32)
#define RD_OPTS  O_RDONLY | O_BINARY
#define WR_OPTS  O_TRUNC | O_CREAT | O_WRONLY | O_BINARY
#elif defined DOSGCC
#define RD_OPTS  O_RDONLY | O_BINARY, 0
#define WR_OPTS  O_TRUNC | O_CREAT | O_WRONLY | O_BINARY, 0644
#elif defined LATTICE
#define RD_OPTS  O_RDONLY | O_RAW, 0
#define WR_OPTS  O_TRUNC | O_CREAT | O_WRONLY | O_RAW, 0644
#else
#ifndef O_BINARY
# define O_BINARY (0)
#endif
#define RD_OPTS  O_RDONLY | O_BINARY, 0
#define WR_OPTS  O_TRUNC | O_CREAT | O_WRONLY | O_BINARY, 0644
#endif

int
openin(char *filnam)/* open a file for reading. If not fullpath, will search: */
		   /*  current directory, then SSDIR (if defined), then SFDIR */
{                  /*  returns normal fd, also sets a global return filename  */
                   /*  called by sndgetset (for soundin, gen01), and sfopenin */

	char *pathnam = filnam;
	int  infd;

	if (isfullpath(filnam))
	    infd = open(filnam, RD_OPTS);
	else {
	    if ((infd = open(filnam, RD_OPTS)) >= 0)
	        goto done;
	    if (ssdirpath != NULL) {
		pathnam = catpath(ssdirpath, filnam);
		if ((infd = open(pathnam, RD_OPTS)) >= 0)
		    goto done;
	    }
	    if (sfdirpath != NULL) {
		pathnam = catpath(sfdirpath, filnam);
		if ((infd = open(pathnam, RD_OPTS)) >= 0)
		    goto done;
	    }
	    dies("cannot open %s.  Not in cur dir, SSDIR or SFDIR as defined",
		      filnam);
	}
  done: retfilnam = pathnam;
	return(infd);
}

int openout(		/* open a file for writing.  If not fullpath, then  */
  char *filnam,         /*   dirtyp 1 will put it in the current directory  */
  int  dirtyp)          /*   dirtyp 2 will put it in SFDIR                  */
{                       /*   dirtyp 3 will put it in SFDIR else in cur dir  */
                        /* returns normal fd, & sets global return filename */
                        /* called by anals,dumpf (typ 1), sfopenout (typ 3) */

	char *pathnam = filnam;
	int  outfd;

	if (isfullpath(filnam))
	    outfd = open(filnam, WR_OPTS);
	else switch(dirtyp) {
	case 3:
	case 2: if (sfdirpath != NULL) {
	            pathnam = catpath(sfdirpath, filnam);
		    outfd = open(pathnam, WR_OPTS);
		    break;
		}
	        else if (dirtyp == 2)
		    dies("cannot open %s, SFDIR undefined", filnam);
	        else printf("SFDIR undefined.  using current directory\n");
	case 1: outfd = open(filnam, WR_OPTS);
	        break;
	default: die("openout: illegal dirtyp");
	}
	retfilnam = pathnam;
	return(outfd);
}

#ifdef macintosh
int openoutforin(		/* open a file for writing.  If not fullpath, then  */
  char *filnam,         /*   dirtyp 1 will put it in the current directory  */
  int  dirtyp)          /*   dirtyp 2 will put it in SFDIR                  */
{                       /*   dirtyp 3 will put it in SFDIR else in cur dir  */
                        /* returns normal fd, & sets global return filename */
                        /* called by anals,dumpf (typ 1), sfopenout (typ 3) */

	char *pathnam = filnam;
	int  outfd;

	if (isfullpath(filnam))
	    outfd = open(filnam, RD_OPTS);
	else switch(dirtyp) {
	case 3:
	case 2: if (sfdirpath != NULL) {
	            pathnam = catpath(sfdirpath, filnam);
		    outfd = open(pathnam, RD_OPTS);
		    break;
		}
	        else if (dirtyp == 2)
		    dies("cannot open %s, SFDIR undefined", filnam);
	        else printf("SFDIR undefined.  using current directory\n");
	case 1: outfd = open(filnam, RD_OPTS);
	        break;
	default: die("openout: illegal dirtyp");
	}
	retfilnam = pathnam;
	return(outfd);
}

int openrdwr(		/* open a file for writing.  If not fullpath, then  */
  char *filnam,         /*   dirtyp 1 will put it in the current directory  */
  int  dirtyp)          /*   dirtyp 2 will put it in SFDIR                  */
{                       /*   dirtyp 3 will put it in SFDIR else in cur dir  */
                        /* returns normal fd, & sets global return filename */
                        /* called by anals,dumpf (typ 1), sfopenout (typ 3) */

	char *pathnam = filnam;
	int  outfd;

	if (isfullpath(filnam))
	    outfd = open(filnam, O_RDWR);
	else switch(dirtyp) {
	case 3:
	case 2: if (sfdirpath != NULL) {
	            pathnam = catpath(sfdirpath, filnam);
		    outfd = open(pathnam, O_RDWR);
		    break;
		}
	        else if (dirtyp == 2)
		    dies("cannot open %s for read/write, SFDIR undefined", filnam);
	        else printf("SFDIR undefined.  using current directory\n");
	case 1: outfd = open(filnam, O_RDWR);
	        break;
	default: die("openwr: illegal dirtyp");
	}
	retfilnam = pathnam;
	return(outfd);
}
#endif/*  macintosh */

void warning(char *s)
{
    if (O.msglevel & WARNMSG)
	printf("WARNING: %s\n", s);
}

void dies(char *s, char *t)
{
	sprintf(errmsg,s,t);
	die(errmsg);
}

#ifndef macintosh
void die(char *s)
{
	printf("%s\n",s);
	if (dribble) fflush(dribble); /* Should not be necessary */
        exit(1);
}
#endif
