/********************************************************************************
* Copyright (c) Erik Kunze 1996 - 1999
*
* Permission to use, distribute, and sell this software and its documentation
* for any purpose is hereby granted without fee, provided that the above
* copyright notice appear in all copies and that both that copyright notice and
* this permission notice appear in supporting documentation, and that the name
* of the copyright holder not be used in advertising or publicity pertaining to
* distribution of the software without specific, written prior permission.  The
* copyright holder makes no representations about the suitability of this
* software for any purpose.  It is provided "as is" without express or implied
* warranty. THE CODE MAY NOT BE MODIFIED OR REUSED WITHOUT PERMISSION!
*
* THE COPYRIGHT HOLDER DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
* INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
* EVENT SHALL THE COPYRIGHT HOLDER BE LIABLE FOR ANY SPECIAL, INDIRECT OR
* CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
* DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
* TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
* PERFORMANCE OF THIS SOFTWARE.
*
* Author: Erik Kunze
*******************************************************************************/
#ifdef HAVE_CONFIG_H
# include "config.h"
#endif
#ifdef OSS_AUDIO
#ifndef lint
static char rcsid[] = "$Id: oss.c,v 1.16 1999/04/07 04:38:15 erik Rel $";
#endif
#include <sys/types.h>
#include <fcntl.h>
#include <sys/ioctl.h>
#include <unistd.h>
#include <signal.h>
#include SOUNDCARD_H_PATH
#include "debug.h"
#include "resource.h"
#include "util.h"
#include "audio.h"
#ifdef DEBUG
#define DEB(x)			{ if (GETCFG(debug) & D_AUDIO) { x } }
#else
#define DEB(x)
#endif
static int audioFd = -1;
static sigset_t blockingSet;
int
OsdOpenAudioDevice(char *device, int sample)
{
int fragSize, fragCount, i;
if ((audioFd = open(device, O_WRONLY | O_NONBLOCK)) < 0)
{
Msg(M_PERR, "couldn't open audio device <%s> for writing", device);
return -1;
}
fragSize = sample / 50;
for (i = 1; 1 << i < fragSize; i++);
#ifdef STEREO_AUDIO
i++;
#endif
fragSize = 1 << i;
fragCount = (sample + fragSize - 1) / fragSize;
i |= fragCount << 16;
DEB(Msg(M_DEBUG, "AU: using %d frags of %d bytes", fragCount, fragSize););
if (ioctl(audioFd, SNDCTL_DSP_SETFRAGMENT, &i) < 0)
{
Msg(M_PERR, "couldn't set fragment size");
goto error;
}
i = AFMT_U8;
if (ioctl(audioFd, SNDCTL_DSP_SETFMT, &i) < 0 || i != AFMT_U8)
{
Msg(M_PERR, "couldn't set sample resolution to 8 bit");
goto error;
}
#ifdef STEREO_AUDIO
i = 1;
if (ioctl(audioFd, SNDCTL_DSP_STEREO, &i) < 0 || i != 1)
{
Msg(M_PERR, "couldn't set stereo output");
goto error;
}
#else
i = 0;
if (ioctl(audioFd, SNDCTL_DSP_STEREO, &i) < 0 || i)
{
Msg(M_PERR, "couldn't set mono output");
goto error;
}
#endif
i = sample;
if (ioctl(audioFd, SNDCTL_DSP_SPEED, &i) < 0)
{
Msg(M_PERR, "couldn't set sample rate to %d Hz", i);
goto error;
}
sigemptyset(&blockingSet);
sigaddset(&blockingSet, SIGALRM);
return i;
error:
(void)close(audioFd);
audioFd = -1;
return -1;
}
void
OsdCloseAudioDevice(void)
{
if (audioFd != -1)
{
(void)close(audioFd);
audioFd = -1;
}
}
int
OsdDrainAudioDevice(void)
{
return (ioctl(audioFd, SNDCTL_DSP_POST, NULL));
}
size_t
OsdGetAudioFreespace(void)
{
audio_buf_info info;
if (ioctl(audioFd, SNDCTL_DSP_GETOSPACE, &info) < 0)
{
Msg(M_PERR, "couldn't get audio freespace");
return (size_t)-1;
}
return (size_t)info.bytes;
}
size_t
OsdPlayAudioBuffer(unsigned char *buf, size_t len)
{
sigset_t oldSet;
size_t written;
(void)sigprocmask(SIG_BLOCK, &blockingSet, &oldSet);
if ((written = write(audioFd, buf, len)) < 0)
{
Msg(M_PERR, "couldn't write to audio device");
}
if (!sigismember(&oldSet, SIGALRM))
{
(void)sigprocmask(SIG_UNBLOCK, &blockingSet, NULL);
}
return written;
}
#endif
