/* This file Copyright 1992 by Clifford A. Adams */
/* sathread.c
 *
 */

#include "EXTERN.h"
#include "common.h"
#ifdef SCAN
#include "cache.h"
#include "bits.h"	/* for absfirst */
#include "head.h"	/* hc_setspin() */
#include "ngdata.h"
#include "util.h"	/* savestr() */
#include "scanart.h"
#include "sadesc.h"	/* sa_desc_subject() */
#include "samain.h"
#include "samisc.h"
#include "sorder.h"
#include "INTERN.h"
#include "sathread.h"

static char **sa_threads = (char**)NULL;
static int sa_num_threads = 0;
static int sa_num_alloc = 0;

void
sa_init_threads()
{
    long i;

    if (sa_threads) {	/* from a previous group */
	for (i=0;i<sa_num_threads;i++)
	    free(sa_threads[i]);
	free(sa_threads);
    }
    sa_threads = (char **)NULL;
    sa_num_threads = sa_num_alloc = 0;
}

/* returns index into sa_threads */
int
sa_add_thread(subj)
char *subj;		/* subject to add */
{
    if (!subj)		/* pretty bad error */
	return(-2);
    if (sa_num_threads==sa_num_alloc) {
	sa_num_alloc += 100;
	sa_threads = (char**) saferealloc((char *)sa_threads,
	    sa_num_alloc*sizeof(char*));
    }
    sa_threads[sa_num_threads] = savestr(subj);
    sa_num_threads++;
    return(sa_num_threads-1);
}

/* Define SUBJ_THREAD_COMPATIBLE to compile the more compatible version
 * If it is not defined, a quick/dirty method that relies on
 * threads will be used.
 */
#define SUBJ_THREAD_COMPATIBLE /* */

/* called only if the macro didn't find a value */
long
sa_get_subj_thread(e)
long e;			/* entry number */
{
#ifdef SUBJ_THREAD_COMPATIBLE
    int i;
    char *s;
    bool old_untrim;

    old_untrim = untrim_cache;
    untrim_cache = TRUE;
    s = sa_desc_subject(e);
    untrim_cache = old_untrim;

    if (*s == '>')
	s += 2;

    for (i=0;i<sa_num_threads;i++) {
	if (strEQ(s,sa_threads[i])) {
	    sa_ents[e].subj_thread_num = i;
	    return(i);
	}
    }
    i = sa_add_thread(s);
    sa_ents[e].subj_thread_num = i;
    return(i);
#else /* !SUBJ_THREAD_COMPATIBLE */
/* this is pretty fast, but it requires threads to work. */
    int num;
    ARTICLE *artp;

    if ((num = sa_ents[e].subj_thread_num))  /* EQUALS */
	return(num);

    /* I hope no one tries a formal correctness proof on this code :-) */
    /* It could have problems if pointers can't be converted to unique
     * long ints.
     */
    artp = find_article(sa_ents[e].artnum);
    if (artp == Nullart)
	num = -1;	/* ick. */
    else
	num = (long)(artp->subj);
    if (num==0)
	num = -2;	/* cross fingers */
    sa_ents[e].subj_thread_num = num;
    return(num);
#endif
}

int
sa_subj_thread_count(a)
long a;
{
    int count;
    long b;

    count = 1;
    b = a;

    while ((b = sa_subj_thread_next(b)))
	if (sa_basic_elig(b))
	    count++;
    return(count);
}

/* returns basic_elig previous subject thread */
long
sa_subj_thread_prev(a)
long a;
{
    int i,j;

    i = sa_subj_thread(a);
    while ((a = s_prev(a))) {
	if (!sa_basic_elig(a))
	    continue;
	if (!(j = sa_ents[a].subj_thread_num))
	    j = sa_subj_thread(a);
	if (i == j)
	    return(a);
    }
    return((long)0);
}

long
sa_subj_thread_next(a)
long a;
{
    int i,j;

    i = sa_subj_thread(a);
    while ((a = s_next(a))) {
	if (!sa_basic_elig(a))
	    continue;
	if (!(j = sa_ents[a].subj_thread_num))
	    j = sa_subj_thread(a);
	if (i == j)
	    return(a);
    }
    return((long)0);
}

#endif /* SCAN */
