#include <ctype.h>
#ifndef NOMALLOC_H
#include <malloc.h>
#endif

#ifndef NULL
#define NULL 0
#endif

int *Ft_ivector(int nl, int nh)
{
	int *v;

	v=(int *)calloc((unsigned) (nh-nl+1), sizeof(int));
	if (v == (int *)NULL) {
		return(NULL);
	}
	else {
		return(v-nl);
	}
}

double *Ft_dvector(int nl, int nh)
{
	double *v;

	v=(double *)calloc((unsigned) (nh-nl+1), sizeof(double));
	if (v == (double *)NULL) {
		return(NULL);
	}
	else {
		return(v-nl);
	}
}

double **Ft_dmatrix(int nrl, int nrh, int ncl, int nch)
{
	int i;
	double **m;

	m=(double **) calloc((unsigned) (nrh-nrl+1), sizeof(double*));
	if (m == (double **)NULL) {
		return(NULL);
	}
	m -= nrl;

	for(i=nrl;i<=nrh;i++) {
		m[i]=(double *) calloc((unsigned) (nch-ncl+1), sizeof(double));
		if (m[i] == (double *)NULL) {
			while (i>=nrl) {
				free(m[i]);
				i--;
			}
			free(m);
			return(NULL);
		}
		m[i] -= ncl;
	}
	return(m);
}

void Ft_free_ivector(int *v, int nl, int nh)
{
	if (v != 0) {
		free((char*) (v+nl));
	}
	return;
}

void Ft_free_dvector(double *v, int nl, int nh)
{
	if (v != 0) {
		free((char*) (v+nl));
	}
	return;
}

void Ft_free_dmatrix(double **m, int nrl, int nrh, int ncl, int nch)
{
	int i;

	if (m != 0) {
		for(i=nrh;i>=nrl;i--) {
			free((char*) (m[i]+ncl));
		}
		free((char*) (m+nrl));
	}
	return;
}
