/*-------------- Telecommunications & Signal Processing Lab ---------------
                             McGill University

Routine:
  int AFwrI2 (AFILE *AFp, const float Fbuff[], int Nval)

Purpose:
  Write 16-bit integer data to an audio file (float input values)

Description:
  This routine writes a specified number of 16-bit integer samples to an audio
  file.  The input to this routine is a buffer of float values.

Parameters:
  <-  int AFwrI2
      Number of samples written.  If this value is less than Nval, an error
      has occurred.
   -> AFILE *AFp
      Audio file pointer for an audio file opened by AFopenWrite
   -> const float Fbuff[]
      Array of floats with the samples to be written
   -> int Nval
      Number of samples to be written

Author / revision:
  P. Kabal  Copyright (C) 1997
  $Revision: 1.31 $  $Date: 1997/10/15 13:46:27 $

-------------------------------------------------------------------------*/

static char rcsid [] = "$Id: AFwrI2.c 1.31 1997/10/15 libtsp-v3r0 $";

#include <libtsp/AFdataio.h>
#include <libtsp/Xstdio.h>
#include <libtsp/AFpar.h>
#include <libtsp/UTtypes.h>

#define LW		FDL_INT16
#define MINV(a, b)	(((a) < (b)) ? (a) : (b))
#define NBBUF		8192

#define FWRITE(buf,size,nv,fp)	(int) fwrite ((const char *) buf, \
					      (size_t) size, (size_t) nv, fp)


int
AFwrI2 (AFp, Fbuff, Nval)

     AFILE *AFp;
     const float Fbuff[];
     int Nval;

{
  int is, N, Nw, i;
  int2_t Buf[NBBUF/LW];
  int2_t *B;
  float Fv;
  unsigned char *cp;
  unsigned char t;

/* Write data to the audio file */
  is = 0;
  while (is < Nval) {
    N = MINV (NBBUF / LW, Nval - is);
    B = Buf;
    for (i = 0; i < N; ++i) {
      Fv = AFp->ScaleF * Fbuff[i+is];
      if (Fv >= 0.0) {
	Fv += 0.5;
	if (Fv >= INT2_MAX + 1) {
	  ++AFp->Novld;
	  Fv = INT2_MAX;
	}
      }
      else {
	Fv += -0.5;
	if (Fv <= INT2_MIN - 1) {
	  ++AFp->Novld;
	  Fv = INT2_MIN;
	}
      }
      *B = (int2_t) Fv;
      if (AFp->Swapb == DS_SWAP) {
	cp = (unsigned char *) B;
	t = cp[1]; cp[1] = cp[0]; cp[0] = t;
      }
      ++B;
    }
    Nw = FWRITE (Buf, LW, N, AFp->fp);
    is += Nw;
    if (Nw < N)
      break;
  }

  return is;
}
