
/* Need to turn off synchronous error signals (SIGPIPE, SIGSYS). */

#include "../scsh_aux.h"

/* Make sure our exports match up w/the implementation: */
#include "../signals1.h"

/* This table converts Unix signal numbers to S48/scsh interrupt numbers.
** If the signal doesn't have an interrupt number, the entry is -1.
** (Only asynchronous signals have interrupt numbers.)
**
** Note that we bake into this table the integer values of the signals --
** i.e., we assume that SIGHUP=1, SIGALRM=15, etc. So this definition is
** very system-dependent.
*/
const int sig2int[] = {
	-1,		/* 0 is not a signal */
	scshint_hup,	/* 1: SIGHUP */
	scshint_keyboard,	/* 2: SIGINT */
	scshint_quit,	/* 3: SIGQUIT */
	-1,		/* 4: SIGILL */
	-1,		/* 5: SIGTRAP */
	-1,		/* 6: SIGABRT SIGIOT*/
	-1,		/* 7: SIGEMT */
	-1,		/* 8: SIGFPE */
	-1,		/* 9: SIGKILL */
	-1,		/* 10: SIGBUS */
	-1,		/* 11: SIGSEGV */
	-1,		/* 12: SIGSYS */
	-1,		/* 13: SIGPIPE */
	scshint_alarm,	/* 14: SIGALRM */
	scshint_term,	/* 15: SIGTERM */
	scshint_usr1,	/* 16: SIGUSR1 */
	scshint_usr2,	/* 17: SIGUSR2 */
	scshint_chld,	/* 18: SIGCHLD SIGCHD */
	scshint_pwr,	/* 19: SIGPWR */
	scshint_winch,	/* 20: SIGWINCH */
	scshint_urg,	/* 21: SIGURG */
	scshint_io,	/* 22: SIGIO SIGPOLL */
	-1,		/* 23: SIGSTOP */
	scshint_tstp,	/* 24: SIGTSTP */
	scshint_cont,	/* 25: SIGCONT */
	-1,		/* 26: SIGTTIN */	/* scshint_ttyin */
	-1,		/* 27: SIGTTOU */	/* scshint_ttyou */
	scshint_vtalrm,	/* 28: SIGVTALRM */
	scshint_prof,	/* 29: SIGPROF */
	scshint_xcpu,	/* 30: SIGXCPU */
	scshint_xfsz	/* 31: SIGXFSZ */
	};

const int max_sig = 31; /* SIGXFSZ */
