.suffixes
# dir.mms for omniORB2 shared library
#
# Build a shared library in this directory
# **** DO NOT forget to update the $(VERSION) number.
#

# The Version number is constructed as follows:
#    <major version no.>.<minor version no.>.<micro version no.>
#
# The <minor version no.> changes when:
#   1. Public interfaces have been extended but remains backward compatible
#      with earlier minor version.
#   2. Internal interfaces have been changed.
#
# The <micro version no.> changes when the implementation has been changed
# but both the public and internal interfaces remain the same. This usually
# corresponds to a pure bug fix release.
#
# (Note that this is backwards from dir.mk since MMS has no $(word...).

major_version = 2
minor_version = 8
micro_version = 0

VERSION = $(major_version).$(minor_version).$(micro_version)

# assume that the parent directory is built and that therefore
# $(libpath)omniORB2$(DebugSuffix).olb exists.

staticlib=[-]omniORB2$(DebugSuffix).olb
shareableimage=omniORB2$(ShareableImageSuffix).exe
exportshareableimage=$(libpath)$(shareableimage)

.ifdef CXX6
OBJ_LIBS = \
omnilib:omni_share$(DebugSuffix).olb/include=omnithread_rt$(DebugSuffix)

OBJ_LIBS_DEPEND = \
$(libpath)omni_share$(DebugSuffix).olb(omnithread_rt$(DebugSuffix))

.else

# Assume that Alpha platforms are running OpenVMS 7.x

.first
	@ $(FirstActions)
.ifdef ALPHA
	@ pipe ( echo "omnilib:omnithread_rt$(DebugSuffix).exe/share" ;\
		 echo "sys$disk:[--.dynamic]omniDynamic2$(DebugSuffix).olb/lib"\
		) | type sys$input > share.opt
.endif

OBJ_LIBS = sys$disk:[]share.opt

OBJ_LIBS_DEPEND = \
$(libpath)omni_share$(DebugSuffix).olb(omnithread_rt$(DebugSuffix)) \
sys$disk:[--.dynamic]omniDynamic2$(DebugSuffix).olb

.endif

all :: $(shareableimage)

$(shareableimage) : $(staticlib) $(OBJ_LIBS_DEPEND)
	$(CxxShareableImage)

export :: all

export :: $(exportshareableimage)

$(exportshareableimage) : $(shareableimage)
	$(ExportShareable)

veryclean ::
	@- $(RM) $(shareableimage)
	@- $(RM) *.opt *.dat
